/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapType;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.common.DynmapPlayer;

public class WebAuthManager {
    private HashMap<String, String> pwdhash_by_userid = new HashMap();
    private HashMap<String, String> pending_registrations = new HashMap();
    private String hashsalt;
    private File pfile;
    public static final String WEBAUTHFILE = "webauth.txt";
    private static final String HASHSALT = "$HASH_SALT$";
    private static final String PWDHASH_PREFIX = "hash.";
    private SecureRandom rnd = new SecureRandom();
    private DynmapCore core;
    private String publicRegistrationURL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebAuthManager(DynmapCore core) {
        this.core = core;
        this.pfile = new File(core.getDataFolder(), WEBAUTHFILE);
        if (this.pfile.canRead()) {
            FileReader rf = null;
            try {
                rf = new FileReader(this.pfile);
                Properties p = new Properties();
                p.load(rf);
                this.hashsalt = p.getProperty(HASHSALT);
                for (String k : p.stringPropertyNames()) {
                    if (k.equals(HASHSALT)) {
                        this.hashsalt = p.getProperty(k);
                        continue;
                    }
                    if (!k.startsWith(PWDHASH_PREFIX)) continue;
                    this.pwdhash_by_userid.put(k.substring(PWDHASH_PREFIX.length()).toLowerCase(), p.getProperty(k));
                }
            }
            catch (IOException iox) {
                Log.severe("Cannot read webauth.txt");
            }
            finally {
                if (rf != null) {
                    try {
                        rf.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (this.hashsalt == null) {
            this.hashsalt = Long.toHexString(this.rnd.nextLong());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        boolean success = false;
        FileWriter fw = null;
        try {
            fw = new FileWriter(this.pfile);
            Properties p = new Properties();
            p.setProperty(HASHSALT, this.hashsalt);
            for (String k : this.pwdhash_by_userid.keySet()) {
                p.setProperty(PWDHASH_PREFIX + k, this.pwdhash_by_userid.get(k));
            }
            p.store(fw, "DO NOT EDIT THIS FILE");
            success = true;
        }
        catch (IOException iox) {
            Log.severe("Error writing webauth.txt");
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (success) {
            this.core.events.trigger("loginupdated", null);
        }
        return success;
    }

    private String makeHash(String pwd) {
        String check = this.hashsalt + pwd;
        try {
            byte[] checkbytes = check.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] rslt = md.digest(checkbytes);
            String rslthash = "";
            for (int i = 0; i < rslt.length; ++i) {
                rslthash = rslthash + String.format("%02X", 0xFF & rslt[i]);
            }
            return rslthash;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public boolean checkLogin(String uid, String pwd) {
        if ((uid = uid.toLowerCase()).equals("_guest_")) {
            return true;
        }
        String hash = this.pwdhash_by_userid.get(uid);
        if (hash == null) {
            return false;
        }
        if (this.core.getServer().isPlayerBanned(uid)) {
            return false;
        }
        String checkhash = this.makeHash(pwd);
        return hash.equals(checkhash);
    }

    public boolean registerLogin(String uid, String pwd, String passcode) {
        if ((uid = uid.toLowerCase()).equals("_guest_")) {
            return false;
        }
        if (this.core.getServer().isPlayerBanned(uid)) {
            return false;
        }
        passcode = passcode.toLowerCase();
        String kcode = this.pending_registrations.remove(uid);
        if (kcode == null) {
            return false;
        }
        if (!kcode.equals(passcode)) {
            return false;
        }
        String hash = this.makeHash(pwd);
        this.pwdhash_by_userid.put(uid, hash);
        return this.save();
    }

    public boolean unregisterLogin(String uid) {
        if (uid.equals("_guest_")) {
            return true;
        }
        uid = uid.toLowerCase();
        this.pwdhash_by_userid.remove(uid);
        return this.save();
    }

    public boolean isRegistered(String uid) {
        if (uid.equals("_guest_")) {
            return false;
        }
        uid = uid.toLowerCase();
        return this.pwdhash_by_userid.containsKey(uid);
    }

    boolean processCompletedRegister(String uid, String pc, String hash) {
        if ((uid = uid.toLowerCase()).equals("_guest_")) {
            return false;
        }
        if (this.core.getServer().isPlayerBanned(uid)) {
            return false;
        }
        String kcode = this.pending_registrations.remove(uid);
        if (kcode == null) {
            return false;
        }
        if (!kcode.equals(pc = pc.toLowerCase())) {
            return false;
        }
        this.pwdhash_by_userid.put(uid, hash);
        return this.save();
    }

    public static final boolean checkUserName(String name) {
        int nlen = name.length();
        if (nlen > 0 && nlen <= 16) {
            for (int i = 0; i < nlen; ++i) {
                if ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_".indexOf(name.charAt(i)) >= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean processWebRegisterCommand(DynmapCore core, DynmapCommandSender sender, DynmapPlayer player, String[] args) {
        DynmapPlayer p;
        String uid = null;
        boolean other = false;
        if (args.length > 1) {
            if (!core.checkPlayerPermission(sender, "webregister.other")) {
                sender.sendMessage("Not authorized to set web login information for other players");
                return true;
            }
            uid = args[1];
            other = true;
        } else {
            if (player == null) {
                sender.sendMessage("Must provide user ID to register web login");
                return true;
            }
            uid = player.getName();
        }
        if (!WebAuthManager.checkUserName(uid)) {
            sender.sendMessage("Invalid user ID");
            return true;
        }
        String regkey = String.format("%04d-%04d", this.rnd.nextInt(10000), this.rnd.nextInt(10000));
        this.pending_registrations.put(uid.toLowerCase(), regkey.toLowerCase());
        sender.sendMessage("Registration pending for user ID: " + uid);
        sender.sendMessage("Registration code: " + regkey);
        this.publicRegistrationURL = core.configuration.getString("publicURL", "index.html");
        sender.sendMessage("Enter ID and code on registration web page (" + this.publicRegistrationURL.toString() + ") to complete registration");
        if (other && (p = core.getServer().getPlayer(uid)) != null) {
            p.sendMessage("The registration of your account for web access has been started.");
            p.sendMessage("To complete the process, access the Login page on the Dynmap map");
            p.sendMessage("Registration code: " + regkey);
            p.sendMessage("The user ID must match your account ID, but the password should NOT be the same.");
        }
        core.events.trigger("loginupdated", null);
        return true;
    }

    String getLoginPHP(boolean wrap) {
        StringBuilder sb = new StringBuilder();
        if (wrap) {
            sb.append("<?php\n");
        }
        sb.append("$pwdsalt = '").append(this.hashsalt).append("';\n");
        sb.append("$pwdhash = array(\n");
        for (String uid : this.pwdhash_by_userid.keySet()) {
            sb.append("  '").append(WebAuthManager.esc(uid)).append("' => '").append(WebAuthManager.esc(this.pwdhash_by_userid.get(uid))).append("',\n");
        }
        sb.append(");\n");
        sb.append("$pendingreg = array(\n");
        for (String uid : this.pending_registrations.keySet()) {
            sb.append("  '").append(WebAuthManager.esc(uid)).append("' => '").append(WebAuthManager.esc(this.pending_registrations.get(uid))).append("',\n");
        }
        sb.append(");\n");
        if (wrap) {
            sb.append("?>\n");
        }
        return sb.toString();
    }

    public static String esc(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\'') {
                sb.append("\\'");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    String getAccessPHP(boolean wrap) {
        Object perm;
        StringBuilder sb = new StringBuilder();
        if (wrap) {
            sb.append("<?php\n");
        }
        ArrayList<String> mid = new ArrayList<String>();
        sb.append("$worldaccess = array(\n");
        for (DynmapWorld w : this.core.getMapManager().getWorlds()) {
            if (w.isProtected()) {
                perm = "world." + w.getName();
                sb.append("  '").append(WebAuthManager.esc(w.getName())).append("' => '");
                for (String uid : this.pwdhash_by_userid.keySet()) {
                    if (!this.core.getServer().checkPlayerPermission(uid, (String)perm)) continue;
                    sb.append("[").append(WebAuthManager.esc(uid)).append("]");
                }
                sb.append("',\n");
            }
            for (MapType mapType : w.maps) {
                if (!mapType.isProtected()) continue;
                mid.add(w.getName() + "." + mapType.getPrefix());
            }
        }
        sb.append(");\n");
        sb.append("$mapaccess = array(\n");
        for (String id : mid) {
            perm = "map." + id;
            sb.append("  '").append(WebAuthManager.esc(id)).append("' => '");
            for (String uid : this.pwdhash_by_userid.keySet()) {
                if (!this.core.getServer().checkPlayerPermission(uid, (String)perm)) continue;
                sb.append("[").append(WebAuthManager.esc(uid)).append("]");
            }
            sb.append("',\n");
        }
        sb.append(");\n");
        HashSet<String> cantseeall = new HashSet<String>();
        String perm2 = "playermarkers.seeall";
        sb.append("$seeallmarkers = '");
        for (String string : this.pwdhash_by_userid.keySet()) {
            if (this.core.getServer().checkPlayerPermission(string, perm2)) {
                sb.append("[").append(WebAuthManager.esc(string)).append("]");
                continue;
            }
            cantseeall.add(string);
        }
        sb.append("';\n");
        sb.append("$playervisible = array(\n");
        for (String string : cantseeall) {
            String string2 = string.toLowerCase();
            Set<String> vis = this.core.getPlayersVisibleToPlayer(string2);
            if (vis.size() == 1 && vis.contains(string2)) continue;
            sb.append("  '").append(WebAuthManager.esc(string2)).append("' => '");
            for (String uid : vis) {
                sb.append("[").append(WebAuthManager.esc(uid)).append("]");
            }
            sb.append("',\n");
        }
        sb.append(");\n");
        this.core.getDefaultMapStorage().addPaths(sb, this.core);
        if (wrap) {
            sb.append("?>\n");
        }
        return sb.toString();
    }

    static String getDisabledAccessPHP(DynmapCore core, boolean wrap) {
        StringBuilder sb = new StringBuilder();
        if (wrap) {
            sb.append("<?php\n");
        }
        core.getDefaultMapStorage().addPaths(sb, core);
        if (wrap) {
            sb.append("?>\n");
        }
        return sb.toString();
    }

    boolean pendingRegisters() {
        return this.pending_registrations.size() > 0;
    }

    Set<String> getUserIDs() {
        HashSet<String> lst = new HashSet<String>();
        lst.addAll(this.pwdhash_by_userid.keySet());
        lst.addAll(this.pending_registrations.keySet());
        return lst;
    }
}

