/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.common.chunk;

import java.util.Arrays;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.chunk.GenericChunkPos;
import org.dynmap.common.chunk.GenericChunkSection;
import org.dynmap.renderer.DynmapBlockState;

public class GenericChunk {
    public final int cx;
    public final int cz;
    public final GenericChunkSection[] sections;
    public final int sectionCnt;
    public final int cy_min;
    public final long inhabitedTicks;
    public final int dataVersion;
    public final String chunkStatus;
    public final boolean isEmpty;

    private GenericChunk(int cx, int cz, int cy_min, GenericChunkSection[] sections, long inhabTicks, int dataversion, String chunkstatus) {
        this.cx = cx;
        this.cz = cz;
        this.inhabitedTicks = inhabTicks;
        this.dataVersion = dataversion;
        this.chunkStatus = chunkstatus;
        this.sections = new GenericChunkSection[sections.length + 2];
        this.cy_min = cy_min - 1;
        Arrays.fill(this.sections, GenericChunkSection.EMPTY);
        boolean empty = true;
        for (int off = 0; off < sections.length; ++off) {
            if (sections[off] == null) continue;
            this.sections[off + 1] = sections[off];
            empty = empty && sections[off].isEmpty;
        }
        this.sectionCnt = sections.length;
        this.isEmpty = empty;
    }

    public final GenericChunkSection getSection(int y) {
        int idx = (y >> 4) - this.cy_min;
        if (idx < 0 || idx >= this.sectionCnt) {
            return GenericChunkSection.EMPTY;
        }
        return this.sections[idx];
    }

    public final DynmapBlockState getBlockType(int x, int y, int z) {
        return this.getSection((int)y).blocks.getBlock(x, y, z);
    }

    public final DynmapBlockState getBlockType(GenericChunkPos pos) {
        return this.getSection((int)pos.y).blocks.getBlock(pos);
    }

    public final int getBlockSkyLight(int x, int y, int z) {
        return this.getSection((int)y).sky.getLight(x, y, z);
    }

    public final int getBlockSkyLight(GenericChunkPos pos) {
        return this.getSection((int)pos.y).sky.getLight(pos);
    }

    public final int getBlockEmittedLight(int x, int y, int z) {
        return this.getSection((int)y).emitted.getLight(x, y, z);
    }

    public final int getBlockEmittedLight(GenericChunkPos pos) {
        return this.getSection((int)pos.y).emitted.getLight(pos);
    }

    public final BiomeMap getBiome(int x, int y, int z) {
        return this.getSection((int)y).biomes.getBiome(x, y, z);
    }

    public final BiomeMap getBiome(GenericChunkPos pos) {
        return this.getSection((int)pos.y).biomes.getBiome(pos);
    }

    public final boolean isSectionEmpty(int cy) {
        return this.getSection((int)(cy << 4)).isEmpty;
    }

    public final long getInhabitedTicks() {
        return this.inhabitedTicks;
    }

    public String toString() {
        return String.format("chunk(%d,%d:%s,off=%d", this.cx, this.cz, Arrays.deepToString(this.sections), this.cy_min);
    }

    public static class Builder {
        int x;
        int z;
        int y_min;
        GenericChunkSection[] sections;
        long inhabTicks;
        String chunkstatus;
        int dataversion;

        public Builder(int world_ymin, int world_ymax) {
            this.reset(world_ymin, world_ymax);
        }

        public void reset(int world_ymin, int world_ymax) {
            this.x = 0;
            this.z = 0;
            this.y_min = world_ymin >> 4;
            this.dataversion = 0;
            this.chunkstatus = null;
            int y_max = world_ymax + 15 >> 4;
            this.sections = new GenericChunkSection[y_max - this.y_min + 1];
        }

        public Builder inhabitedTicks(long inh) {
            this.inhabTicks = inh;
            return this;
        }

        public Builder addSection(int sy, GenericChunkSection sect) {
            if (sy >= this.y_min && sy - this.y_min < this.sections.length) {
                this.sections[sy - this.y_min] = sect;
            }
            return this;
        }

        public Builder coords(int sx, int sz) {
            this.x = sx;
            this.z = sz;
            return this;
        }

        public Builder generateSky() {
            int[] sky = new int[256];
            boolean[] nonOpaque = new boolean[256];
            Arrays.fill(sky, 15);
            GenericChunkSection.Builder bld = new GenericChunkSection.Builder();
            boolean allzero = false;
            for (int i = this.sections.length - 1; i >= 0; --i) {
                GenericChunkSection sect = this.sections[i];
                if (sect == null) continue;
                if (allzero) {
                    this.sections[i] = bld.buildFrom(sect, 0);
                    continue;
                }
                byte[] ssky = new byte[2048];
                int allfullcnt = 0;
                for (int y = 15; y >= 0 && !allzero; --y) {
                    boolean allfull;
                    int totalval = 0;
                    int yidx = y << 7;
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            int idx = (z << 4) + x;
                            int val = sky[idx];
                            DynmapBlockState bs = sect.blocks.getBlock(x, y, z);
                            int atten = bs.getLightAttenuation();
                            if (atten > 0 && val > 0) {
                                sky[idx] = val = val >= atten ? val - atten : 0;
                            }
                            nonOpaque[idx] = atten < 15;
                            totalval += val;
                        }
                    }
                    allzero = totalval == 0;
                    boolean bl = allfull = totalval == 3840;
                    if (allfull) {
                        ++allfullcnt;
                    }
                    if (!allfull && !allzero) {
                        boolean changed;
                        do {
                            changed = false;
                            for (int x = 0; x < 16; ++x) {
                                for (int z = 0; z < 16; ++z) {
                                    int idx = (z << 4) + x;
                                    int cur = sky[idx];
                                    boolean curnonopaq = nonOpaque[idx];
                                    if (x < 15) {
                                        int right = sky[idx + 1];
                                        boolean rightnonopaq = nonOpaque[idx + 1];
                                        if (rightnonopaq && cur - 1 > right) {
                                            sky[idx + 1] = cur - 1;
                                            changed = true;
                                        } else if (curnonopaq && cur < right - 1) {
                                            sky[idx] = cur = right - 1;
                                            changed = true;
                                        }
                                    }
                                    if (z >= 15) continue;
                                    int down = sky[idx + 16];
                                    boolean downnonopaq = nonOpaque[idx + 16];
                                    if (downnonopaq && cur - 1 > down) {
                                        sky[idx + 16] = cur - 1;
                                        changed = true;
                                        continue;
                                    }
                                    if (!curnonopaq || cur >= down - 1) continue;
                                    sky[idx] = down - 1;
                                    changed = true;
                                }
                            }
                        } while (changed);
                        for (int v = 0; v < 128; ++v) {
                            ssky[yidx | v] = (byte)(sky[v << 1] | sky[(v << 1) + 1] << 4);
                        }
                        continue;
                    }
                    if (!allfull) continue;
                    for (int v = 0; v < 128; ++v) {
                        ssky[yidx | v] = -1;
                    }
                }
                this.sections[i] = allfullcnt == 16 ? bld.buildFrom(sect, 15) : bld.buildFrom(sect, ssky);
            }
            return this;
        }

        public Builder chunkStatus(String chunkstat) {
            this.chunkstatus = chunkstat;
            return this;
        }

        public Builder dataVersion(int dataver) {
            this.dataversion = dataver;
            return this;
        }

        public GenericChunk build() {
            return new GenericChunk(this.x, this.z, this.y_min, this.sections, this.inhabTicks, this.dataversion, this.chunkstatus);
        }
    }
}

