/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.fabric_1_21_1;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2852;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3898;
import net.minecraft.class_4763;
import org.dynmap.DynmapChunk;
import org.dynmap.Log;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.chunk.GenericChunk;
import org.dynmap.common.chunk.GenericMapChunkCache;
import org.dynmap.fabric_1_21_1.DynmapPlugin;
import org.dynmap.fabric_1_21_1.FabricWorld;
import org.dynmap.fabric_1_21_1.NBT;

public class FabricMapChunkCache
extends GenericMapChunkCache {
    private class_1937 w;
    private class_3215 cps;

    public FabricMapChunkCache(DynmapPlugin plugin) {
        super(plugin.sscache);
    }

    public void setChunks(FabricWorld dw, List<DynmapChunk> chunks) {
        this.w = dw.getWorld();
        if (dw.isLoaded()) {
            class_2802 cp = this.w.method_8398();
            if (cp instanceof class_3215) {
                this.cps = (class_3215)cp;
            } else {
                Log.severe("Error: world " + dw.getName() + " has unsupported chunk provider");
            }
        }
        super.setChunks(dw, chunks);
    }

    @Override
    protected GenericChunk getLoadedChunk(DynmapChunk chunk) {
        GenericChunk gc = null;
        if (this.cps.method_12123(chunk.x, chunk.z)) {
            class_2487 nbt = null;
            try {
                nbt = class_2852.method_12410((class_3218)((class_3218)this.w), (class_2791)this.cps.method_12126(chunk.x, chunk.z, false));
            }
            catch (NullPointerException e) {
                Log.severe("ChunkSerializer.serialize threw a NullPointerException", e);
            }
            if (nbt != null) {
                gc = this.parseChunkFromNBT(new NBT.NBTCompound(nbt));
            }
        }
        return gc;
    }

    private class_2487 readChunk(int x, int z) {
        try {
            class_3898 acl = this.cps.field_17254;
            class_1923 coord = new class_1923(x, z);
            return ((Optional)acl.method_23696(coord).join()).orElse(null);
        }
        catch (Exception exc) {
            Log.severe(String.format("Error reading chunk: %s,%d,%d", this.dw.getName(), x, z), exc);
            return null;
        }
    }

    @Override
    protected GenericChunk loadChunk(DynmapChunk chunk) {
        GenericChunk gc = null;
        class_2487 nbt = this.readChunk(chunk.x, chunk.z);
        if (nbt != null) {
            gc = this.parseChunkFromNBT(new NBT.NBTCompound(nbt));
        }
        return gc;
    }

    @Override
    public int getFoliageColor(BiomeMap bm, int[] colormap, int x, int z) {
        return bm.getBiomeObject().map(class_1959::method_24377).flatMap(class_4763::method_30811).orElse(colormap[bm.biomeLookup()]);
    }

    @Override
    public int getGrassColor(BiomeMap bm, int[] colormap, int x, int z) {
        class_4763 effects = bm.getBiomeObject().map(class_1959::method_24377).orElse(null);
        if (effects == null) {
            return colormap[bm.biomeLookup()];
        }
        return effects.method_30814().method_30823((double)x, (double)z, effects.method_30812().orElse(colormap[bm.biomeLookup()]).intValue());
    }
}

