/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.fabric_1_21_1;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2478;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3317;
import net.minecraft.class_3324;
import net.minecraft.class_3335;
import net.minecraft.class_5250;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.DynmapListenerManager;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.common.DynmapServerInterface;
import org.dynmap.fabric_1_21_1.DynmapPlugin;
import org.dynmap.fabric_1_21_1.FabricMapChunkCache;
import org.dynmap.fabric_1_21_1.FabricPlayer;
import org.dynmap.fabric_1_21_1.FabricWorld;
import org.dynmap.fabric_1_21_1.TaskRecord;
import org.dynmap.fabric_1_21_1.event.BlockEvents;
import org.dynmap.fabric_1_21_1.event.ServerChatEvents;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.VisibilityLimit;

public class FabricServer
extends DynmapServerInterface {
    private final Object schedlock = new Object();
    private final DynmapPlugin plugin;
    private final MinecraftServer server;
    private final class_2378<class_1959> biomeRegistry;
    private long cur_tick;
    private long next_id;
    private long cur_tick_starttime;
    private PriorityQueue<TaskRecord> runqueue = new PriorityQueue();
    private class_1959[] biomelist = null;
    private Set<DynmapListenerManager.EventType> registered = new HashSet<DynmapListenerManager.EventType>();

    public FabricServer(DynmapPlugin plugin, MinecraftServer server) {
        this.plugin = plugin;
        this.server = server;
        this.biomeRegistry = server.method_30611().method_30530(class_7924.field_41236);
    }

    private Optional<GameProfile> getProfileByName(String player) {
        class_3312 cache = this.server.method_3793();
        return cache.method_14515(player);
    }

    public final class_2378<class_1959> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    public final class_1959[] getBiomeList(class_2378<class_1959> biomeRegistry) {
        if (this.biomelist == null) {
            this.biomelist = new class_1959[256];
            for (class_1959 b : biomeRegistry) {
                int bidx = biomeRegistry.method_10206((Object)b);
                if (bidx >= this.biomelist.length) {
                    this.biomelist = Arrays.copyOf(this.biomelist, bidx + this.biomelist.length);
                }
                this.biomelist[bidx] = b;
            }
        }
        return this.biomelist;
    }

    @Override
    public int getBlockIDAt(String wname, int x, int y, int z) {
        return -1;
    }

    @Override
    public int isSignAt(String wname, int x, int y, int z) {
        class_2338 pos;
        class_1937 world = this.plugin.getWorldByName(wname).getWorld();
        if (!world.method_22340(pos = new class_2338(x, y, z))) {
            return -1;
        }
        class_2248 block = world.method_8320(pos).method_26204();
        return block instanceof class_2478 ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleServerTask(Runnable run, long delay) {
        Object object = this.schedlock;
        synchronized (object) {
            TaskRecord tr = new TaskRecord(this.cur_tick + delay, this.next_id++, new FutureTask<Object>(run, null));
            this.runqueue.add(tr);
        }
    }

    @Override
    public DynmapPlayer[] getOnlinePlayers() {
        if (this.server.method_3760() == null) {
            return new DynmapPlayer[0];
        }
        List players = this.server.method_3760().method_14571();
        int playerCount = players.size();
        DynmapPlayer[] dplay = new DynmapPlayer[players.size()];
        for (int i = 0; i < playerCount; ++i) {
            class_3222 player = (class_3222)players.get(i);
            dplay[i] = this.plugin.getOrAddPlayer(player);
        }
        return dplay;
    }

    @Override
    public void reload() {
        this.plugin.onDisable();
        this.plugin.onEnable();
        this.plugin.onStart();
    }

    @Override
    public DynmapPlayer getPlayer(String name) {
        List players = this.server.method_3760().method_14571();
        for (class_3222 player : players) {
            if (!player.method_5477().getString().equalsIgnoreCase(name)) continue;
            return this.plugin.getOrAddPlayer(player);
        }
        return null;
    }

    @Override
    public Set<String> getIPBans() {
        class_3317 bl = this.server.method_3760().method_14585();
        HashSet<String> ips = new HashSet<String>();
        for (String s : bl.method_14636()) {
            ips.add(s);
        }
        return ips;
    }

    @Override
    public <T> Future<T> callSyncMethod(Callable<T> task) {
        return this.callSyncMethod(task, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Future<T> callSyncMethod(Callable<T> task, long delay) {
        FutureTask<T> ft = new FutureTask<T>(task);
        Object object = this.schedlock;
        synchronized (object) {
            TaskRecord tr = new TaskRecord(this.cur_tick + delay, this.next_id++, ft);
            this.runqueue.add(tr);
        }
        return ft;
    }

    void clearTaskQueue() {
        this.runqueue.clear();
    }

    @Override
    public String getServerName() {
        String sn = this.server.method_3724() ? "Integrated" : this.server.method_3819();
        if (sn == null) {
            sn = "Unknown Server";
        }
        return sn;
    }

    @Override
    public boolean isPlayerBanned(String pid) {
        class_3324 scm = this.server.method_3760();
        class_3335 bl = scm.method_14563();
        try {
            return bl.method_14650(this.getProfileByName(pid).get());
        }
        catch (NoSuchElementException e) {
            return true;
        }
    }

    @Override
    public String stripChatColor(String s) {
        return DynmapPlugin.patternControlCode.matcher(s).replaceAll("");
    }

    @Override
    public boolean requestEventNotification(DynmapListenerManager.EventType type) {
        if (this.registered.contains((Object)type)) {
            return true;
        }
        switch (type) {
            case WORLD_LOAD: 
            case WORLD_UNLOAD: {
                break;
            }
            case WORLD_SPAWN_CHANGE: {
                break;
            }
            case PLAYER_JOIN: 
            case PLAYER_QUIT: {
                break;
            }
            case PLAYER_BED_LEAVE: {
                break;
            }
            case PLAYER_CHAT: {
                if (this.plugin.chathandler != null) break;
                this.plugin.setChatHandler(new DynmapPlugin.ChatHandler(this.plugin));
                ServerChatEvents.EVENT.register((player, message) -> this.plugin.chathandler.handleChat(player, message));
                break;
            }
            case BLOCK_BREAK: {
                break;
            }
            case SIGN_CHANGE: {
                BlockEvents.SIGN_CHANGE_EVENT.register((world, pos, lines, player, front) -> this.plugin.core.processSignChange("fabric", FabricWorld.getWorldName(this.plugin, (class_1937)world), pos.method_10263(), pos.method_10264(), pos.method_10260(), lines, player.method_5477().getString()));
                break;
            }
            default: {
                Log.severe("Unhandled event type: " + String.valueOf((Object)type));
                return false;
            }
        }
        this.registered.add(type);
        return true;
    }

    @Override
    public boolean sendWebChatEvent(String source, String name, String msg) {
        return DynmapCommonAPIListener.fireWebChatEvent(source, name, msg);
    }

    @Override
    public void broadcastMessage(String msg) {
        class_5250 component = class_2561.method_43470((String)msg);
        this.server.method_3760().method_43514((class_2561)component, false);
        Log.info(this.stripChatColor(msg));
    }

    @Override
    public String[] getBiomeIDs() {
        BiomeMap[] b = BiomeMap.values();
        String[] bname = new String[b.length];
        for (int i = 0; i < bname.length; ++i) {
            bname[i] = b[i].toString();
        }
        return bname;
    }

    @Override
    public double getCacheHitRate() {
        if (this.plugin.sscache != null) {
            return this.plugin.sscache.getHitRate();
        }
        return 0.0;
    }

    @Override
    public void resetCacheStats() {
        if (this.plugin.sscache != null) {
            this.plugin.sscache.resetStats();
        }
    }

    @Override
    public DynmapWorld getWorldByName(String wname) {
        return this.plugin.getWorldByName(wname);
    }

    @Override
    public DynmapPlayer getOfflinePlayer(String name) {
        return null;
    }

    @Override
    public Set<String> checkPlayerPermissions(String player, Set<String> perms) {
        if (this.isPlayerBanned(player)) {
            return Collections.emptySet();
        }
        Set<String> rslt = this.plugin.hasOfflinePermissions(player, perms);
        if (rslt == null) {
            rslt = new HashSet<String>();
            if (this.plugin.isOp(player)) {
                rslt.addAll(perms);
            }
        }
        return rslt;
    }

    @Override
    public boolean checkPlayerPermission(String player, String perm) {
        if (this.isPlayerBanned(player)) {
            return false;
        }
        return this.plugin.hasOfflinePermission(player, perm);
    }

    @Override
    public MapChunkCache createMapChunkCache(DynmapWorld w, List<DynmapChunk> chunks, boolean blockdata, boolean highesty, boolean biome, boolean rawbiome) {
        FabricMapChunkCache c = (FabricMapChunkCache)w.getChunkCache(chunks);
        if (c == null) {
            return null;
        }
        if (w.visibility_limits != null) {
            for (VisibilityLimit limit : w.visibility_limits) {
                c.setVisibleRange(limit);
            }
            c.setHiddenFillStyle(w.hiddenchunkstyle);
        }
        if (w.hidden_limits != null) {
            for (VisibilityLimit limit : w.hidden_limits) {
                c.setHiddenRange(limit);
            }
            c.setHiddenFillStyle(w.hiddenchunkstyle);
        }
        if (!c.setChunkDataTypes(blockdata, biome, highesty, rawbiome)) {
            Log.severe("CraftBukkit build does not support biome APIs");
        }
        if (chunks.size() == 0) {
            c.loadChunks(0);
            return c;
        }
        final FabricMapChunkCache cc = c;
        Future<Boolean> f = this.callSyncMethod(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                cc.getLoadedChunks();
                return true;
            }
        }, 0L);
        try {
            f.get();
        }
        catch (CancellationException cx) {
            return null;
        }
        catch (InterruptedException cx) {
            return null;
        }
        catch (ExecutionException xx) {
            Log.severe("Exception while loading chunks", xx.getCause());
            return null;
        }
        catch (Exception ix) {
            Log.severe(ix);
            return null;
        }
        if (!w.isLoaded()) {
            return null;
        }
        c.readChunks(chunks.size());
        return c;
    }

    @Override
    public int getMaxPlayers() {
        return this.server.method_3802();
    }

    @Override
    public int getCurrentPlayers() {
        return this.server.method_3760().method_14574();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickEvent(MinecraftServer server) {
        long now;
        this.cur_tick_starttime = System.nanoTime();
        long elapsed = this.cur_tick_starttime - this.plugin.lasttick;
        this.plugin.lasttick = this.cur_tick_starttime;
        this.plugin.avgticklen = this.plugin.avgticklen * 99L / 100L + elapsed / 100L;
        this.plugin.tps = 1.0E9 / (double)this.plugin.avgticklen;
        if (this.plugin.core != null) {
            this.plugin.core.serverTick(this.plugin.tps);
        }
        boolean done = false;
        TaskRecord tr = null;
        while (!this.plugin.blockupdatequeue.isEmpty()) {
            DynmapPlugin.BlockUpdateRec r = (DynmapPlugin.BlockUpdateRec)this.plugin.blockupdatequeue.remove();
            class_2680 bs = r.w.method_8320(new class_2338(r.x, r.y, r.z));
            int idx = class_2248.field_10651.method_10206((Object)bs);
            if (HDBlockModels.isChangeIgnoredBlock(DynmapPlugin.stateByID[idx])) continue;
            if (this.plugin.onblockchange_with_id) {
                this.plugin.mapManager.touch(r.wid, r.x, r.y, r.z, "blockchange[" + idx + "]");
                continue;
            }
            this.plugin.mapManager.touch(r.wid, r.x, r.y, r.z, "blockchange");
        }
        Object idx = this.schedlock;
        synchronized (idx) {
            ++this.cur_tick;
            now = System.nanoTime();
            tr = this.runqueue.peek();
            if (tr == null || tr.getTickToRun() > this.cur_tick || now - this.cur_tick_starttime > this.plugin.perTickLimit) {
                done = true;
            } else {
                tr = this.runqueue.poll();
            }
        }
        while (!done) {
            tr.run();
            idx = this.schedlock;
            synchronized (idx) {
                tr = this.runqueue.peek();
                now = System.nanoTime();
                if (tr == null || tr.getTickToRun() > this.cur_tick || now - this.cur_tick_starttime > this.plugin.perTickLimit) {
                    done = true;
                } else {
                    tr = this.runqueue.poll();
                }
            }
        }
        while (!this.plugin.msgqueue.isEmpty()) {
            DynmapPlugin.ChatMessage cm = this.plugin.msgqueue.poll();
            FabricPlayer dp = null;
            dp = cm.sender != null ? this.plugin.getOrAddPlayer(cm.sender) : new FabricPlayer(this.plugin, null);
            this.plugin.core.listenerManager.processChatEvent(DynmapListenerManager.EventType.PLAYER_CHAT, dp, cm.message);
        }
        if (this.cur_tick % 20L == 0L) {
            // empty if block
        }
    }

    private Optional<ModContainer> getModContainerById(String id) {
        return FabricLoader.getInstance().getModContainer(id);
    }

    @Override
    public boolean isModLoaded(String name) {
        return FabricLoader.getInstance().getModContainer(name).isPresent();
    }

    @Override
    public String getModVersion(String name) {
        Optional<ModContainer> mod = this.getModContainerById(name);
        return mod.map(modContainer -> modContainer.getMetadata().getVersion().getFriendlyString()).orElse(null);
    }

    @Override
    public double getServerTPS() {
        return this.plugin.tps;
    }

    @Override
    public String getServerIP() {
        if (this.server.method_3724()) {
            return "0.0.0.0";
        }
        return this.server.method_3819();
    }

    @Override
    public File getModContainerFile(String name) {
        Optional<ModContainer> container = this.getModContainerById(name);
        if (container.isPresent()) {
            Path path = container.get().getRootPath();
            if (path.getFileSystem().provider().getScheme().equals("jar")) {
                path = Paths.get(path.getFileSystem().toString(), new String[0]);
            }
            return path.toFile();
        }
        return null;
    }

    @Override
    public List<String> getModList() {
        return FabricLoader.getInstance().getAllMods().stream().map(container -> container.getMetadata().getId()).collect(Collectors.toList());
    }

    @Override
    public Map<Integer, String> getBlockIDMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        return map;
    }

    @Override
    public InputStream openResource(String modid, String rname) {
        if (modid == null) {
            modid = "minecraft";
        }
        if ("minecraft".equals(modid)) {
            return MinecraftServer.class.getClassLoader().getResourceAsStream(rname);
        }
        if (rname.startsWith("/") || rname.startsWith("\\")) {
            rname = rname.substring(1);
        }
        String finalModid = modid;
        String finalRname = rname;
        return this.getModContainerById(modid).map(container -> {
            try {
                return Files.newInputStream(container.getPath(finalRname), new OpenOption[0]);
            }
            catch (IOException e) {
                Log.severe("Failed to load resource of mod :" + finalModid, e);
                return null;
            }
        }).orElse(null);
    }

    @Override
    public Map<String, Integer> getBlockUniqueIDMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        return map;
    }

    @Override
    public Map<String, Integer> getItemUniqueIDMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        return map;
    }
}

