/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.fabric_1_21_1.permissions;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.model.user.User;
import net.luckperms.api.util.Tristate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import org.dynmap.Log;
import org.dynmap.fabric_1_21_1.DynmapPlugin;
import org.dynmap.fabric_1_21_1.permissions.PermissionProvider;
import org.dynmap.json.simple.JSONArray;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.json.simple.parser.JSONParser;
import org.dynmap.json.simple.parser.ParseException;

public class LuckPermissions
implements PermissionProvider {
    private final JSONParser parser = new JSONParser();
    private LuckPerms api = null;

    private Optional<LuckPerms> getApi() {
        if (this.api != null) {
            return Optional.of(this.api);
        }
        try {
            this.api = LuckPermsProvider.get();
            return Optional.of(this.api);
        }
        catch (Exception ex) {
            Log.warning("Trying to access LuckPerms before it has loaded");
            return Optional.empty();
        }
    }

    private Optional<UUID> cachedUUID(String username) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader("usercache.json"));
            JSONArray cache = (JSONArray)this.parser.parse(reader);
            for (Object it : cache) {
                JSONObject user = (JSONObject)it;
                if (!user.get("name").toString().equalsIgnoreCase(username)) continue;
                String uuid = user.get("uuid").toString();
                return Optional.of(UUID.fromString(uuid));
            }
            reader.close();
        }
        catch (IOException | ParseException ex) {
            Log.warning("Unable to read usercache.json");
        }
        return Optional.empty();
    }

    private String permissionKey(String perm) {
        return "dynmap." + perm;
    }

    @Override
    public Set<String> hasOfflinePermissions(String player, Set<String> perms) {
        return perms.stream().filter(perm -> this.hasOfflinePermission(player, (String)perm)).collect(Collectors.toSet());
    }

    @Override
    public boolean hasOfflinePermission(String player, String perm) {
        if (DynmapPlugin.plugin.isOp(player.toLowerCase())) {
            return true;
        }
        Optional<LuckPerms> api = this.getApi();
        Optional<UUID> uuid = this.cachedUUID(player);
        if (!uuid.isPresent() || !api.isPresent()) {
            return false;
        }
        User user = (User)api.get().getUserManager().loadUser(uuid.get()).join();
        CachedPermissionData permissions = user.getCachedData().getPermissionData();
        Tristate state = permissions.checkPermission(this.permissionKey(perm));
        return state.asBoolean();
    }

    @Override
    public boolean has(class_1657 player, String permission) {
        if (player == null) {
            return false;
        }
        String name = player.method_5477().getString().toLowerCase();
        if (DynmapPlugin.plugin.isOp(name)) {
            return true;
        }
        return Permissions.check((class_1297)player, (String)this.permissionKey(permission));
    }

    @Override
    public boolean hasPermissionNode(class_1657 player, String permission) {
        if (player != null) {
            String name = player.method_5477().getString().toLowerCase();
            return DynmapPlugin.plugin.isOp(name);
        }
        return false;
    }
}

