/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.JSONUtils;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.exporter.OBJExport;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShader;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynLongHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;

public class ChunkStatusHDShader
implements HDShader {
    private final String name;
    private static HashMap<String, ChunkStatusMap> statusmap = new HashMap();
    static final Color unknown_color;
    private ArrayList<String> unknown_state = new ArrayList();
    private static final String[] nulllist;

    public ChunkStatusHDShader(DynmapCore core, ConfigurationNode configuration) {
        this.name = (String)configuration.get("name");
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return true;
    }

    @Override
    public boolean isSkyLightLevelNeeded() {
        return false;
    }

    @Override
    public boolean isEmittedLightLevelNeeded() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HDShaderState getStateInstance(HDMap map, MapChunkCache cache, MapIterator mapiter, int scale) {
        return new OurShaderState(mapiter, map, cache, scale);
    }

    @Override
    public void addClientConfiguration(JSONObject mapObject) {
        JSONUtils.s(mapObject, "shader", this.name);
    }

    @Override
    public void exportAsMaterialLibrary(DynmapCommandSender sender, OBJExport out) throws IOException {
        throw new IOException("Export unsupported");
    }

    @Override
    public String[] getCurrentBlockMaterials(DynmapBlockState blk, MapIterator mapiter, int[] txtidx, BlockStep[] steps) {
        return nulllist;
    }

    static {
        new ChunkStatusMap("empty", 0xFF0000);
        new ChunkStatusMap("structure_starts", 16716947);
        new ChunkStatusMap("structure_references", 16744272);
        new ChunkStatusMap("biomes", 16753920);
        new ChunkStatusMap("noise", 16766720);
        new ChunkStatusMap("surface", 0xFFFF00);
        new ChunkStatusMap("carvers", 16773077);
        new ChunkStatusMap("liquid_carvers", 15787660);
        new ChunkStatusMap("features", 12433259);
        new ChunkStatusMap("light", 0xDDA0DD);
        new ChunkStatusMap("spawn", 0xFF00FF);
        new ChunkStatusMap("heightmaps", 9662683);
        new ChunkStatusMap("full", 3329330);
        unknown_color = new Color(255, 255, 255);
        nulllist = new String[0];
    }

    private class OurShaderState
    implements HDShaderState {
        private Color[] color;
        private Color c;
        protected HDMap map;
        private HDLighting lighting;
        final int[] lightingTable;

        private OurShaderState(MapIterator mapiter, HDMap map, MapChunkCache cache, int scale) {
            this.map = map;
            this.lighting = map.getLighting();
            this.color = this.lighting.isNightAndDayEnabled() ? new Color[]{new Color(), new Color()} : new Color[]{new Color()};
            this.c = new Color();
            this.lightingTable = (int[])(MapManager.mapman.useBrightnessTable() ? cache.getWorld().getBrightnessTable() : null);
        }

        @Override
        public HDShader getShader() {
            return ChunkStatusHDShader.this;
        }

        @Override
        public HDMap getMap() {
            return this.map;
        }

        @Override
        public HDLighting getLighting() {
            return this.lighting;
        }

        @Override
        public void reset(HDPerspectiveState ps) {
            for (int i = 0; i < this.color.length; ++i) {
                this.color[i].setTransparent();
            }
        }

        @Override
        public boolean processBlock(HDPerspectiveState ps) {
            if (ps.getBlockState().isAir()) {
                return false;
            }
            String cs = ps.getMapIterator().getChunkStatus();
            ChunkStatusMap csm = (ChunkStatusMap)statusmap.get(cs);
            if (csm != null) {
                this.c.setColor(csm.defcolor);
            } else {
                this.c.setColor(unknown_color);
                if (!ChunkStatusHDShader.this.unknown_state.contains(cs)) {
                    Log.warning("Unknown chunk status: " + cs);
                    ChunkStatusHDShader.this.unknown_state.add(cs);
                }
            }
            this.lighting.applyLighting(ps, this, this.c, this.color);
            return true;
        }

        @Override
        public void rayFinished(HDPerspectiveState ps) {
        }

        @Override
        public void getRayColor(Color c, int index) {
            c.setColor(this.color[index]);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public DynLongHashMap getCTMTextureCache() {
            return null;
        }

        @Override
        public int[] getLightingTable() {
            return this.lightingTable;
        }

        @Override
        public void setLastBlockState(DynmapBlockState new_lastbs) {
        }
    }

    private static class ChunkStatusMap {
        Color defcolor;

        ChunkStatusMap(String s, int c) {
            this.defcolor = new Color(c >> 16 & 0xFF, c >> 8 & 0xFF, c & 0xFF);
            statusmap.put(s, this);
        }
    }
}

