/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.dynmap.DynmapCore;
import org.dynmap.Log;
import org.dynmap.common.DynmapServerInterface;

public class TexturePackLoader {
    private ZipFile zf;
    private File tpdir;
    private DynmapServerInterface dsi;
    private static final String RESOURCEPATH = "texturepacks/standard";
    private HashMap<String, ModSource> src_by_mod = new HashMap();

    public TexturePackLoader(File tp, DynmapCore core) {
        if (tp.isFile() && tp.canRead()) {
            try {
                this.zf = new ZipFile(tp);
            }
            catch (IOException e) {
                Log.severe("Error opening texture pack - " + tp.getPath());
            }
        } else if (tp.isDirectory() && tp.canRead()) {
            this.tpdir = tp;
        } else {
            Log.info("Texture pack not found - " + tp.getPath());
        }
        this.dsi = core.getServer();
    }

    public InputStream openTPResource(String rname, String altname) {
        InputStream is = this.openTPResource(rname);
        if (is == null && altname != null) {
            is = this.openTPResource(altname);
        }
        return is;
    }

    public InputStream openTPResource(String rname) {
        return this.openModTPResource(rname, null);
    }

    public InputStream openModTPResource(String rname, String modname) {
        try {
            File f;
            if (this.zf != null) {
                ZipEntry ze = this.zf.getEntry(rname);
                if (ze != null && !ze.isDirectory()) {
                    return new BufferedInputStream(this.zf.getInputStream(ze));
                }
            } else if (this.tpdir != null && (f = new File(this.tpdir, rname)).isFile() && f.canRead()) {
                return new BufferedInputStream(new FileInputStream(f));
            }
        }
        catch (IOException f) {
            // empty catch block
        }
        InputStream is = this.dsi.openResource(modname, rname);
        if (is != null) {
            return new BufferedInputStream(is);
        }
        if (modname != null) {
            File f;
            ModSource ms = this.src_by_mod.get(modname);
            if (ms == null) {
                f = this.dsi.getModContainerFile(modname);
                ms = new ModSource();
                if (f != null) {
                    if (f.isFile()) {
                        try {
                            ms.zf = new ZipFile(f);
                        }
                        catch (IOException iOException) {}
                    } else {
                        ms.directory = f;
                    }
                }
                this.src_by_mod.put(modname, ms);
            }
            try {
                if (ms.zf != null) {
                    ZipEntry ze = ms.zf.getEntry(rname);
                    if (ze != null && !ze.isDirectory()) {
                        is = ms.zf.getInputStream(ze);
                    }
                } else if (ms.directory != null && (f = new File(ms.directory, rname)).isFile() && f.canRead()) {
                    is = new FileInputStream(f);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream("texturepacks/standard/" + rname);
        }
        if (is == null && modname != null) {
            Log.warning("Resource " + rname + " for mod " + modname + " not found");
        }
        return is != null ? new BufferedInputStream(is) : null;
    }

    public void close() {
        if (this.zf != null) {
            try {
                this.zf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zf = null;
        }
        for (ModSource ms : this.src_by_mod.values()) {
            if (ms.zf == null) continue;
            try {
                ms.zf.close();
            }
            catch (IOException iOException) {}
        }
        this.src_by_mod.clear();
    }

    public void closeResource(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Set<String> getEntries() {
        HashSet<String> rslt = new HashSet<String>();
        if (this.zf != null) {
            Enumeration<? extends ZipEntry> lst = this.zf.entries();
            while (lst.hasMoreElements()) {
                rslt.add(lst.nextElement().getName());
            }
        }
        if (this.tpdir != null) {
            this.addFiles(rslt, this.tpdir, "");
        }
        return rslt;
    }

    private void addFiles(HashSet<String> files, File dir, String path) {
        File[] listfiles = dir.listFiles();
        if (listfiles == null) {
            return;
        }
        for (File f : listfiles) {
            String fn = f.getName();
            if (fn.equals(".") || fn.equals("..")) continue;
            if (f.isFile()) {
                files.add(path + "/" + fn);
                continue;
            }
            if (!f.isDirectory()) continue;
            this.addFiles(files, f, path + "/" + f.getName());
        }
    }

    private static class ModSource {
        ZipFile zf;
        File directory;

        private ModSource() {
        }
    }
}

