/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class ChestRenderer
extends CustomRenderer {
    protected RenderPatch[][] models = new RenderPatch[ChestData.values().length][];
    private static final double OFF1 = 0.0625;
    private static final double OFF14 = 0.875;
    private static final double OFF15 = 0.9375;
    private static final int[] SINGLE_PATCHES = new int[]{5, 0, 1, 2, 4, 3};
    private static final int[] LEFT_PATCHES = new int[]{14, 6, 10, 11, 12, 8};
    private static final int[] RIGHT_PATCHES = new int[]{15, 7, 10, 11, 13, 9};
    protected boolean double_chest = false;

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        int i;
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        this.double_chest = !"false".equals(custparm.get("doublechest"));
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, 0.0625, 0.9375, 0.0, 0.875, 0.0625, 0.9375, SINGLE_PATCHES);
        this.models[ChestData.SINGLE_SOUTH.ordinal()] = list.toArray(new RenderPatch[list.size()]);
        this.models[ChestData.SINGLE_EAST.ordinal()] = new RenderPatch[6];
        this.models[ChestData.SINGLE_NORTH.ordinal()] = new RenderPatch[6];
        this.models[ChestData.SINGLE_WEST.ordinal()] = new RenderPatch[6];
        for (i = 0; i < 6; ++i) {
            this.models[ChestData.SINGLE_WEST.ordinal()][i] = rpf.getRotatedPatch(list.get(i), 0, 90, 0, SINGLE_PATCHES[i]);
            this.models[ChestData.SINGLE_NORTH.ordinal()][i] = rpf.getRotatedPatch(list.get(i), 0, 180, 0, SINGLE_PATCHES[i]);
            this.models[ChestData.SINGLE_EAST.ordinal()][i] = rpf.getRotatedPatch(list.get(i), 0, 270, 0, SINGLE_PATCHES[i]);
        }
        if (this.double_chest) {
            list.clear();
            CustomRenderer.addBox(rpf, list, 0.0625, 1.0, 0.0, 0.875, 0.0625, 0.9375, LEFT_PATCHES);
            this.models[ChestData.LEFT_SOUTH.ordinal()] = list.toArray(new RenderPatch[list.size()]);
            this.models[ChestData.LEFT_EAST.ordinal()] = new RenderPatch[6];
            this.models[ChestData.LEFT_NORTH.ordinal()] = new RenderPatch[6];
            this.models[ChestData.LEFT_WEST.ordinal()] = new RenderPatch[6];
            for (i = 0; i < 6; ++i) {
                this.models[ChestData.LEFT_WEST.ordinal()][i] = rpf.getRotatedPatch(list.get(i), 0, 90, 0, LEFT_PATCHES[i]);
                this.models[ChestData.LEFT_NORTH.ordinal()][i] = rpf.getRotatedPatch(list.get(i), 0, 180, 0, LEFT_PATCHES[i]);
                this.models[ChestData.LEFT_EAST.ordinal()][i] = rpf.getRotatedPatch(list.get(i), 0, 270, 0, LEFT_PATCHES[i]);
            }
            list.clear();
            CustomRenderer.addBox(rpf, list, 0.0, 0.9375, 0.0, 0.875, 0.0625, 0.9375, RIGHT_PATCHES);
            this.models[ChestData.RIGHT_SOUTH.ordinal()] = list.toArray(new RenderPatch[list.size()]);
            this.models[ChestData.RIGHT_EAST.ordinal()] = new RenderPatch[6];
            this.models[ChestData.RIGHT_NORTH.ordinal()] = new RenderPatch[6];
            this.models[ChestData.RIGHT_WEST.ordinal()] = new RenderPatch[6];
            for (i = 0; i < 6; ++i) {
                this.models[ChestData.RIGHT_WEST.ordinal()][i] = rpf.getRotatedPatch(list.get(i), 0, 90, 0, RIGHT_PATCHES[i]);
                this.models[ChestData.RIGHT_NORTH.ordinal()][i] = rpf.getRotatedPatch(list.get(i), 0, 180, 0, RIGHT_PATCHES[i]);
                this.models[ChestData.RIGHT_EAST.ordinal()][i] = rpf.getRotatedPatch(list.get(i), 0, 270, 0, RIGHT_PATCHES[i]);
            }
        }
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        if (this.double_chest) {
            return 16;
        }
        return 6;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        DynmapBlockState blktype = ctx.getBlockType().baseState;
        if (!this.double_chest) {
            blktype = DynmapBlockState.AIR;
        }
        int blkdata = blktype.stateIndex;
        ChestData cd = ChestData.SINGLE_NORTH;
        switch (blkdata) {
            case 2: {
                if (ctx.getBlockTypeAt((int)-1, (int)0, (int)0).baseState == blktype) {
                    cd = ChestData.LEFT_NORTH;
                    break;
                }
                if (ctx.getBlockTypeAt((int)1, (int)0, (int)0).baseState == blktype) {
                    cd = ChestData.RIGHT_NORTH;
                    break;
                }
                cd = ChestData.SINGLE_NORTH;
                break;
            }
            case 4: {
                if (ctx.getBlockTypeAt((int)0, (int)0, (int)-1).baseState == blktype) {
                    cd = ChestData.RIGHT_WEST;
                    break;
                }
                if (ctx.getBlockTypeAt((int)0, (int)0, (int)1).baseState == blktype) {
                    cd = ChestData.LEFT_WEST;
                    break;
                }
                cd = ChestData.SINGLE_WEST;
                break;
            }
            case 5: {
                if (ctx.getBlockTypeAt((int)0, (int)0, (int)-1).baseState == blktype) {
                    cd = ChestData.LEFT_EAST;
                    break;
                }
                if (ctx.getBlockTypeAt((int)0, (int)0, (int)1).baseState == blktype) {
                    cd = ChestData.RIGHT_EAST;
                    break;
                }
                cd = ChestData.SINGLE_EAST;
                break;
            }
            default: {
                cd = ctx.getBlockTypeAt((int)-1, (int)0, (int)0).baseState == blktype ? ChestData.RIGHT_SOUTH : (ctx.getBlockTypeAt((int)1, (int)0, (int)0).baseState == blktype ? ChestData.LEFT_SOUTH : ChestData.SINGLE_SOUTH);
            }
        }
        return this.models[cd.ordinal()];
    }

    protected static enum ChestData {
        SINGLE_WEST,
        SINGLE_SOUTH,
        SINGLE_EAST,
        SINGLE_NORTH,
        LEFT_WEST,
        LEFT_SOUTH,
        LEFT_EAST,
        LEFT_NORTH,
        RIGHT_WEST,
        RIGHT_SOUTH,
        RIGHT_EAST,
        RIGHT_NORTH;

    }
}

