/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.markers.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dynmap.Client;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapWorld;
import org.dynmap.MapManager;
import org.dynmap.hdmap.HDPerspective;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.EnterExitMarker;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.impl.MarkerAPIImpl;
import org.dynmap.markers.impl.MarkerImpl;
import org.dynmap.markers.impl.MarkerSetImpl;
import org.dynmap.utils.Vector3D;

class AreaMarkerImpl
implements AreaMarker,
EnterExitMarker {
    private String markerid;
    private String label;
    private boolean markup;
    private String desc;
    private MarkerSetImpl markerset;
    private String world;
    private String normalized_world;
    private boolean ispersistent;
    private ArrayList<Coord> corners;
    private int lineweight = 3;
    private double lineopacity = 0.8;
    private int linecolor = 0xFF0000;
    private double fillopacity = 0.35;
    private int fillcolor = 0xFF0000;
    private double ytop = 64.0;
    private double ybottom = 64.0;
    private boolean boostflag = false;
    private int minzoom;
    private int maxzoom;
    private EnterExitMarker.EnterExitText greeting;
    private EnterExitMarker.EnterExitText farewell;
    private Map<String, BoundingBox> bb_cache = null;

    AreaMarkerImpl(String id, String lbl, boolean markup, String world, double[] x, double[] z, boolean persistent, MarkerSetImpl set) {
        DynmapWorld w;
        this.markerid = id;
        this.label = lbl != null ? (markup ? Client.sanitizeHTML(lbl) : Client.encodeForHTML(lbl)) : (markup ? Client.sanitizeHTML(id) : Client.encodeForHTML(id));
        this.markup = markup;
        this.corners = new ArrayList();
        for (int i = 0; i < x.length; ++i) {
            this.corners.add(new Coord(x[i], z[i]));
        }
        this.world = world;
        this.normalized_world = DynmapWorld.normalizeWorldName(world);
        this.desc = null;
        this.ispersistent = persistent;
        this.markerset = set;
        if (MapManager.mapman != null && (w = MapManager.mapman.getWorld(world)) != null) {
            this.ytop = this.ybottom = (double)(w.sealevel + 1);
        }
        this.minzoom = -1;
        this.maxzoom = -1;
        this.greeting = null;
        this.farewell = null;
    }

    AreaMarkerImpl(String id, MarkerSetImpl set) {
        this.markerid = id;
        this.markerset = set;
        this.label = Client.encodeForHTML(id);
        this.markup = false;
        this.desc = null;
        this.corners = new ArrayList();
        this.normalized_world = "world";
        this.world = "world";
        this.minzoom = -1;
        this.maxzoom = -1;
        this.greeting = null;
        this.farewell = null;
    }

    boolean loadPersistentData(ConfigurationNode node, boolean isSafe) {
        this.markup = node.getBoolean("markup", false);
        this.label = MarkerAPIImpl.escapeForHTMLIfNeeded(node.getString("label", this.markerid), this.markup);
        if (!isSafe) {
            this.label = Client.sanitizeHTML(this.label);
        }
        this.ytop = node.getDouble("ytop", 64.0);
        this.ybottom = node.getDouble("ybottom", 64.0);
        List xx = node.getList("x");
        List zz = node.getList("z");
        this.corners.clear();
        if (xx != null && zz != null) {
            for (int i = 0; i < xx.size() && i < zz.size(); ++i) {
                this.corners.add(new Coord((Double)xx.get(i), (Double)zz.get(i)));
            }
        }
        this.world = node.getString("world", "world");
        this.normalized_world = DynmapWorld.normalizeWorldName(this.world);
        this.desc = node.getString("desc", null);
        if (!isSafe) {
            this.desc = Client.sanitizeHTML(this.desc);
        }
        this.lineweight = node.getInteger("strokeWeight", -1);
        if (this.lineweight == -1) {
            this.lineweight = node.getInteger("stokeWeight", 3);
        }
        this.lineopacity = node.getDouble("strokeOpacity", 0.8);
        this.linecolor = node.getInteger("strokeColor", 0xFF0000);
        this.fillopacity = node.getDouble("fillOpacity", 0.35);
        this.fillcolor = node.getInteger("fillColor", 0xFF0000);
        this.boostflag = node.getBoolean("boostFlag", false);
        this.minzoom = node.getInteger("minzoom", -1);
        this.maxzoom = node.getInteger("maxzoom", -1);
        String gt = node.getString("greeting", null);
        String gst = node.getString("greetingsub", null);
        if (gt != null || gst != null) {
            this.greeting = new EnterExitMarker.EnterExitText();
            this.greeting.title = gt;
            this.greeting.subtitle = gst;
        }
        String ft = node.getString("farewell", null);
        String fst = node.getString("farewellsub", null);
        if (ft != null || fst != null) {
            this.farewell = new EnterExitMarker.EnterExitText();
            this.farewell.title = ft;
            this.farewell.subtitle = fst;
        }
        this.ispersistent = true;
        return true;
    }

    void cleanup() {
        this.corners.clear();
        this.markerset = null;
        this.bb_cache = null;
    }

    @Override
    public String getUniqueMarkerID() {
        if (this.markerset != null) {
            return this.markerset + ":area:" + this.markerid;
        }
        return null;
    }

    @Override
    public String getMarkerID() {
        return this.markerid;
    }

    @Override
    public MarkerSet getMarkerSet() {
        return this.markerset;
    }

    @Override
    public void deleteMarker() {
        if (this.markerset == null) {
            return;
        }
        this.markerset.removeAreaMarker(this);
        this.cleanup();
    }

    @Override
    public boolean isPersistentMarker() {
        return this.ispersistent;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String lbl) {
        this.setLabel(lbl, false);
    }

    @Override
    public void setLabel(String lbl, boolean markup) {
        if (this.markerset == null) {
            return;
        }
        this.label = markup ? Client.sanitizeHTML(lbl) : Client.encodeForHTML(lbl);
        this.markup = markup;
        MarkerAPIImpl.areaMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    Map<String, Object> getPersistentData() {
        if (!this.ispersistent) {
            return null;
        }
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("label", this.label);
        node.put("markup", this.markup);
        ArrayList<Double> xx = new ArrayList<Double>();
        ArrayList<Double> zz = new ArrayList<Double>();
        for (int i = 0; i < this.corners.size(); ++i) {
            xx.add(this.corners.get((int)i).x);
            zz.add(this.corners.get((int)i).z);
        }
        node.put("x", xx);
        node.put("ytop", this.ytop);
        node.put("ybottom", this.ybottom);
        node.put("z", zz);
        node.put("world", this.world);
        if (this.desc != null) {
            node.put("desc", this.desc);
        }
        node.put("strokeWeight", this.lineweight);
        node.put("strokeOpacity", this.lineopacity);
        node.put("strokeColor", this.linecolor);
        node.put("fillOpacity", this.fillopacity);
        node.put("fillColor", this.fillcolor);
        if (this.boostflag) {
            node.put("boostFlag", true);
        }
        if (this.minzoom >= 0) {
            node.put("minzoom", this.minzoom);
        }
        if (this.maxzoom >= 0) {
            node.put("maxzoom", this.maxzoom);
        }
        if (this.greeting != null) {
            if (this.greeting.title != null) {
                node.put("greeting", this.greeting.title);
            }
            if (this.greeting.subtitle != null) {
                node.put("greetingsub", this.greeting.subtitle);
            }
        }
        if (this.farewell != null) {
            if (this.farewell.title != null) {
                node.put("farewell", this.farewell.title);
            }
            if (this.farewell.subtitle != null) {
                node.put("farewellsub", this.farewell.subtitle);
            }
        }
        return node;
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    @Override
    public String getNormalizedWorld() {
        return this.normalized_world;
    }

    @Override
    public boolean isLabelMarkup() {
        return this.markup;
    }

    @Override
    public void setDescription(String desc) {
        if (this.markerset == null) {
            return;
        }
        desc = Client.sanitizeHTML(desc);
        if (this.desc == null || !this.desc.equals(desc)) {
            this.desc = desc;
            MarkerAPIImpl.areaMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public double getTopY() {
        return this.ytop;
    }

    @Override
    public double getBottomY() {
        return this.ybottom;
    }

    @Override
    public void setRangeY(double ytop, double ybottom) {
        if (this.markerset == null) {
            return;
        }
        if (this.ytop != ytop || this.ybottom != ybottom) {
            this.ytop = ytop;
            this.ybottom = ybottom;
            MarkerAPIImpl.areaMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
            this.bb_cache = null;
        }
    }

    @Override
    public int getCornerCount() {
        return this.corners.size();
    }

    @Override
    public double getCornerX(int n) {
        Coord c = this.corners.get(n);
        if (c != null) {
            return c.x;
        }
        return 0.0;
    }

    @Override
    public double getCornerZ(int n) {
        Coord c = this.corners.get(n);
        if (c != null) {
            return c.z;
        }
        return 0.0;
    }

    @Override
    public void setCornerLocation(int n, double x, double z) {
        if (this.markerset == null) {
            return;
        }
        if (n >= this.corners.size()) {
            this.corners.add(new Coord(x, z));
        } else {
            Coord c = this.corners.get(n);
            if (c.x == x && c.z == z) {
                return;
            }
            c.x = x;
            c.z = z;
        }
        MarkerAPIImpl.areaMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
        this.bb_cache = null;
    }

    @Override
    public void deleteCorner(int n) {
        if (this.markerset == null) {
            return;
        }
        if (n < this.corners.size()) {
            this.corners.remove(n);
            MarkerAPIImpl.areaMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
            this.bb_cache = null;
        }
    }

    @Override
    public void setCornerLocations(double[] x, double[] z) {
        if (this.markerset == null) {
            return;
        }
        if (x.length == this.corners.size()) {
            boolean match = true;
            for (int i = 0; i < x.length; ++i) {
                Coord c = this.corners.get(i);
                if (c.x == x[i] && c.z == z[i]) continue;
                match = false;
                break;
            }
            if (match) {
                return;
            }
        }
        this.corners.clear();
        for (int i = 0; i < x.length && i < z.length; ++i) {
            this.corners.add(new Coord(x[i], z[i]));
        }
        MarkerAPIImpl.areaMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
        this.bb_cache = null;
    }

    @Override
    public void setLineStyle(int weight, double opacity, int color) {
        if (this.markerset == null) {
            return;
        }
        if (weight != this.lineweight || opacity != this.lineopacity || color != this.linecolor) {
            this.lineweight = weight;
            this.lineopacity = opacity;
            this.linecolor = color;
            MarkerAPIImpl.areaMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public int getLineWeight() {
        return this.lineweight;
    }

    @Override
    public double getLineOpacity() {
        return this.lineopacity;
    }

    @Override
    public int getLineColor() {
        return this.linecolor;
    }

    @Override
    public void setFillStyle(double opacity, int color) {
        if (this.markerset == null) {
            return;
        }
        if (opacity != this.fillopacity || color != this.fillcolor) {
            this.fillopacity = opacity;
            this.fillcolor = color;
            MarkerAPIImpl.areaMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public double getFillOpacity() {
        return this.fillopacity;
    }

    @Override
    public int getFillColor() {
        return this.fillcolor;
    }

    @Override
    public void setMarkerSet(MarkerSet newset) {
        if (this.markerset != null) {
            this.markerset.removeAreaMarker(this);
        }
        this.markerset = (MarkerSetImpl)newset;
        this.markerset.insertAreaMarker(this);
    }

    @Override
    public void setBoostFlag(boolean bflag) {
        if (this.boostflag != bflag) {
            this.boostflag = bflag;
            if (this.markerset != null) {
                this.setMarkerSet(this.markerset);
            }
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public boolean getBoostFlag() {
        return this.boostflag;
    }

    final boolean testTileForBoostMarkers(DynmapWorld w, HDPerspective perspective, double tile_x, double tile_y, double tile_dim) {
        BoundingBox bb;
        Map<String, BoundingBox> bbc = this.bb_cache;
        if (bbc == null) {
            bbc = new ConcurrentHashMap<String, BoundingBox>();
        }
        if ((bb = bbc.get(perspective.getName())) == null) {
            bb = new BoundingBox();
            Vector3D v = new Vector3D();
            Vector3D v2 = new Vector3D();
            bb.xmin = Double.MAX_VALUE;
            bb.xmax = -1.7976931348623157E308;
            bb.ymin = Double.MAX_VALUE;
            bb.ymax = -1.7976931348623157E308;
            if (this.corners != null) {
                ArrayList<Coord> crn = this.corners;
                int cnt = crn.size();
                if (cnt == 2) {
                    cnt = 4;
                    crn = new ArrayList();
                    Coord c0 = this.corners.get(0);
                    Coord c1 = this.corners.get(1);
                    crn.add(c0);
                    crn.add(new Coord(c0.x, c1.z));
                    crn.add(c1);
                    crn.add(new Coord(c1.x, c0.z));
                }
                double ymid = (this.ytop + this.ybottom) / 2.0;
                bb.xp = new double[cnt];
                bb.yp = new double[cnt];
                for (int i = 0; i < cnt; ++i) {
                    Coord c = crn.get(i);
                    v.x = c.x;
                    v.y = ymid;
                    v.z = c.z;
                    perspective.transformWorldToMapCoord(v, v2);
                    if (v2.x < bb.xmin) {
                        bb.xmin = v2.x;
                    }
                    if (v2.y < bb.ymin) {
                        bb.ymin = v2.y;
                    }
                    if (v2.x > bb.xmax) {
                        bb.xmax = v2.x;
                    }
                    if (v2.y > bb.ymax) {
                        bb.ymax = v2.y;
                    }
                    bb.xp[i] = v2.x;
                    bb.yp[i] = v2.y;
                }
            }
            bbc.put(perspective.getName(), bb);
            this.bb_cache = bbc;
        }
        double tile_x2 = tile_x + tile_dim;
        double tile_y2 = tile_y + tile_dim;
        if (bb.xmin > tile_x2 || bb.xmax < tile_x || bb.ymin > tile_y2 || bb.ymax < tile_y) {
            return false;
        }
        int cnt = bb.xp.length;
        double[] px = bb.xp;
        double[] py = bb.yp;
        if (MarkerImpl.testPointInPolygon(tile_x, tile_y, px, py)) {
            return true;
        }
        if (MarkerImpl.testPointInPolygon(tile_x2, tile_y, px, py)) {
            return true;
        }
        if (MarkerImpl.testPointInPolygon(tile_x, tile_y2, px, py)) {
            return true;
        }
        if (MarkerImpl.testPointInPolygon(tile_x2, tile_y2, px, py)) {
            return true;
        }
        for (int i = 0; i < cnt; ++i) {
            if (!(px[i] >= tile_x) || !(px[i] <= tile_x2) || !(py[i] >= tile_y) || !(py[i] <= tile_y2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMinZoom() {
        return this.minzoom;
    }

    @Override
    public void setMinZoom(int zoom) {
        if (zoom < 0) {
            zoom = -1;
        }
        if (this.minzoom == zoom) {
            return;
        }
        this.minzoom = zoom;
        MarkerAPIImpl.areaMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public int getMaxZoom() {
        return this.maxzoom;
    }

    @Override
    public void setMaxZoom(int zoom) {
        if (zoom < 0) {
            zoom = -1;
        }
        if (this.maxzoom == zoom) {
            return;
        }
        this.maxzoom = zoom;
        MarkerAPIImpl.areaMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public EnterExitMarker.EnterExitText getGreetingText() {
        return this.greeting;
    }

    @Override
    public EnterExitMarker.EnterExitText getFarewellText() {
        return this.farewell;
    }

    @Override
    public void setGreetingText(String title, String subtitle) {
        if (title != null || subtitle != null) {
            this.greeting = new EnterExitMarker.EnterExitText();
            this.greeting.title = title;
            this.greeting.subtitle = subtitle;
        } else {
            this.greeting = null;
        }
        if (this.markerset != null) {
            this.setMarkerSet(this.markerset);
        }
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public void setFarewellText(String title, String subtitle) {
        if (title != null || subtitle != null) {
            this.farewell = new EnterExitMarker.EnterExitText();
            this.farewell.title = title;
            this.farewell.subtitle = subtitle;
        } else {
            this.farewell = null;
        }
        if (this.markerset != null) {
            this.setMarkerSet(this.markerset);
        }
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public boolean testIfPointWithinMarker(String worldid, double x, double y, double z) {
        if (!worldid.equals(this.world)) {
            return false;
        }
        if (this.ytop != this.ybottom && (y < this.ybottom || y > this.ytop)) {
            return false;
        }
        int nvert = this.corners.size();
        boolean c = false;
        if (nvert == 2) {
            Coord v0 = this.corners.get(0);
            Coord v1 = this.corners.get(1);
            if (v0.x > x != v1.x > x && v0.z > z != v1.z > z) {
                c = true;
            }
        } else {
            int i = 0;
            int j = nvert - 1;
            while (i < nvert) {
                Coord v0 = this.corners.get(i);
                Coord v1 = this.corners.get(j);
                if (v0.z > z != v1.z > z && x < v0.x + (v1.x - v0.x) * (z - v0.z) / (v1.z - v0.z)) {
                    c = !c;
                }
                j = i++;
            }
        }
        return c;
    }

    private static class Coord {
        double x;
        double z;

        Coord(double x, double z) {
            this.x = x;
            this.z = z;
        }

        public String toString() {
            return String.format("{%f,%f}", this.x, this.z);
        }
    }

    private static class BoundingBox {
        double xmin;
        double xmax;
        double ymin;
        double ymax;
        double[] xp;
        double[] yp;

        private BoundingBox() {
        }
    }
}

