/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.markers.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dynmap.DynmapCore;
import org.dynmap.common.DynmapChatColor;
import org.dynmap.common.DynmapListenerManager;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.impl.MarkerAPIImpl;

public class MarkerSignManager {
    private static MarkerSignManager mgr = null;
    private static DynmapCore plugin = null;
    private static String defSignSet = null;
    private static SignListener sl = null;

    private static String escapeMarkup(String v) {
        v = v.replace("&", "&amp;");
        v = v.replace("\"", "&quote;");
        v = v.replace("<", "&lt;");
        v = v.replace(">", "&gt;");
        return v;
    }

    public static MarkerSignManager initializeSignManager(DynmapCore plugin, String defsignset) {
        mgr = new MarkerSignManager();
        defSignSet = defsignset;
        if (sl == null) {
            sl = new SignListener();
            plugin.listenerManager.addListener(DynmapListenerManager.EventType.SIGN_CHANGE, sl);
            plugin.getServer().scheduleServerTask(sl, 200L);
        }
        MarkerSignManager.plugin = plugin;
        return mgr;
    }

    public static void terminateSignManager(DynmapCore plugin) {
        mgr = null;
    }

    private static String getSignMarkerID(String wname, int x, int y, int z) {
        return "_sign_" + wname + "_" + x + "_" + y + "_" + z;
    }

    private static class SignListener
    implements DynmapListenerManager.SignChangeEventListener,
    Runnable {
        private HashMap<String, SignRec> sign_cache = null;

        private SignListener() {
        }

        @Override
        public void signChangeEvent(String material, String wname, int x, int y, int z, String[] lines, DynmapPlayer p) {
            if (mgr == null) {
                return;
            }
            if (!lines[0].equalsIgnoreCase("[dynmap]")) {
                return;
            }
            if (p == null || plugin != null && plugin.checkPlayerPermission(p, "marker.sign")) {
                String id = MarkerSignManager.getSignMarkerID(wname, x, y, z);
                String set = defSignSet;
                String icon = "sign";
                String label = "";
                lines[0] = "";
                for (int i = 1; i < 4; ++i) {
                    String v = plugin.getServer().stripChatColor(lines[i]);
                    if (v.startsWith("icon:")) {
                        icon = v.substring(5);
                        lines[i] = "";
                        continue;
                    }
                    if (v.startsWith("set:")) {
                        set = v.substring(4);
                        lines[i] = "";
                        continue;
                    }
                    if (v.length() <= 0) continue;
                    if (label.length() > 0) {
                        label = label + "<br/>";
                    }
                    label = label + MarkerSignManager.escapeMarkup(v);
                }
                MarkerSet ms = MarkerAPIImpl.api.getMarkerSet(set);
                if (ms == null) {
                    if (p != null) {
                        p.sendMessage("Bad marker set - [dynmap] sign invalid");
                    }
                    lines[0] = (Object)((Object)DynmapChatColor.RED) + "<Bad Marker Set>";
                    return;
                }
                MarkerIcon mi = MarkerAPIImpl.api.getMarkerIcon(icon);
                if (mi == null) {
                    if (p != null) {
                        p.sendMessage("Bad marker icon - [dynmap] sign invalid");
                    }
                    lines[0] = (Object)((Object)DynmapChatColor.RED) + "<Bad Marker Icon>";
                    return;
                }
                Marker marker = ms.findMarker(id);
                if (marker != null) {
                    marker.setLabel(label, true);
                    marker.setMarkerIcon(mi);
                } else {
                    marker = ms.createMarker(id, label, true, wname, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, mi, true);
                    if (marker == null) {
                        if (p != null) {
                            p.sendMessage("Bad marker - [dynmap] sign invalid");
                        }
                        lines[0] = (Object)((Object)DynmapChatColor.RED) + "<Bad Marker>";
                        return;
                    }
                    if (this.sign_cache != null) {
                        SignRec r = new SignRec();
                        r.wname = wname;
                        r.x = x;
                        r.y = y;
                        r.z = z;
                        r.m = marker;
                        this.sign_cache.put(id, r);
                    }
                }
            }
        }

        @Override
        public void run() {
            if (mgr == null) {
                return;
            }
            if (this.sign_cache == null) {
                this.sign_cache = new HashMap();
                Set<MarkerSet> sets = MarkerAPIImpl.api.getMarkerSets();
                for (MarkerSet ms : sets) {
                    for (Marker m : ms.getMarkers()) {
                        String id = m.getMarkerID();
                        try {
                            if (!id.startsWith("_sign_")) continue;
                            SignRec rec = new SignRec();
                            int off = id.lastIndexOf(95);
                            if (off > 0) {
                                rec.z = Integer.parseInt(id.substring(off + 1));
                                id = id.substring(0, off);
                            }
                            if ((off = id.lastIndexOf(95)) > 0) {
                                rec.y = Integer.parseInt(id.substring(off + 1));
                                id = id.substring(0, off);
                            }
                            if ((off = id.lastIndexOf(95)) > 0) {
                                rec.x = Integer.parseInt(id.substring(off + 1));
                                id = id.substring(0, off);
                            }
                            rec.wname = id.substring(6);
                            rec.m = m;
                            this.sign_cache.put(m.getMarkerID(), rec);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            Iterator<Map.Entry<String, SignRec>> iter = this.sign_cache.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, SignRec> ent = iter.next();
                SignRec r = ent.getValue();
                if (r.m.getMarkerSet() == null) {
                    iter.remove();
                    continue;
                }
                if (plugin.getServer().isSignAt(r.wname, r.x, r.y, r.z) != 0) continue;
                r.m.deleteMarker();
                iter.remove();
            }
            plugin.getServer().scheduleServerTask(sl, 1200L);
        }
    }

    private static class SignRec {
        String wname;
        int x;
        int y;
        int z;
        Marker m;

        private SignRec() {
        }
    }
}

