/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.api.client;

import java.io.Closeable;
import java.nio.file.Path;
import org.dynmap.s3lite.api.request.DeleteObjectRequest;
import org.dynmap.s3lite.api.request.GetObjectRequest;
import org.dynmap.s3lite.api.request.ListObjectsV2Request;
import org.dynmap.s3lite.api.request.PutObjectRequest;
import org.dynmap.s3lite.api.response.DeleteObjectResponse;
import org.dynmap.s3lite.api.response.GetObjectResponse;
import org.dynmap.s3lite.api.response.ListObjectsV2Response;
import org.dynmap.s3lite.api.response.PutObjectResponse;
import org.dynmap.s3lite.api.response.ResponseBytes;
import org.dynmap.s3lite.api.response.ResponseInputStream;
import org.dynmap.s3lite.api.response.ResponseTransformer;
import org.dynmap.s3lite.http.spi.request.RequestBody;

public interface S3Client
extends Closeable {
    default public ListObjectsV2Response listObjectsV2(ListObjectsV2Request request) {
        throw new UnsupportedOperationException();
    }

    default public <T> T getObject(GetObjectRequest request, ResponseTransformer<GetObjectResponse, T> transformer) {
        throw new UnsupportedOperationException();
    }

    default public GetObjectResponse getObject(GetObjectRequest request, Path filePath) {
        return (GetObjectResponse)this.getObject(request, ResponseTransformer.toPath(filePath));
    }

    default public ResponseInputStream<GetObjectResponse> getObject(GetObjectRequest request) {
        return this.getObject(request, ResponseTransformer.toInputStream());
    }

    default public ResponseBytes<GetObjectResponse> getObjectAsBytes(GetObjectRequest request) {
        return this.getObject(request, ResponseTransformer.toBytes());
    }

    default public DeleteObjectResponse deleteObject(DeleteObjectRequest request) {
        throw new UnsupportedOperationException();
    }

    default public PutObjectResponse putObject(PutObjectRequest request, RequestBody body) {
        throw new UnsupportedOperationException();
    }

    default public PutObjectResponse putObject(PutObjectRequest request, Path filePath) {
        return this.putObject(request, RequestBody.fromPath(filePath));
    }
}

