/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.api.region;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Region {
    public static final Region US_EAST_1 = Region.of("us-east-1", URI.create("https://s3.us-east-1.amazonaws.com"));
    public static final Region US_EAST_2 = Region.of("us-east-2", URI.create("https://s3.us-east-2.amazonaws.com"));
    public static final Region US_WEST_1 = Region.of("us-west-1", URI.create("https://s3.us-west-1.amazonaws.com"));
    public static final Region US_WEST_2 = Region.of("us-west-2", URI.create("https://s3.us-west-2.amazonaws.com"));
    public static final Region AP_EAST_1 = Region.of("ap-east-1", URI.create("https://s3.ap-east-1.amazonaws.com"));
    public static final Region AP_SOUTH_1 = Region.of("ap-south-1", URI.create("https://s3.ap-south-1.amazonaws.com"));
    public static final Region AP_NORTHEAST_1 = Region.of("ap-northeast-1", URI.create("https://s3.ap-northeast-1.amazonaws.com"));
    public static final Region AP_NORTHEAST_2 = Region.of("ap-northeast-2", URI.create("https://s3.ap-northeast-2.amazonaws.com"));
    public static final Region AP_NORTHEAST_3 = Region.of("ap-northeast-3", URI.create("https://s3.ap-northeast-3.amazonaws.com"));
    public static final Region AP_SOUTHEAST_1 = Region.of("ap-southeast-1", URI.create("https://s3.ap-southeast-1.amazonaws.com"));
    public static final Region AP_SOUTHEAST_2 = Region.of("ap-southeast-2", URI.create("https://s3.ap-southeast-2.amazonaws.com"));
    public static final Region AP_SOUTHEAST_3 = Region.of("ap-southeast-3", URI.create("https://s3.ap-southeast-3.amazonaws.com"));
    public static final Region AF_SOUTH_1 = Region.of("af-south-1", URI.create("https://s3.af-south-1.amazonaws.com"));
    public static final Region EU_WEST_1 = Region.of("eu-west-1", URI.create("https://s3.eu-west-1.amazonaws.com"));
    public static final Region EU_WEST_2 = Region.of("eu-west-2", URI.create("https://s3.eu-west-2.amazonaws.com"));
    public static final Region EU_WEST_3 = Region.of("eu-west-3", URI.create("https://s3.eu-west-3.amazonaws.com"));
    public static final Region EU_CENTRAL_1 = Region.of("eu-central-1", URI.create("https://s3.eu-central-1.amazonaws.com"));
    public static final Region EU_NORTH_1 = Region.of("eu-north-1", URI.create("https://s3.eu-north-1.amazonaws.com"));
    public static final Region EU_SOUTH_1 = Region.of("eu-south-1", URI.create("https://s3.eu-south-1.amazonaws.com"));
    public static final Region CA_CENTRAL_1 = Region.of("ca-central-1", URI.create("https://s3.ca-central-1.amazonaws.com"));
    public static final Region SA_EAST_1 = Region.of("sa-east-1", URI.create("https://s3.sa-east-1.amazonaws.com"));
    public static final Region ME_CENTRAL_1 = Region.of("me-central-1", URI.create("https://s3.me-central-1.amazonaws.com"));
    public static final Region ME_SOUTH_1 = Region.of("me-south-1", URI.create("https://s3.me-south-1.amazonaws.com"));
    public static final Region CN_NORTH_1 = Region.of("cn-north-1", URI.create("https://s3.cn-north-1.amazonaws.com.cn"));
    public static final Region CN_NORTHWEST_1 = Region.of("cn-northwest-1", URI.create("https://s3.cn-northwest-1.amazonaws.com.cn"));
    public static final Region US_GOV_EAST_1 = Region.of("us-gov-east-1", URI.create("https://s3.us-gov-east-1.amazonaws.com"));
    public static final Region US_GOV_WEST_1 = Region.of("us-gov-west-1", URI.create("https://s3.us-gov-west-1.amazonaws.com"));
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(US_EAST_1, US_EAST_2, US_WEST_1, US_WEST_2, AP_EAST_1, AP_SOUTH_1, AP_NORTHEAST_1, AP_NORTHEAST_2, AP_NORTHEAST_3, AP_SOUTHEAST_1, AP_SOUTHEAST_2, AP_SOUTHEAST_3, AF_SOUTH_1, EU_WEST_1, EU_WEST_2, EU_WEST_3, EU_CENTRAL_1, EU_NORTH_1, EU_SOUTH_1, CA_CENTRAL_1, SA_EAST_1, ME_CENTRAL_1, ME_SOUTH_1, CN_NORTH_1, CN_NORTHWEST_1, US_GOV_EAST_1, US_GOV_WEST_1));
    private final String regionName;
    private final URI endpoint;

    public static Region of(String regionName, URI endpoint) {
        return new Region(regionName, endpoint);
    }

    private Region(String regionName, URI endpoint) {
        this.regionName = regionName;
        this.endpoint = endpoint;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public static Region fromString(String regionName) {
        return REGIONS.stream().filter(e -> e.regionName.equals(regionName)).findFirst().orElseThrow(() -> new IllegalArgumentException("No matching constant for: " + regionName));
    }

    public String toString() {
        return "Region{regionName='" + this.regionName + '\'' + ", endpoint=" + this.endpoint + '}';
    }
}

