/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.api.response;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.dynmap.s3lite.api.response.ResponseBytes;
import org.dynmap.s3lite.api.response.ResponseInputStream;
import org.dynmap.s3lite.http.spi.IOUtils;

@FunctionalInterface
public interface ResponseTransformer<T, R> {
    public R transform(T var1, InputStream var2) throws IOException;

    default public boolean needsConnectionLeftOpen() {
        return false;
    }

    public static <T> ResponseTransformer<T, T> toPath(Path path) {
        return (resp, in) -> {
            Files.copy(in, path, new CopyOption[0]);
            return resp;
        };
    }

    public static <T> ResponseTransformer<T, T> toFile(File file) {
        return ResponseTransformer.toPath(file.toPath());
    }

    public static <T> ResponseTransformer<T, T> toOutputStream(OutputStream outputStream) {
        return (resp, in) -> {
            IOUtils.copy(in, outputStream);
            return resp;
        };
    }

    public static <T> ResponseTransformer<T, ResponseBytes<T>> toBytes() {
        return (resp, in) -> ResponseBytes.fromByteArray(resp, IOUtils.toByteArray(in));
    }

    public static <T> ResponseTransformer<T, ResponseInputStream<T>> toInputStream() {
        final ResponseTransformer<Object, ResponseInputStream> transformer = ResponseInputStream::new;
        return new ResponseTransformer<T, ResponseInputStream<T>>(){

            @Override
            public ResponseInputStream<T> transform(T response, InputStream input) throws IOException {
                return (ResponseInputStream)transformer.transform(response, input);
            }

            @Override
            public boolean needsConnectionLeftOpen() {
                return true;
            }
        };
    }
}

