/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.api.response;

import java.time.Instant;
import java.util.Objects;
import org.dynmap.s3lite.api.response.Owner;

public class S3Object {
    private final String eTag;
    private final String key;
    private final Instant lastModified;
    private final Owner owner;
    private final Long size;
    private final String storageClass;

    private S3Object(Builder builder) {
        this.eTag = builder.eTag;
        this.key = builder.key;
        this.lastModified = builder.lastModified;
        this.owner = builder.owner;
        this.size = builder.size;
        this.storageClass = builder.storageClass;
    }

    public String getETag() {
        return this.eTag;
    }

    public String getKey() {
        return this.key;
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public Long getSize() {
        return this.size;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        S3Object that = (S3Object)obj;
        return Objects.equals(this.eTag, that.eTag) && Objects.equals(this.key, that.key) && Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.owner, that.owner) && Objects.equals(this.size, that.size) && Objects.equals(this.storageClass, that.storageClass);
    }

    public int hashCode() {
        return Objects.hash(this.eTag, this.key, this.lastModified, this.owner, this.size, this.storageClass);
    }

    public String toString() {
        return "S3Object{eTag='" + this.eTag + '\'' + ", key='" + this.key + '\'' + ", lastModified=" + this.lastModified + ", owner=" + this.owner + ", size=" + this.size + ", storageClass='" + this.storageClass + '\'' + '}';
    }

    public static class Builder {
        private String eTag;
        private String key;
        private Instant lastModified;
        private Owner owner;
        private Long size;
        private String storageClass;

        private Builder() {
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            return this;
        }

        public Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public S3Object build() {
            return new S3Object(this);
        }
    }
}

