/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.core.mapper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dynmap.s3lite.api.response.CommonPrefix;
import org.dynmap.s3lite.api.response.ListObjectsV2Response;
import org.dynmap.s3lite.api.response.Owner;
import org.dynmap.s3lite.api.response.S3Object;
import org.dynmap.s3lite.core.mapper.ResponseMapper;

public class ListObjectsV2ResponseMapper
implements ResponseMapper<ListObjectsV2Response> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ListObjectsV2Response apply(byte[] bytes) {
        XMLInputFactory factory = ResponseMapper.newFactory().get();
        ListObjectsV2Response.Builder response = null;
        ArrayList<CommonPrefix> commonPrefixes = new ArrayList<CommonPrefix>();
        ArrayList<S3Object> contents = new ArrayList<S3Object>();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            CommonPrefix.Builder commonPrefix = null;
            S3Object.Builder s3Object = null;
            Owner.Builder owner = null;
            boolean bStartAfter = false;
            boolean bPrefix = false;
            boolean bNextContinuationToken = false;
            boolean bMaxKeys = false;
            boolean bKeyCount = false;
            boolean bIsTruncated = false;
            boolean bEncodingType = false;
            boolean bDelimiter = false;
            boolean bContinuationToken = false;
            boolean bContents = false;
            boolean bCommonPrefixes = false;
            boolean bBucketName = false;
            boolean bStorageClass = false;
            boolean bSize = false;
            boolean bOwner = false;
            boolean bETag = false;
            boolean bLastModified = false;
            boolean bKey = false;
            boolean bID = false;
            boolean bDisplayName = false;
            XMLStreamReader reader = factory.createXMLStreamReader(bais);
            block108: while (reader.hasNext()) {
                block5 : switch (reader.next()) {
                    case 1: {
                        switch (reader.getLocalName()) {
                            case "ListBucketResult": {
                                response = ListObjectsV2Response.builder();
                                break block5;
                            }
                            case "Name": {
                                bBucketName = true;
                                break block5;
                            }
                            case "CommonPrefix": {
                                bCommonPrefixes = true;
                                commonPrefix = CommonPrefix.builder();
                                break block5;
                            }
                            case "Contents": {
                                bContents = true;
                                s3Object = S3Object.builder();
                                break block5;
                            }
                            case "ContinuationToken": {
                                bContinuationToken = true;
                                break block5;
                            }
                            case "Delimiter": {
                                bDelimiter = true;
                                break block5;
                            }
                            case "EncodingType": {
                                bEncodingType = true;
                                break block5;
                            }
                            case "IsTruncated": {
                                bIsTruncated = true;
                                break block5;
                            }
                            case "KeyCount": {
                                bKeyCount = true;
                                break block5;
                            }
                            case "MaxKeys": {
                                bMaxKeys = true;
                                break block5;
                            }
                            case "NextContinuationToken": {
                                bNextContinuationToken = true;
                                break block5;
                            }
                            case "Prefix": {
                                bPrefix = true;
                                break block5;
                            }
                            case "StartAfter": {
                                bStartAfter = true;
                                break block5;
                            }
                            case "ETag": {
                                bETag = true;
                                break block5;
                            }
                            case "Owner": {
                                bOwner = true;
                                owner = Owner.builder();
                                break block5;
                            }
                            case "Key": {
                                bKey = true;
                                break block5;
                            }
                            case "LastModified": {
                                bLastModified = true;
                                break block5;
                            }
                            case "Size": {
                                bSize = true;
                                break block5;
                            }
                            case "StorageClass": {
                                bStorageClass = true;
                                break block5;
                            }
                            case "DisplayName": {
                                bDisplayName = true;
                                break block5;
                            }
                            case "ID": {
                                bID = true;
                                continue block108;
                            }
                        }
                        break;
                    }
                    case 4: {
                        if (bBucketName) {
                            response = response.bucketName(reader.getText());
                            break;
                        }
                        if (bContinuationToken) {
                            response = response.continuationToken(reader.getText());
                            break;
                        }
                        if (bDelimiter) {
                            response = response.delimiter(reader.getText());
                            break;
                        }
                        if (bEncodingType) {
                            response = response.encodingType(reader.getText());
                            break;
                        }
                        if (bIsTruncated) {
                            response = response.isTruncated(Boolean.valueOf(reader.getText()));
                            break;
                        }
                        if (bKeyCount) {
                            response = response.keyCount(Integer.valueOf(reader.getText()));
                            break;
                        }
                        if (bMaxKeys) {
                            response = response.maxKeys(Integer.valueOf(reader.getText()));
                            break;
                        }
                        if (bNextContinuationToken) {
                            response = response.nextContinuationToken(reader.getText());
                            break;
                        }
                        if (bPrefix) {
                            String text = reader.getText();
                            if (bCommonPrefixes) {
                                commonPrefix = commonPrefix.prefix(text);
                                break;
                            }
                            response = response.prefix(text);
                            break;
                        }
                        if (bStartAfter) {
                            response = response.startAfter(reader.getText());
                            break;
                        }
                        if (bETag) {
                            s3Object = s3Object.eTag(reader.getText());
                            break;
                        }
                        if (bOwner) {
                            if (bContents) {
                                s3Object = s3Object.owner(owner.build());
                                break;
                            }
                            if (!bCommonPrefixes) break;
                            commonPrefix = commonPrefix.owner(owner.build());
                            break;
                        }
                        if (bKey) {
                            s3Object = s3Object.key(reader.getText());
                            break;
                        }
                        if (bLastModified) {
                            s3Object = s3Object.lastModified(Instant.parse(reader.getText()));
                            break;
                        }
                        if (bSize) {
                            s3Object = s3Object.size(Long.valueOf(reader.getText()));
                            break;
                        }
                        if (bStorageClass) {
                            s3Object = s3Object.storageClass(reader.getText());
                            break;
                        }
                        if (bDisplayName) {
                            owner = owner.displayName(reader.getText());
                            break;
                        }
                        if (!bID) break;
                        owner = owner.id(reader.getText());
                        break;
                    }
                    case 2: {
                        switch (reader.getLocalName()) {
                            case "Name": {
                                bBucketName = false;
                                break block5;
                            }
                            case "CommonPrefix": {
                                bCommonPrefixes = false;
                                commonPrefixes.add(commonPrefix.build());
                                break block5;
                            }
                            case "Contents": {
                                bContents = false;
                                contents.add(s3Object.build());
                                break block5;
                            }
                            case "ContinuationToken": {
                                bContinuationToken = false;
                                break block5;
                            }
                            case "Delimiter": {
                                bDelimiter = false;
                                break block5;
                            }
                            case "EncodingType": {
                                bEncodingType = false;
                                break block5;
                            }
                            case "IsTruncated": {
                                bIsTruncated = false;
                                break block5;
                            }
                            case "KeyCount": {
                                bKeyCount = false;
                                break block5;
                            }
                            case "MaxKeys": {
                                bMaxKeys = false;
                                break block5;
                            }
                            case "NextContinuationToken": {
                                bNextContinuationToken = false;
                                break block5;
                            }
                            case "Prefix": {
                                bPrefix = false;
                                break block5;
                            }
                            case "StartAfter": {
                                bStartAfter = false;
                                break block5;
                            }
                            case "ETag": {
                                bETag = false;
                                break block5;
                            }
                            case "Owner": {
                                bOwner = false;
                                break block5;
                            }
                            case "Key": {
                                bKey = false;
                                break block5;
                            }
                            case "LastModified": {
                                bLastModified = false;
                                break block5;
                            }
                            case "Size": {
                                bSize = false;
                                break block5;
                            }
                            case "StorageClass": {
                                bStorageClass = false;
                                break block5;
                            }
                            case "DisplayName": {
                                bDisplayName = false;
                                break block5;
                            }
                            case "ID": {
                                bID = false;
                                continue block108;
                            }
                        }
                        break;
                    }
                    case 8: {
                        reader.close();
                        continue block108;
                    }
                }
            }
            Object object = response.commonPrefixes(commonPrefixes).contents(contents).build();
            return object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }
}

