/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.core.unmarshal;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

final class UnmarshallerUtils {
    private static final String META_PREFIX = "x-amz-meta-";
    private static final int META_PREFIX_LENGTH = "x-amz-meta-".length();
    static final DateTimeFormatter RFC_1123_DATE_TIME_FORMATTER = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneOffset.UTC);

    private UnmarshallerUtils() {
        throw new AssertionError();
    }

    static Optional<String> getHeader(Map<String, List<String>> responseHeaders, String headerName) {
        return Optional.ofNullable(responseHeaders.get(headerName)).map(values -> String.join((CharSequence)",", values));
    }

    static String getHeaderOrNull(Map<String, List<String>> responseHeaders, String headerName) {
        return UnmarshallerUtils.getHeader(responseHeaders, headerName).orElse(null);
    }

    static Instant parseDate(CharSequence source, DateTimeFormatter formatter) {
        return formatter.parse(source, Instant::from);
    }

    static Map<String, String> getMetadata(Map<String, List<String>> headers) {
        Function<Map.Entry, String> keyMapper = entry -> ((String)entry.getKey()).substring(META_PREFIX_LENGTH);
        Function<Map.Entry, String> valueMapper = entry -> String.join((CharSequence)",", (Iterable)entry.getValue());
        return headers.entrySet().stream().filter(entry -> entry.getKey() != null).filter(entry -> ((String)entry.getKey()).startsWith(META_PREFIX)).collect(Collectors.toMap(keyMapper, valueMapper));
    }
}

