/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import org.dynmap.DynmapWorld;
import org.dynmap.utils.MapIterator;
import org.dynmap.utils.VisibilityLimit;

public abstract class MapChunkCache {
    private long[] timeTotal = new long[ChunkStats.values().length];
    private int[] cntTotal = new int[ChunkStats.values().length];

    public abstract boolean setChunkDataTypes(boolean var1, boolean var2, boolean var3, boolean var4);

    public abstract int loadChunks(int var1);

    public abstract boolean isDoneLoading();

    public abstract boolean isEmpty();

    public abstract void unloadChunks();

    public abstract boolean isEmptySection(int var1, int var2, int var3);

    public abstract MapIterator getIterator(int var1, int var2, int var3);

    public abstract void setHiddenFillStyle(HiddenChunkStyle var1);

    public abstract void setVisibleRange(VisibilityLimit var1);

    public abstract void setHiddenRange(VisibilityLimit var1);

    public abstract DynmapWorld getWorld();

    public int getChunksLoaded(ChunkStats type) {
        return this.cntTotal[type.ordinal()];
    }

    public long getTotalRuntimeNanos(ChunkStats type) {
        return this.timeTotal[type.ordinal()];
    }

    protected void endChunkLoad(long startTime, ChunkStats type) {
        int ord;
        int n = ord = type.ordinal();
        this.timeTotal[n] = this.timeTotal[n] + (System.nanoTime() - startTime);
        int n2 = ord;
        this.cntTotal[n2] = this.cntTotal[n2] + 1;
    }

    public static enum ChunkStats {
        CACHED_SNAPSHOT_HIT("Cached"),
        LOADED_CHUNKS("Already Loaded"),
        UNLOADED_CHUNKS("Load Required"),
        UNGENERATED_CHUNKS("Not Generated");

        private final String label;

        private ChunkStats(String lbl) {
            this.label = lbl;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum HiddenChunkStyle {
        FILL_AIR("air"),
        FILL_STONE_PLAIN("stone"),
        FILL_OCEAN("ocean");

        private final String val;

        private HiddenChunkStyle(String v) {
            this.val = v;
        }

        public String getValue() {
            return this.val;
        }

        public static HiddenChunkStyle fromValue(String s) {
            for (HiddenChunkStyle v : HiddenChunkStyle.values()) {
                if (!v.val.equals(s)) continue;
                return v;
            }
            return null;
        }
    }
}

