/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.config;

import com.google.common.base.Splitter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.zurrtum.create.catnip.config.BooleanValue;
import com.zurrtum.create.catnip.config.ConfigBase;
import com.zurrtum.create.catnip.config.ConfigValue;
import com.zurrtum.create.catnip.config.DoubleRawValue;
import com.zurrtum.create.catnip.config.EnumValue;
import com.zurrtum.create.catnip.config.FloatValue;
import com.zurrtum.create.catnip.config.IntValue;
import com.zurrtum.create.catnip.config.StringValue;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FileUtils;

public class Builder {
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public final File configDir;
    public final String type;
    private final List<JsonObject> stack = new LinkedList<JsonObject>();
    private final List<String> comments = new LinkedList<String>();
    public JsonObject object;
    public boolean ignoreComments = false;

    Builder(String id, String type, boolean single) {
        this.configDir = single ? FabricLoader.getInstance().getConfigDir().toFile() : new File(FabricLoader.getInstance().getConfigDir().toFile(), id);
        String string = this.type = single ? id + "-" + type : type;
        if (this.configDir.exists()) {
            this.read();
        }
        if (this.object == null) {
            this.object = new JsonObject();
        }
    }

    public static <T extends ConfigBase> T create(Supplier<T> factory, String id, String type) {
        return Builder.create(factory, id, type, false);
    }

    public static <T extends ConfigBase> T create(Supplier<T> factory, String id, String type, boolean single) {
        ConfigBase config = (ConfigBase)factory.get();
        Builder builder = new Builder(id, type, single);
        config.registerAll(builder);
        builder.ignoreComments = true;
        builder.save();
        return (T)config;
    }

    public void pop(int depth) {
        if (depth > this.stack.size()) {
            throw new IllegalArgumentException("Cannot pop more than the current depth!");
        }
        for (int i = 0; i < depth; ++i) {
            this.object = this.stack.removeLast();
        }
    }

    public void pop() {
        this.pop(1);
    }

    public Builder comment(String ... value) {
        if (this.ignoreComments) {
            return this;
        }
        this.comments.addAll(Arrays.asList(value));
        return this;
    }

    public void addComments(JsonObject object) {
        if (this.ignoreComments) {
            return;
        }
        switch (this.comments.size()) {
            case 0: {
                return;
            }
            case 1: {
                object.addProperty("comment", this.comments.getFirst());
                break;
            }
            default: {
                object.add("comment", GSON.toJsonTree(this.comments));
            }
        }
        this.comments.clear();
    }

    public void push(String path) {
        for (String name : DOT_SPLITTER.split((CharSequence)path)) {
            this.stack.add(this.object);
            JsonObject value = this.object.getAsJsonObject(name);
            if (value == null) {
                value = new JsonObject();
                this.addComments(value);
                this.object.add(name, (JsonElement)value);
            } else {
                this.addComments(value);
            }
            this.object = value;
        }
    }

    public StringValue define(String name, String defaultValue) {
        return new StringValue(this, this.object, name, defaultValue);
    }

    public BooleanValue define(String name, boolean defaultValue) {
        return new BooleanValue(this, this.object, name, defaultValue);
    }

    public DoubleRawValue define(String name, double defaultValue) {
        return new DoubleRawValue(this, this.object, name, defaultValue);
    }

    public <T extends Enum<T>> ConfigValue<T> defineEnum(String name, T defaultValue) {
        return new EnumValue<T>(this, this.object, name, defaultValue);
    }

    public FloatValue defineInRange(String name, float defaultValue, float min, float max) {
        return new FloatValue(this, this.object, name, defaultValue, min, max);
    }

    public IntValue defineInRange(String name, int defaultValue, int min, int max) {
        return new IntValue(this, this.object, name, defaultValue, min, max);
    }

    public void read() {
        File file = new File(this.configDir, this.type + ".json");
        try {
            String fileContents = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            this.object = (JsonObject)GSON.fromJson(fileContents, JsonObject.class);
        }
        catch (IOException e) {
            System.err.println("Failed to read config file: " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    public void save() {
        if (!this.configDir.exists() && !this.configDir.mkdirs()) {
            throw new RuntimeException("Failed to write config file: " + this.configDir.getAbsolutePath());
        }
        this.pop(this.stack.size());
        String jsonStr = GSON.toJson((JsonElement)this.object);
        File file = new File(this.configDir, this.type + ".json");
        try {
            FileUtils.writeStringToFile((File)file, (String)jsonStr, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write config file: " + file.getAbsolutePath(), e);
        }
    }
}

