/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.config;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.zurrtum.create.catnip.config.Builder;

public class DoubleRawValue {
    private final Builder builder;
    private final double defaultValue;
    private final JsonObject parent;
    private final String name;
    private double value;

    DoubleRawValue(Builder builder, JsonObject parent, String name, double defaultValue) {
        this.builder = builder;
        this.parent = parent;
        this.name = name;
        this.defaultValue = defaultValue;
        this.read();
    }

    public double get() {
        return this.value;
    }

    public double getDefault() {
        return this.defaultValue;
    }

    public void set(double value) {
        this.value = value;
        this.parent.addProperty(this.name, (Number)value);
    }

    public void read() {
        JsonPrimitive primitive = this.parent.getAsJsonPrimitive(this.name);
        if (primitive == null) {
            this.set(this.defaultValue);
        } else {
            this.value = primitive.getAsDouble();
        }
    }

    public void save() {
        this.builder.save();
    }
}

