/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.placement;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public interface IPlacementHelper {
    public static final class_2680 ID = new class_2680(class_2246.field_10124, null, null);

    public Predicate<class_1799> getItemPredicate();

    public Predicate<class_2680> getStatePredicate();

    public PlacementOffset getOffset(class_1657 var1, class_1937 var2, class_2680 var3, class_2338 var4, class_3965 var5);

    default public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray, class_1799 heldItem) {
        PlacementOffset offset = this.getOffset(player, world, state, pos, ray);
        class_1792 class_17922 = heldItem.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            offset = offset.withGhostState(blockItem.method_7711().method_9564());
        }
        return offset;
    }

    public static List<class_2350> orderedByDistanceOnlyAxis(class_2338 pos, class_243 hit, class_2350.class_2351 axis) {
        return IPlacementHelper.orderedByDistance(pos, hit, (class_2350 dir) -> dir.method_10166() == axis);
    }

    public static List<class_2350> orderedByDistanceOnlyAxis(class_2338 pos, class_243 hit, class_2350.class_2351 axis, Predicate<class_2350> includeDirection) {
        return IPlacementHelper.orderedByDistance(pos, hit, ((Predicate<class_2350>)dir -> dir.method_10166() == axis).and(includeDirection));
    }

    public static List<class_2350> orderedByDistanceExceptAxis(class_2338 pos, class_243 hit, class_2350.class_2351 axis) {
        return IPlacementHelper.orderedByDistance(pos, hit, (class_2350 dir) -> dir.method_10166() != axis);
    }

    public static List<class_2350> orderedByDistanceExceptAxis(class_2338 pos, class_243 hit, class_2350.class_2351 axis, Predicate<class_2350> includeDirection) {
        return IPlacementHelper.orderedByDistance(pos, hit, ((Predicate<class_2350>)dir -> dir.method_10166() != axis).and(includeDirection));
    }

    public static List<class_2350> orderedByDistanceExceptAxis(class_2338 pos, class_243 hit, class_2350.class_2351 first, class_2350.class_2351 second) {
        return IPlacementHelper.orderedByDistanceExceptAxis(pos, hit, first, (class_2350 d) -> d.method_10166() != second);
    }

    public static List<class_2350> orderedByDistanceExceptAxis(class_2338 pos, class_243 hit, class_2350.class_2351 first, class_2350.class_2351 second, Predicate<class_2350> includeDirection) {
        return IPlacementHelper.orderedByDistanceExceptAxis(pos, hit, first, ((Predicate<class_2350>)d -> d.method_10166() != second).and(includeDirection));
    }

    public static List<class_2350> orderedByDistance(class_2338 pos, class_243 hit) {
        return IPlacementHelper.orderedByDistance(pos, hit, (class_2350 _$) -> true);
    }

    public static List<class_2350> orderedByDistance(class_2338 pos, class_243 hit, Predicate<class_2350> includeDirection) {
        ArrayList<class_2350> directions = new ArrayList<class_2350>();
        for (class_2350 dir : Iterate.directions) {
            if (!includeDirection.test(dir)) continue;
            directions.add(dir);
        }
        return IPlacementHelper.orderedByDistance(pos, hit, directions);
    }

    public static List<class_2350> orderedByDistance(class_2338 pos, class_243 hit, Collection<class_2350> directions) {
        class_243 centerToHit = hit.method_1020(VecHelper.getCenterOf((class_2382)pos));
        ArrayList<Pair> distances = new ArrayList<Pair>();
        for (class_2350 dir : directions) {
            distances.add(Pair.of(dir, class_243.method_24954((class_2382)dir.method_62675()).method_1022(centerToHit)));
        }
        distances.sort(Comparator.comparingDouble(Pair::getSecond));
        ArrayList<class_2350> sortedDirections = new ArrayList<class_2350>();
        for (Pair p : distances) {
            sortedDirections.add((class_2350)p.getFirst());
        }
        return sortedDirections;
    }

    default public boolean matchesItem(class_1799 item) {
        return this.getItemPredicate().test(item);
    }

    default public boolean matchesState(class_2680 state) {
        return this.getStatePredicate().test(state);
    }
}

