/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client;

import com.zurrtum.create.AllFluids;
import com.zurrtum.create.client.content.equipment.armor.DivingLavaFogModifier;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.client.infrastructure.fluid.FluidFogModifier;
import com.zurrtum.create.infrastructure.fluids.FlowableFluid;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_1163;
import net.minecraft.class_1844;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4730;
import net.minecraft.class_758;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class AllFluidConfigs {
    public static final Map<class_3611, FluidConfig> ALL = new IdentityHashMap<class_3611, FluidConfig>();
    public static final Map<class_3611, FluidConfig> CACHE = new IdentityHashMap<class_3611, FluidConfig>();
    private static final FluidConfig LAVA = new FluidConfig(() -> class_310.method_1551().method_1541().field_4167.field_4165[0], () -> class_310.method_1551().method_1541().field_4167.field_4165[1], component -> -1);
    private static final FluidConfig WATER = new FluidConfig(() -> class_310.method_1551().method_1541().field_4167.field_4166[0], () -> class_310.method_1551().method_1541().field_4167.field_4166[1], component -> {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return 4159204;
        }
        return class_1163.method_4961((class_1920)mc.field_1687, (class_2338)mc.field_1724.method_24515());
    });
    public static final boolean HAS_RENDER = FabricLoader.getInstance().isModLoaded("fabric-rendering-fluids-v1");

    private static void config(FlowableFluid fluid) {
        AllFluidConfigs.config(fluid, -1, () -> Float.valueOf(96.0f));
    }

    private static void config(FlowableFluid fluid, int fogColor, Supplier<Float> fogDistance) {
        AllFluidConfigs.config(fluid, fogColor, fogDistance, component -> -1);
    }

    private static void config(FlowableFluid fluid, int fogColor, Supplier<Float> fogDistance, Function<class_9326, Integer> tint) {
        class_2960 id = class_7923.field_41173.method_10221((Object)fluid).method_45138("fluid/");
        FluidConfig config = new FluidConfig(() -> class_310.method_1551().method_72703().method_73030(new class_4730(class_1059.field_5275, id.method_48331("_still"))), () -> class_310.method_1551().method_72703().method_73030(new class_4730(class_1059.field_5275, id.method_48331("_flow"))), tint, fogDistance, fogColor);
        ALL.put((class_3611)fluid, config);
        ALL.put(fluid.method_15750(), config);
    }

    public static FluidConfig get(class_3611 fluid) {
        FluidConfig config = ALL.get(fluid);
        if (config != null) {
            return config;
        }
        if (fluid == class_3612.field_15908 || fluid == class_3612.field_15907) {
            return LAVA;
        }
        if (fluid == class_3612.field_15910 || fluid == class_3612.field_15909) {
            return WATER;
        }
        if (!HAS_RENDER) {
            return null;
        }
        config = CACHE.get(fluid);
        if (config != null) {
            return config;
        }
        FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
        if (handler == null) {
            return null;
        }
        class_310 client = class_310.method_1551();
        class_3610 state = fluid.method_15785();
        config = new FluidConfig(() -> handler.getFluidSprites((class_1920)client.field_1687, client.field_1724 != null ? client.field_1724.method_24515() : null, state)[0], () -> handler.getFluidSprites((class_1920)client.field_1687, client.field_1724 != null ? client.field_1724.method_24515() : null, state)[1], component -> handler.getFluidColor((class_1920)client.field_1687, client.field_1724 != null ? client.field_1724.method_24515() : null, state));
        CACHE.put(fluid, config);
        return config;
    }

    public static void register() {
        class_758.field_60586.addFirst(new DivingLavaFogModifier());
        class_758.field_60586.addFirst(new FluidFogModifier());
        AllFluidConfigs.config(AllFluids.POTION, -1, () -> Float.valueOf(96.0f), component -> {
            Optional potion = component.method_57845(class_9334.field_49651);
            if (potion != null && potion.isPresent()) {
                return ((class_1844)potion.get()).method_8064() | 0xFF000000;
            }
            return class_1844.field_49274.method_8064() | 0xFF000000;
        });
        AllFluidConfigs.config(AllFluids.TEA);
        AllFluidConfigs.config(AllFluids.MILK);
        AllFluidConfigs.config(AllFluids.HONEY, 15380015, () -> Float.valueOf(96.0f * (0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF())));
        AllFluidConfigs.config(AllFluids.CHOCOLATE, 0x622020, () -> Float.valueOf(96.0f * (0.03125f * AllConfigs.client().chocolateTransparencyMultiplier.getF())));
    }
}

