/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllMovementBehaviours;
import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.AllMenuScreens;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.contraptions.ContraptionColliderClient;
import com.zurrtum.create.client.content.contraptions.actors.trainControls.ControlsHandler;
import com.zurrtum.create.client.content.contraptions.elevator.ElevatorContactScreen;
import com.zurrtum.create.client.content.contraptions.glue.SuperGlueSelectionHandler;
import com.zurrtum.create.client.content.contraptions.minecart.CouplingHandlerClient;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.client.content.equipment.bell.SoulPulseEffect;
import com.zurrtum.create.client.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.zurrtum.create.client.content.equipment.clipboard.ClipboardScreen;
import com.zurrtum.create.client.content.equipment.symmetryWand.SymmetryHandlerClient;
import com.zurrtum.create.client.content.equipment.symmetryWand.SymmetryWandScreen;
import com.zurrtum.create.client.content.equipment.zapper.ShootableGadgetRenderHandler;
import com.zurrtum.create.client.content.equipment.zapper.ZapperRenderHandler;
import com.zurrtum.create.client.content.equipment.zapper.terrainzapper.WorldshaperScreen;
import com.zurrtum.create.client.content.fluids.FluidFX;
import com.zurrtum.create.client.content.kinetics.fan.AirCurrentClient;
import com.zurrtum.create.client.content.kinetics.mechanicalArm.ArmInteractionPointHandler;
import com.zurrtum.create.client.content.kinetics.steamEngine.SteamEngineRenderer;
import com.zurrtum.create.client.content.kinetics.transmission.sequencer.SequencedGearshiftScreen;
import com.zurrtum.create.client.content.logistics.AddressEditBoxHelper;
import com.zurrtum.create.client.content.logistics.depot.EjectorTargetHandler;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelConnectionHandler;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelScreen;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelSlotPositioning;
import com.zurrtum.create.client.content.logistics.packagePort.PackagePortTargetSelectionHandler;
import com.zurrtum.create.client.content.processing.burner.BlazeBurnerMovementRenderBehaviour;
import com.zurrtum.create.client.content.processing.burner.BlazeBurnerRenderer;
import com.zurrtum.create.client.content.redstone.displayLink.DisplayLinkScreen;
import com.zurrtum.create.client.content.redstone.link.controller.LinkedControllerClientHandler;
import com.zurrtum.create.client.content.redstone.thresholdSwitch.ThresholdSwitchScreen;
import com.zurrtum.create.client.content.schematics.client.SchematicEditScreen;
import com.zurrtum.create.client.content.trains.TrainHUD;
import com.zurrtum.create.client.content.trains.station.AssemblyScreen;
import com.zurrtum.create.client.content.trains.station.StationScreen;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline;
import com.zurrtum.create.client.flywheel.api.backend.Backend;
import com.zurrtum.create.client.flywheel.api.backend.BackendManager;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.zurrtum.create.client.foundation.render.PlayerSkyhookRenderer;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.client.foundation.utility.ServerSpeedProvider;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContactBlockEntity;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContraption;
import com.zurrtum.create.content.contraptions.gantry.GantryContraptionEntity;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.zurrtum.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.zurrtum.create.content.fluids.PipeConnection;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.zurrtum.create.content.logistics.factoryBoard.PanelSlot;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import com.zurrtum.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.zurrtum.create.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.link.controller.LecternControllerBlockEntity;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity;
import com.zurrtum.create.content.trains.GlobalRailwayManager;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TrainIconType;
import com.zurrtum.create.content.trains.graph.EdgeData;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.signal.SignalEdgeGroup;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlock;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SyncedBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import com.zurrtum.create.infrastructure.debugInfo.DebugInformation;
import com.zurrtum.create.infrastructure.debugInfo.element.DebugInfoSection;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import com.zurrtum.create.infrastructure.packet.c2s.TrackGraphRequestPacket;
import com.zurrtum.create.infrastructure.packet.s2c.AddTrainPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ArmPlacementRequestPacket;
import com.zurrtum.create.infrastructure.packet.s2c.AttachedComputerPacket;
import com.zurrtum.create.infrastructure.packet.s2c.BlueprintPreviewPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ClientboundChainConveyorRidingPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ContraptionBlockChangedPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ContraptionColliderLockPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ContraptionDisableActorPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ContraptionDisassemblyPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ContraptionRelocationPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ContraptionSeatMappingPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ContraptionStallPacket;
import com.zurrtum.create.infrastructure.packet.s2c.EjectorPlacementRequestPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ElevatorFloorListPacket;
import com.zurrtum.create.infrastructure.packet.s2c.FactoryPanelEffectPacket;
import com.zurrtum.create.infrastructure.packet.s2c.FluidSplashPacket;
import com.zurrtum.create.infrastructure.packet.s2c.FunnelFlapPacket;
import com.zurrtum.create.infrastructure.packet.s2c.GantryContraptionUpdatePacket;
import com.zurrtum.create.infrastructure.packet.s2c.GlueEffectPacket;
import com.zurrtum.create.infrastructure.packet.s2c.HighlightPacket;
import com.zurrtum.create.infrastructure.packet.s2c.HonkReturnPacket;
import com.zurrtum.create.infrastructure.packet.s2c.LimbSwingUpdatePacket;
import com.zurrtum.create.infrastructure.packet.s2c.LogisticalStockResponsePacket;
import com.zurrtum.create.infrastructure.packet.s2c.MountedStorageSyncPacket;
import com.zurrtum.create.infrastructure.packet.s2c.OpenScreenPacket;
import com.zurrtum.create.infrastructure.packet.s2c.PackageDestroyPacket;
import com.zurrtum.create.infrastructure.packet.s2c.PackagePortPlacementRequestPacket;
import com.zurrtum.create.infrastructure.packet.s2c.PotatoCannonPacket;
import com.zurrtum.create.infrastructure.packet.s2c.RedstoneRequesterEffectPacket;
import com.zurrtum.create.infrastructure.packet.s2c.RemoveBlockEntityPacket;
import com.zurrtum.create.infrastructure.packet.s2c.RemoveTrainPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ServerDebugInfoPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ServerSpeedPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ShopUpdatePacket;
import com.zurrtum.create.infrastructure.packet.s2c.SignalEdgeGroupPacket;
import com.zurrtum.create.infrastructure.packet.s2c.SoulPulseEffectPacket;
import com.zurrtum.create.infrastructure.packet.s2c.SymmetryEffectPacket;
import com.zurrtum.create.infrastructure.packet.s2c.TrackGraphRollCallPacket;
import com.zurrtum.create.infrastructure.packet.s2c.TrackGraphSyncPacket;
import com.zurrtum.create.infrastructure.packet.s2c.TrainEditReturnPacket;
import com.zurrtum.create.infrastructure.packet.s2c.TrainHUDControlUpdatePacket;
import com.zurrtum.create.infrastructure.packet.s2c.TrainPromptPacket;
import com.zurrtum.create.infrastructure.packet.s2c.TunnelFlapPacket;
import com.zurrtum.create.infrastructure.packet.s2c.WiFiEffectPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ZapperBeamPacket;
import com.zurrtum.create.infrastructure.particle.AirFlowParticleData;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11980;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2600;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2792;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5365;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_9129;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class AllHandle
extends AllClientHandle {
    public static void register() {
        AllClientHandle.INSTANCE = new AllHandle();
    }

    protected void forceMainThread(class_2602 listener, class_310 mc, class_2596<class_2602> packet) {
        if (listener instanceof class_634) {
            class_2600.method_11074(packet, (class_2547)listener, (class_11980)mc.method_74186());
        }
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean shiftDown() {
        return AllKeys.hasShiftDown();
    }

    @Override
    public void onSymmetryEffect(class_2602 listener, SymmetryEffectPacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_2338 mirror = packet.mirror();
        if (mc.field_1724.method_73189().method_1022(class_243.method_24954((class_2382)mirror)) > 100.0) {
            return;
        }
        for (class_2338 to : packet.positions()) {
            SymmetryHandlerClient.drawEffect(mc, mirror, to);
        }
    }

    @Override
    public void onLogisticalStockResponse(class_2602 listener, LogisticalStockResponsePacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_2586 class_25862 = mc.field_1687.method_8321(packet.pos());
        if (class_25862 instanceof StockTickerBlockEntity) {
            StockTickerBlockEntity stbe = (StockTickerBlockEntity)class_25862;
            stbe.receiveStockPacket(packet.items(), packet.lastPacket());
        }
    }

    @Override
    public void onTrainEditReturn(TrainEditReturnPacket packet) {
        Train train = Create.RAILWAYS.trains.get(packet.id());
        if (train == null) {
            return;
        }
        if (!packet.name().isBlank()) {
            train.name = class_2561.method_43470((String)packet.name());
        }
        train.icon = TrainIconType.byId(packet.iconType());
        train.mapColorIndex = packet.mapColor();
    }

    @Override
    public void onTrainHUDControlUpdate(TrainHUDControlUpdatePacket packet) {
        Train train = Create.RAILWAYS.trains.get(packet.trainId());
        if (train == null) {
            return;
        }
        if (packet.throttle() != null) {
            train.throttle = packet.throttle();
        }
        train.speed = packet.speed();
        train.fuelTicks = packet.fuelTicks();
    }

    @Override
    public void onTrainHonkReturn(HonkReturnPacket packet) {
        Train train = Create.RAILWAYS.trains.get(packet.trainId());
        if (train == null) {
            return;
        }
        train.honkTicks = packet.isHonk() ? (train.honkTicks == 0 ? 20 : 13) : (train.honkTicks > 5 ? 6 : 0);
    }

    @Override
    public void onElevatorFloorList(class_2602 listener, ElevatorFloorListPacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_1297 entityByID = mc.field_1687.method_8469(packet.entityId());
        if (!(entityByID instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity ace = (AbstractContraptionEntity)entityByID;
        Contraption contraption = ace.getContraption();
        if (!(contraption instanceof ElevatorContraption)) {
            return;
        }
        ElevatorContraption ec = (ElevatorContraption)contraption;
        ec.namesList = packet.floors();
        ec.syncControlDisplays();
    }

    @Override
    public void onContraptionColliderLock(ContraptionColliderLockPacket packet) {
        ContraptionColliderClient.lockPacketReceived(packet.contraption(), packet.sender(), packet.offset());
    }

    @Override
    public void onWiFiEffect(class_2602 listener, WiFiEffectPacket packet) {
        SmartBlockEntity plbe;
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_2586 blockEntity = mc.field_1687.method_8321(packet.pos());
        if (blockEntity instanceof PackagerLinkBlockEntity) {
            plbe = (PackagerLinkBlockEntity)blockEntity;
            ((PackagerLinkBlockEntity)plbe).playEffect();
        }
        if (blockEntity instanceof StockTickerBlockEntity) {
            plbe = (StockTickerBlockEntity)blockEntity;
            ((StockTickerBlockEntity)plbe).playEffect();
        }
    }

    @Override
    public void onControlsStopControlling() {
        ControlsHandler.stopControlling(class_310.method_1551().field_1724);
    }

    @Override
    public void onServerSpeed(ServerSpeedPacket packet) {
        if (!ServerSpeedProvider.initialized) {
            ServerSpeedProvider.initialized = true;
            ServerSpeedProvider.clientTimer = 0;
            return;
        }
        float target = (float)packet.speed() / (float)Math.max(ServerSpeedProvider.clientTimer, 1);
        ServerSpeedProvider.modifier.chase(Math.min(target, 1.0f), 0.25, LerpedFloat.Chaser.EXP);
        ServerSpeedProvider.clientTimer = -1;
    }

    private <T extends ShootableGadgetRenderHandler> void onShootGadget(class_1297 renderViewEntity, class_243 location, class_1268 hand, boolean self, T handler, Consumer<T> handleAdditional) {
        if (renderViewEntity == null) {
            return;
        }
        if (renderViewEntity.method_73189().method_1022(location) > 100.0) {
            return;
        }
        handleAdditional.accept(handler);
        if (self) {
            handler.shoot(hand, location);
        } else {
            handler.playSound(hand, location);
        }
    }

    @Override
    public void onZapperBeam(class_2602 listener, ZapperBeamPacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        this.onShootGadget(mc.method_1560(), packet.location(), packet.hand(), packet.self(), Create.ZAPPER_RENDER_HANDLER, handler -> handler.addBeam(class_310.method_1551(), new ZapperRenderHandler.LaserBeam(packet.location(), packet.target())));
    }

    @Override
    public void onPotatoCannon(class_2602 listener, PotatoCannonPacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        this.onShootGadget(mc.method_1560(), packet.location(), packet.hand(), packet.self(), Create.POTATO_CANNON_RENDER_HANDLER, handler -> handler.beforeShoot(packet.pitch(), packet.location(), packet.motion(), packet.item()));
    }

    @Override
    public void onContraptionStall(ContraptionStallPacket packet) {
        class_1297 class_12972 = class_310.method_1551().field_1687.method_8469(packet.entityId());
        if (class_12972 instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity ce = (AbstractContraptionEntity)class_12972;
            ce.handleStallInformation(packet.x(), packet.y(), packet.z(), packet.angle());
        }
    }

    @Override
    public void onContraptionDisassembly(ContraptionDisassemblyPacket packet) {
        class_1297 class_12972 = class_310.method_1551().field_1687.method_8469(packet.entityId());
        if (class_12972 instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity ce = (AbstractContraptionEntity)class_12972;
            ce.moveCollidedEntitiesOnDisassembly(packet.transform());
        }
    }

    @Override
    public void onContraptionBlockChanged(ContraptionBlockChangedPacket packet) {
        class_1297 class_12972 = class_310.method_1551().field_1687.method_8469(packet.entityId());
        if (class_12972 instanceof AbstractContraptionEntity) {
            class_2338 localPos;
            AbstractContraptionEntity ce = (AbstractContraptionEntity)class_12972;
            Contraption contraption = ce.getContraption();
            if (contraption == null) {
                return;
            }
            Map<class_2338, class_3499.class_3501> blocks = contraption.getBlocks();
            if (!blocks.containsKey(localPos = packet.localPos())) {
                return;
            }
            class_3499.class_3501 info = blocks.get(localPos);
            class_2680 newState = packet.newState();
            blocks.put(localPos, new class_3499.class_3501(info.comp_1341(), newState, info.comp_1343()));
            if (info.comp_1342() != newState && !(newState.method_26204() instanceof SlidingDoorBlock)) {
                ClientContraption.resetClientContraption(contraption);
            }
            contraption.invalidateColliders();
        }
    }

    @Override
    public void onGlueEffect(class_2602 listener, GlueEffectPacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_746 player = mc.field_1724;
        if (!player.method_24515().method_19771((class_2382)packet.pos(), 100.0)) {
            return;
        }
        SuperGlueSelectionHandler.spawnParticles(player.method_73183(), packet.pos(), packet.direction(), packet.fullBlock());
    }

    @Override
    public void onContraptionSeatMapping(ContraptionSeatMappingPacket packet) {
        class_243 transformedVector;
        class_746 player = class_310.method_1551().field_1724;
        class_1297 entityByID = player.method_73183().method_8469(packet.entityId());
        if (!(entityByID instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entityByID;
        if (packet.dismountedId() == player.method_5628() && (transformedVector = contraptionEntity.getPassengerPosition((class_1297)player, 1.0f)) != null) {
            AllSynchedDatas.CONTRAPTION_DISMOUNT_LOCATION.set((class_1297)player, Optional.of(transformedVector));
        }
        contraptionEntity.getContraption().setSeatMapping(packet.mapping());
    }

    @Override
    public void onLimbSwingUpdate(class_2602 listener, LimbSwingUpdatePacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_638 world = mc.field_1687;
        class_1297 entity = world.method_8469(packet.entityId());
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        AllSynchedDatas.LAST_OVERRIDE_LIMB_SWING_UPDATE.set((class_1297)player, 0);
        AllSynchedDatas.OVERRIDE_LIMB_SWING.set((class_1297)player, Float.valueOf(packet.limbSwing()));
        class_243 position = packet.position();
        player.method_66246(position, player.method_36454(), player.method_36455());
    }

    @Override
    public void onFluidSplash(FluidSplashPacket packet) {
        class_2338 pos = packet.pos();
        class_243 class_2432 = new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        if (class_310.method_1551().field_1724.method_73189().method_1022(class_2432) > 100.0) {
            return;
        }
        FluidFX.splash(pos, packet.fluid());
    }

    @Override
    public void onMountedStorageSync(MountedStorageSyncPacket packet) {
        class_1297 entity = class_310.method_1551().field_1687.method_8469(packet.contraptionId());
        if (!(entity instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity contraption = (AbstractContraptionEntity)entity;
        contraption.getContraption().getStorage().handleSync(packet, contraption);
    }

    @Override
    public void onGantryContraptionUpdate(GantryContraptionUpdatePacket packet) {
        class_1297 entity = class_310.method_1551().field_1687.method_8469(packet.entityID());
        if (!(entity instanceof GantryContraptionEntity)) {
            return;
        }
        GantryContraptionEntity ce = (GantryContraptionEntity)entity;
        ce.axisMotion = packet.motion();
        ce.clientOffsetDiff = packet.coord() - ce.getAxisCoord();
        ce.sequencedOffsetLimit = packet.sequenceLimit();
    }

    @Override
    public void onHighlight(HighlightPacket packet) {
        if (!class_310.method_1551().field_1687.method_8477(packet.pos())) {
            return;
        }
        Outliner.getInstance().showAABB("highlightCommand", class_259.method_1077().method_1107().method_996(packet.pos()), 200).lineWidth(0.03125f).colored(0xEEEEEE).withFaceTexture(AllSpecialTextures.SELECTION);
    }

    @Override
    public void onTunnelFlap(TunnelFlapPacket packet) {
        class_2586 class_25862 = class_310.method_1551().field_1687.method_8321(packet.pos());
        if (class_25862 instanceof BeltTunnelBlockEntity) {
            BeltTunnelBlockEntity blockEntity = (BeltTunnelBlockEntity)class_25862;
            packet.flaps().forEach(flap -> blockEntity.flap((class_2350)flap.getFirst(), (Boolean)flap.getSecond()));
        }
    }

    @Override
    public void onFunnelFlap(class_2602 listener, FunnelFlapPacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_2586 class_25862 = mc.field_1687.method_8321(packet.pos());
        if (class_25862 instanceof FunnelBlockEntity) {
            FunnelBlockEntity blockEntity = (FunnelBlockEntity)class_25862;
            blockEntity.flap(packet.inwards());
        }
    }

    @Override
    public void onSoulPulseEffect(SoulPulseEffectPacket packet) {
        Create.SOUL_PULSE_EFFECT_HANDLER.addPulse(new SoulPulseEffect(packet.pos(), packet.distance(), packet.canOverlap()));
    }

    @Override
    public void onSignalEdgeGroup(SignalEdgeGroupPacket packet) {
        Map<UUID, SignalEdgeGroup> signalEdgeGroups = Create.RAILWAYS.signalEdgeGroups;
        List<UUID> ids = packet.ids();
        for (int i = 0; i < ids.size(); ++i) {
            UUID id = ids.get(i);
            if (!packet.add()) {
                signalEdgeGroups.remove(id);
                continue;
            }
            SignalEdgeGroup group = new SignalEdgeGroup(id);
            signalEdgeGroups.put(id, group);
            if (i >= packet.colors().size()) continue;
            group.color = packet.colors().get(i);
        }
    }

    @Override
    public void onRemoveTrain(RemoveTrainPacket packet) {
        Create.RAILWAYS.trains.remove(packet.id());
    }

    @Override
    public void onRemoveBlockEntity(class_2602 listener, RemoveBlockEntityPacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_2586 class_25862 = mc.field_1687.method_8321(packet.pos());
        if (class_25862 instanceof SyncedBlockEntity) {
            SyncedBlockEntity be = (SyncedBlockEntity)class_25862;
            if (!be.method_11002()) {
                be.method_11012();
                return;
            }
            be.method_10997().method_8544(packet.pos());
        }
    }

    @Override
    public void onTrainPrompt(TrainPromptPacket packet) {
        TrainHUD.currentPrompt = packet.text();
        TrainHUD.currentPromptShadow = packet.shadow();
        TrainHUD.promptKeepAlive = 30;
    }

    @Override
    public void onContraptionRelocation(ContraptionRelocationPacket packet) {
        class_1297 class_12972 = class_310.method_1551().field_1687.method_8469(packet.entityId());
        if (class_12972 instanceof OrientedContraptionEntity) {
            OrientedContraptionEntity oce = (OrientedContraptionEntity)class_12972;
            oce.nonDamageTicks = 10;
        }
    }

    @Override
    public void onTrackGraphRollCall(TrackGraphRollCallPacket packet) {
        GlobalRailwayManager manager = Create.RAILWAYS;
        HashSet<UUID> unusedIds = new HashSet<UUID>(manager.trackNetworks.keySet());
        ArrayList<Integer> failedIds = new ArrayList<Integer>();
        HashMap idByNetId = new HashMap();
        manager.trackNetworks.forEach((uuid, g) -> idByNetId.put(g.netId, uuid));
        for (TrackGraphRollCallPacket.Entry entry : packet.entries()) {
            UUID uuid2 = (UUID)idByNetId.get(entry.netId());
            if (uuid2 == null) {
                failedIds.add(entry.netId());
                continue;
            }
            unusedIds.remove(uuid2);
            TrackGraph trackGraph = manager.trackNetworks.get(uuid2);
            if (trackGraph.getChecksum() == entry.checksum()) continue;
            com.zurrtum.create.Create.LOGGER.warn("Track network: {} failed its checksum; Requesting refresh", (Object)uuid2.toString().substring(0, 6));
            failedIds.add(entry.netId());
        }
        class_634 networkHandler = class_310.method_1551().field_1724.field_3944;
        for (Integer failed : failedIds) {
            networkHandler.method_52787((class_2596)new TrackGraphRequestPacket(failed));
        }
        for (UUID unused : unusedIds) {
            manager.trackNetworks.remove(unused);
        }
    }

    @Override
    public void onArmPlacementRequest(ArmPlacementRequestPacket packet) {
        ArmInteractionPointHandler.flushSettings(class_310.method_1551().field_1724, packet.pos());
    }

    @Override
    public void onEjectorPlacementRequest(EjectorPlacementRequestPacket packet) {
        EjectorTargetHandler.flushSettings(packet.pos());
    }

    @Override
    public void onPackagePortPlacementRequest(PackagePortPlacementRequestPacket packet) {
        PackagePortTargetSelectionHandler.flushSettings(class_310.method_1551().field_1724, packet.pos());
    }

    @Override
    public void onContraptionDisableActor(class_2602 listener, ContraptionDisableActorPacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_1297 entityByID = mc.field_1687.method_8469(packet.entityId());
        if (!(entityByID instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity ace = (AbstractContraptionEntity)entityByID;
        Contraption contraption = ace.getContraption();
        List<class_1799> disabledActors = contraption.getDisabledActors();
        class_1799 filter = packet.filter();
        if (filter.method_7960()) {
            disabledActors.clear();
        }
        if (!packet.enable()) {
            disabledActors.add(filter);
            contraption.setActorsActive(filter, false);
            return;
        }
        disabledActors.removeIf(next -> ContraptionControlsMovement.isSameFilter(next, filter) || next.method_7960());
        contraption.setActorsActive(filter, true);
    }

    @Override
    public void onAttachedComputer(class_2602 listener, AttachedComputerPacket packet) {
        SmartBlockEntity be;
        AbstractComputerBehaviour computer;
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_2586 class_25862 = mc.field_1687.method_8321(packet.pos());
        if (class_25862 instanceof SmartBlockEntity && (computer = (be = (SmartBlockEntity)class_25862).getBehaviour(AbstractComputerBehaviour.TYPE)) != null) {
            computer.setHasAttachedComputer(packet.hasAttachedComputer());
        }
    }

    @Override
    public void onServerDebugInfo(ServerDebugInfoPacket packet) {
        StringBuilder output = new StringBuilder();
        List<DebugInfoSection> clientInfo = DebugInformation.getClientInfo();
        class_310 mc = class_310.method_1551();
        ServerDebugInfoPacket.printInfo("Client", (class_1657)mc.field_1724, clientInfo, output);
        output.append("\n\n");
        output.append(packet.serverInfo());
        String text = output.toString();
        mc.field_1774.method_1455(text);
        mc.field_1724.method_7353((class_2561)class_2561.method_43471((String)"create.command.debuginfo.saved_to_clipboard").method_54663(((Integer)DyeHelper.getDyeColors(class_1767.field_7961).getFirst()).intValue()), false);
    }

    @Override
    public void onPackageDestroy(class_2602 listener, PackageDestroyPacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_638 world = mc.field_1687;
        class_243 motion = VecHelper.offsetRandomly(class_243.field_1353, world.method_8409(), 0.125f);
        class_243 pos = packet.location().method_1019(motion.method_1021(4.0));
        world.method_8406((class_2394)new class_2392(class_2398.field_11218, packet.box()), pos.field_1352, pos.field_1351, pos.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
    }

    @Override
    public void onFactoryPanelEffect(class_2602 listener, FactoryPanelEffectPacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_638 world = mc.field_1687;
        class_2680 blockState = world.method_8320(packet.fromPos().pos());
        if (!blockState.method_27852((class_2248)AllBlocks.FACTORY_GAUGE)) {
            return;
        }
        ServerFactoryPanelBehaviour panelBehaviour = ServerFactoryPanelBehaviour.at((class_1920)world, packet.toPos());
        if (panelBehaviour != null) {
            panelBehaviour.bulb.setValue(1.0);
            FactoryPanelConnection connection = panelBehaviour.targetedBy.get(packet.fromPos());
            if (connection != null) {
                connection.success = packet.success();
            }
        }
    }

    @Override
    public void onRedstoneRequesterEffect(class_2602 listener, RedstoneRequesterEffectPacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_2586 class_25862 = mc.field_1687.method_8321(packet.pos());
        if (class_25862 instanceof RedstoneRequesterBlockEntity) {
            RedstoneRequesterBlockEntity plbe = (RedstoneRequesterBlockEntity)class_25862;
            plbe.playEffect(packet.success());
        }
    }

    @Override
    public void onClientboundChainConveyorRiding(ClientboundChainConveyorRidingPacket packet) {
        PlayerSkyhookRenderer.updatePlayerList(packet.uuids());
    }

    @Override
    public void onShopUpdate(class_2602 listener, ShopUpdatePacket packet) {
        class_310 mc = class_310.method_1551();
        this.forceMainThread(listener, mc, packet);
        class_2586 class_25862 = mc.field_1687.method_8321(packet.pos());
        if (class_25862 instanceof TableClothBlockEntity) {
            TableClothBlockEntity blockEntity = (TableClothBlockEntity)class_25862;
            if (!blockEntity.method_11002()) {
                return;
            }
            blockEntity.invalidateItemsForRender();
        }
    }

    @Override
    public void onTrackGraphSync(TrackGraphSyncPacket packet) {
        GlobalRailwayManager manager = Create.RAILWAYS;
        TrackGraph graph = manager.getOrCreateGraph(packet.graphId, packet.netId);
        ++manager.version;
        if (packet.packetDeletesGraph) {
            manager.removeGraph(graph);
            return;
        }
        if (packet.fullWipe) {
            manager.removeGraph(graph);
            graph = Create.RAILWAYS.sided(null).getOrCreateGraph(packet.graphId, packet.netId);
        }
        Iterator<Object> iterator = packet.removedNodes.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            TrackNode node = graph.getNode(n);
            if (node == null) continue;
            graph.removeNode(null, node.getLocation());
        }
        for (Map.Entry entry : packet.addedNodes.entrySet()) {
            Integer nodeId = (Integer)entry.getKey();
            Pair nodeLocation = (Pair)entry.getValue();
            graph.loadNode((TrackNodeLocation)((Object)nodeLocation.getFirst()), nodeId, (class_243)nodeLocation.getSecond());
        }
        for (Pair pair : packet.addedEdges) {
            Couple<TrackNode> nodes = ((Couple)((Pair)pair.getFirst()).getFirst()).map(graph::getNode);
            TrackNode node1 = (TrackNode)nodes.getFirst();
            TrackNode node2 = (TrackNode)nodes.getSecond();
            if (node1 == null || node2 == null) continue;
            graph.putConnection(node1, node2, new TrackEdge(node1, node2, (BezierConnection)pair.getSecond(), (TrackMaterial)((Pair)pair.getFirst()).getSecond()));
        }
        for (TrackEdgePoint trackEdgePoint : packet.addedEdgePoints) {
            graph.edgePoints.put(trackEdgePoint.getType(), trackEdgePoint);
        }
        for (UUID uUID : packet.removedEdgePoints) {
            for (EdgePointType<?> type : EdgePointType.TYPES.values()) {
                graph.edgePoints.remove(type, uUID);
            }
        }
        this.handleEdgeData(packet.updatedEdgeData, graph);
        if (!packet.splitSubGraphs.isEmpty()) {
            graph.findDisconnectedGraphs(null, packet.splitSubGraphs).forEach(manager::putGraph);
        }
    }

    private void handleEdgeData(Map<Couple<Integer>, Pair<Integer, List<UUID>>> updatedEdgeData, TrackGraph graph) {
        for (Map.Entry<Couple<Integer>, Pair<Integer, List<UUID>>> entry : updatedEdgeData.entrySet()) {
            int i;
            TrackEdge edge;
            List<UUID> idList = entry.getValue().getSecond();
            int groupType = entry.getValue().getFirst();
            Couple<TrackNode> nodes = entry.getKey().map(graph::getNode);
            if (nodes.either(Objects::isNull) || (edge = graph.getConnectionsFrom((TrackNode)nodes.getFirst()).get(nodes.getSecond())) == null) continue;
            EdgeData edgeData = new EdgeData(edge);
            if (groupType == 0) {
                edgeData.setSingleSignalGroup(null, null, null);
            } else if (groupType == 1) {
                edgeData.setSingleSignalGroup(null, null, EdgeData.passiveGroup);
            } else {
                edgeData.setSingleSignalGroup(null, null, idList.getFirst());
            }
            List<TrackEdgePoint> points = edgeData.getPoints();
            edge.edgeData = edgeData;
            int n = i = groupType == 2 ? 1 : 0;
            while (i < idList.size()) {
                UUID uuid = idList.get(i);
                for (EdgePointType<?> type : EdgePointType.TYPES.values()) {
                    Object point = graph.edgePoints.get(type, uuid);
                    if (point == null) continue;
                    points.add((TrackEdgePoint)point);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void onAddTrain(AddTrainPacket packet) {
        Train train = packet.train();
        Create.RAILWAYS.trains.put(train.id, train);
    }

    @Override
    public void onOpenScreen(class_2602 listener, OpenScreenPacket packet) {
        if (listener instanceof class_634) {
            class_634 handler = (class_634)listener;
            class_2600.method_11074((class_2596)packet, (class_2547)handler, (class_11980)class_310.method_1551().method_74186());
            class_9129 extraData = new class_9129(Unpooled.wrappedBuffer((byte[])packet.data()), (class_5455)handler.method_29091());
            AllMenuScreens.open(class_310.method_1551(), packet.type(), packet.id(), packet.name(), extraData);
            extraData.release();
        }
    }

    @Override
    public void onBlueprintPreview(BlueprintPreviewPacket packet) {
        BlueprintOverlayRenderer.updatePreview(packet.available(), packet.missing(), packet.result());
    }

    @Override
    public void buildDebugInfo() {
        DebugInfoSection.builder("Graphics").put("Flywheel Version", DebugInformation.getVersionOfMod("flywheel")).put("Flywheel Backend", () -> Backend.REGISTRY.getIdOrThrow(BackendManager.currentBackend()).toString()).put("OpenGL Renderer", GlStateManager._getString((int)7937)).put("OpenGL Version", GlStateManager._getString((int)7938)).put("Graphics Mode", () -> ((class_5365)class_310.method_1551().field_1690.method_42534().method_41753()).name().toLowerCase(Locale.ROOT)).buildTo(DebugInformation::registerClientInfo);
    }

    @Override
    public class_1657 getPlayer() {
        return class_310.method_1551().field_1724;
    }

    @Override
    public void queueUpdate(class_2586 entity) {
        VisualizationHelper.queueUpdate(entity);
    }

    @Override
    public void addAirFlowParticle(class_1937 world, class_2338 airCurrentPos, double x, double y, double z) {
        if (world.field_9229.method_43057() < ((Float)AllConfigs.client().fanParticleDensity.get()).floatValue()) {
            world.method_8406((class_2394)new AirFlowParticleData((class_2382)airCurrentPos), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void enableClientPlayerSound(class_1297 entity, float clamp) {
        AirCurrentClient.enableClientPlayerSound(entity, clamp);
    }

    @Override
    public void showWaterBounds(class_2350.class_2351 axis, class_1750 context) {
        class_2338 pos = context.method_8037();
        class_243 contract = class_243.method_24954((class_2382)class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis).method_62675());
        Outliner.getInstance().showAABB(Pair.of("waterwheel", pos), new class_238(pos).method_1014(1.0).method_35580(contract.field_1352, contract.field_1351, contract.field_1350)).colored(-41620);
        CreateLang.translate("large_water_wheel.not_enough_space", new Object[0]).color(-41620).sendStatus(context.method_8036());
    }

    @Override
    public float getServerSpeed() {
        return ServerSpeedProvider.get();
    }

    @Override
    public void resetClientContraption(Contraption contraption) {
        ClientContraption.resetClientContraption(contraption);
    }

    @Override
    public void invalidateClientContraptionChildren(Contraption contraption) {
        ClientContraption.invalidateClientContraptionChildren(contraption);
    }

    @Override
    @Nullable
    public class_2586 getBlockEntityClientSide(Contraption contraption, class_2338 localPos) {
        return ClientContraption.getBlockEntityClientSide(contraption, localPos);
    }

    @Override
    public void spawnPipeParticles(class_1937 world, class_2338 pos, PipeConnection.Flow flow, boolean openEnd, class_2350 side, int amount) {
        class_310 mc = class_310.method_1551();
        if (world == mc.field_1687 && AllHandle.isRenderEntityWithoutDistance(mc, pos)) {
            return;
        }
        if (openEnd) {
            AllHandle.spawnPouringLiquid(world, pos, flow, side, amount);
        } else if (world.field_9229.method_43057() < 0.001f) {
            AllHandle.spawnRimParticles(world, pos, flow.fluid, side, amount);
        }
    }

    private static boolean isRenderEntityWithoutDistance(class_310 mc, class_2338 pos) {
        class_1297 renderViewEntity = mc.method_1560();
        if (renderViewEntity == null) {
            return true;
        }
        class_243 center = VecHelper.getCenterOf((class_2382)pos);
        return renderViewEntity.method_73189().method_1022(center) > 20.0;
    }

    private static void spawnRimParticles(class_1937 world, class_2338 pos, FluidStack fluid, class_2350 side, int amount) {
        class_2394 particle = FluidFX.getDrippingParticle(fluid);
        FluidFX.spawnRimParticles(world, pos, side, amount, particle, 0.265625f);
    }

    private static void spawnPouringLiquid(class_1937 world, class_2338 pos, PipeConnection.Flow flow, class_2350 side, int amount) {
        class_2394 particle = FluidFX.getFluidParticle(flow.fluid);
        class_243 directionVec = class_243.method_24954((class_2382)side.method_62675());
        FluidFX.spawnPouringLiquid(world, pos, amount, particle, 0.265625f, directionVec, flow.inbound);
    }

    @Override
    public void spawnSteamEngineParticles(SteamEngineBlockEntity be) {
        FluidTankBlockEntity controller;
        float angle;
        Float targetAngle = SteamEngineRenderer.getTargetAngle(be);
        PoweredShaftBlockEntity ste = (PoweredShaftBlockEntity)be.target.get();
        if (ste == null) {
            return;
        }
        if (!ste.isPoweredBy(be.method_11016()) || ste.engineEfficiency == 0.0f) {
            return;
        }
        if (targetAngle == null) {
            return;
        }
        angle += (angle = AngleHelper.deg(targetAngle.floatValue())) < 0.0f ? -105.0f : 285.0f;
        angle %= 360.0f;
        PoweredShaftBlockEntity shaft = be.getShaft();
        if (shaft == null || shaft.getSpeed() == 0.0f) {
            return;
        }
        if (!(!(angle >= 0.0f) || be.prevAngle > 180.0f && angle < 180.0f)) {
            be.prevAngle = angle;
            return;
        }
        if (!(!(angle < 0.0f) || be.prevAngle < -180.0f && angle > -180.0f)) {
            be.prevAngle = angle;
            return;
        }
        FluidTankBlockEntity sourceBE = (FluidTankBlockEntity)be.source.get();
        if (sourceBE != null && (controller = sourceBE.getControllerBE()) != null && controller.boiler != null) {
            controller.boiler.queueSoundOnSide(be.method_11016(), SteamEngineBlock.getFacing(be.method_11010()));
        }
        class_2350 facing = SteamEngineBlock.getFacing(be.method_11010());
        class_1937 world = be.method_10997();
        class_243 offset = VecHelper.rotate(new class_243(0.0, 0.0, 1.0).method_1019(VecHelper.offsetRandomly(class_243.field_1353, world.field_9229, 1.0f).method_18805(1.0, 1.0, 0.0).method_1029().method_1021(0.5)), AngleHelper.verticalAngle(facing), class_2350.class_2351.field_11048);
        offset = VecHelper.rotate(offset, AngleHelper.horizontalAngle(facing), class_2350.class_2351.field_11052);
        class_243 v = offset.method_1021(0.5).method_1019(class_243.method_24953((class_2382)be.method_11016()));
        class_243 m = offset.method_1020(class_243.method_24954((class_2382)facing.method_62675()).method_1021(0.75));
        world.method_8406((class_2394)AllParticleTypes.STEAM_JET, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
        be.prevAngle = angle;
    }

    @Override
    public void spawnSuperGlueParticles(class_1937 world, class_2338 pos, class_2350 direction, boolean fullBlock) {
        SuperGlueSelectionHandler.spawnParticles(world, pos, direction, fullBlock);
    }

    @Override
    public void tickBlazeBurnerAnimation(BlazeBurnerBlockEntity be) {
        if (!VisualizationManager.supportsVisualization((class_1936)be.method_10997())) {
            BlazeBurnerRenderer.tickAnimation(be);
        }
    }

    @Override
    public void sendPacket(class_2596<class_2792> packet) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.field_3944.method_52787(packet);
        }
    }

    @Override
    public void sendPacket(class_1657 player, class_2596<class_2792> packet) {
        if (player instanceof class_746) {
            class_746 clientPlayer = (class_746)player;
            clientPlayer.field_3944.method_52787(packet);
        }
    }

    @Override
    public void createBasinFluidParticles(class_1937 world, BasinBlockEntity blockEntity) {
        class_5819 r = world.field_9229;
        if (!blockEntity.visualizedOutputFluids.isEmpty()) {
            AllHandle.createBasinOutputFluidParticles(world, blockEntity, r);
        }
        if (!blockEntity.areFluidsMoving && r.method_43057() > 0.125f) {
            return;
        }
        int segments = 0;
        for (SmartFluidTankBehaviour behaviour : blockEntity.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                ++segments;
            }
        }
        if (segments < 2) {
            return;
        }
        float totalUnits = blockEntity.getTotalFluidUnits(0.0f);
        if (totalUnits == 0.0f) {
            return;
        }
        float fluidLevel = class_3532.method_15363((float)(totalUnits / 162000.0f), (float)0.0f, (float)1.0f);
        float rim = 0.125f;
        float space = 0.75f;
        class_2338 pos = blockEntity.method_11016();
        float surface = (float)pos.method_10264() + rim + space * fluidLevel + 0.03125f;
        if (blockEntity.areFluidsMoving) {
            AllHandle.createBasinMovingFluidParticles(world, blockEntity, surface, segments);
            return;
        }
        for (SmartFluidTankBehaviour behaviour : blockEntity.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                float x = (float)pos.method_10263() + rim + space * r.method_43057();
                float z = (float)pos.method_10260() + rim + space * r.method_43057();
                FluidStack stack = tankSegment.getRenderedFluid();
                world.method_8494((class_2394)new FluidParticleData(AllParticleTypes.BASIN_FLUID, stack.getFluid(), stack.getComponentChanges()), (double)x, (double)surface, (double)z, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void createBasinOutputFluidParticles(class_1937 world, BasinBlockEntity blockEntity, class_5819 r) {
        class_2680 blockState = blockEntity.method_11010();
        if (!(blockState.method_26204() instanceof BasinBlock)) {
            return;
        }
        class_2350 direction = (class_2350)blockState.method_11654(BasinBlock.FACING);
        if (direction == class_2350.field_11033) {
            return;
        }
        class_243 directionVec = class_243.method_24954((class_2382)direction.method_62675());
        class_243 outVec = VecHelper.getCenterOf((class_2382)blockEntity.method_11016()).method_1019(directionVec.method_1021(0.65).method_1023(0.0, 0.25, 0.0));
        class_243 outMotion = directionVec.method_1021(0.0625).method_1031(0.0, -0.0625, 0.0);
        for (int i = 0; i < 2; ++i) {
            blockEntity.visualizedOutputFluids.forEach(ia -> {
                FluidStack fluidStack = (FluidStack)ia.getValue();
                class_2394 fluidParticle = FluidFX.getFluidParticle(fluidStack);
                class_243 m = VecHelper.offsetRandomly(outMotion, r, 0.0625f);
                world.method_8494(fluidParticle, outVec.field_1352, outVec.field_1351, outVec.field_1350, m.field_1352, m.field_1351, m.field_1350);
            });
        }
    }

    private static void createBasinMovingFluidParticles(class_1937 world, BasinBlockEntity blockEntity, float surface, int segments) {
        class_243 pointer = new class_243(1.0, 0.0, 0.0).method_1021(0.0625);
        float interval = 360.0f / (float)segments;
        class_243 centerOf = VecHelper.getCenterOf((class_2382)blockEntity.method_11016());
        float intervalOffset = AnimationTickHolder.getTicks() * 18 % 360;
        int currentSegment = 0;
        for (SmartFluidTankBehaviour behaviour : blockEntity.getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                float angle = interval * (float)(1 + currentSegment) + intervalOffset;
                class_243 vec = centerOf.method_1019(VecHelper.rotate(pointer, angle, class_2350.class_2351.field_11052));
                FluidStack stack = tankSegment.getRenderedFluid();
                world.method_8494((class_2394)new FluidParticleData(AllParticleTypes.BASIN_FLUID, stack.getFluid(), stack.getComponentChanges()), vec.method_10216(), (double)surface, vec.method_10215(), 1.0, 0.0, 0.0);
                ++currentSegment;
            }
        }
    }

    @Override
    public void cartClicked(class_1657 player, class_1688 minecart) {
        CouplingHandlerClient.onCartClicked((class_746)player, minecart);
    }

    @Override
    public void advertiseToAddressHelper(ClipboardBlockEntity blockEntity) {
        AddressEditBoxHelper.advertiseClipboard(blockEntity);
    }

    @Override
    public void updateClipboardScreen(UUID lastEdit, class_2338 pos, ClipboardContent content) {
        class_310 mc = class_310.method_1551();
        class_437 class_4372 = mc.field_1755;
        if (!(class_4372 instanceof ClipboardScreen)) {
            return;
        }
        ClipboardScreen cs = (ClipboardScreen)class_4372;
        if (lastEdit != null && mc.field_1724.method_5667().equals(lastEdit)) {
            return;
        }
        if (!pos.equals((Object)cs.targetedBlock)) {
            return;
        }
        cs.reopenWith(content);
    }

    @Override
    public GlobalRailwayManager getGlobalRailwayManager() {
        return Create.RAILWAYS;
    }

    @Override
    public void registerToCurveInteraction(TrackBlockEntity be) {
        TrackBlockOutline.registerToCurveInteraction(be);
    }

    @Override
    public void removeFromCurveInteraction(TrackBlockEntity be) {
        TrackBlockOutline.removeFromCurveInteraction(be);
    }

    @Override
    public void invalidateCarriage(CarriageContraptionEntity entity) {
        entity.updateRenderedPortalCutoff();
        AtomicReference<?> clientContraption = entity.getContraption().clientContraption;
        ClientContraption maybeNullClientContraption = (ClientContraption)clientContraption.getAcquire();
        if (maybeNullClientContraption != null) {
            maybeNullClientContraption.invalidateStructure();
            maybeNullClientContraption.invalidateChildren();
        }
    }

    @Override
    public void startControlling(class_1657 player, AbstractContraptionEntity be, class_2338 pos) {
        ControlsHandler.startControlling((class_746)player, be, pos);
    }

    @Override
    public void tickBlazeBurnerMovement(MovementContext context) {
        BlazeBurnerMovementRenderBehaviour render = (BlazeBurnerMovementRenderBehaviour)AllMovementBehaviours.BLAZE_BURNER.getAttachRender();
        render.tick(context);
    }

    @Override
    public void cannonDontAnimateItem(class_1268 hand) {
        Create.POTATO_CANNON_RENDER_HANDLER.dontAnimateItem(hand);
    }

    @Override
    public void tryToggleActive(LecternControllerBlockEntity controller) {
        class_746 player = class_310.method_1551().field_1724;
        UUID uuid = player.method_5667();
        if (controller.user == null && uuid.equals(controller.prevUser)) {
            LinkedControllerClientHandler.deactivateInLectern(player);
        } else if (controller.prevUser == null && uuid.equals(controller.user)) {
            LinkedControllerClientHandler.activateInLectern(controller.method_11016());
        }
    }

    @Override
    public void toggleLinkedControllerBindMode(class_2338 pos) {
        LinkedControllerClientHandler.toggleBindMode(class_310.method_1551().field_1724, pos);
    }

    @Override
    public void toggleLinkedControllerActive() {
        LinkedControllerClientHandler.toggle(class_310.method_1551().field_1724);
    }

    @Override
    public void factoryPanelMoveToSlot(SmartBlockEntity be, PanelSlot slot) {
        FactoryPanelBehaviour behaviour = (FactoryPanelBehaviour)be.getBehaviour(FilteringBehaviour.TYPE);
        ValueBoxTransform valueBoxTransform = behaviour.getSlotPositioning();
        if (valueBoxTransform instanceof FactoryPanelSlotPositioning) {
            FactoryPanelSlotPositioning fpsp = (FactoryPanelSlotPositioning)valueBoxTransform;
            fpsp.slot = slot;
        }
    }

    @Override
    public boolean factoryPanelClicked(class_1937 world, class_1657 player, ServerFactoryPanelBehaviour behaviour) {
        return FactoryPanelConnectionHandler.panelClicked((class_1936)world, player, behaviour);
    }

    @Override
    public void zapperDontAnimateItem(class_1268 hand) {
        Create.ZAPPER_RENDER_HANDLER.dontAnimateItem(hand);
    }

    @Override
    public void openSequencedGearshiftScreen(SequencedGearshiftBlockEntity be) {
        ScreenOpener.open(new SequencedGearshiftScreen(be));
    }

    @Override
    public void openClipboardScreen(class_1657 player, class_9323 components, class_2338 pos) {
        if (class_310.method_1551().field_1724 == player) {
            ScreenOpener.open(new ClipboardScreen(player.method_31548().method_67532(), components, pos));
        }
    }

    @Override
    public void openDisplayLinkScreen(DisplayLinkBlockEntity be, class_1657 player) {
        if (!(player instanceof class_746)) {
            return;
        }
        if (be.targetOffset.equals((Object)class_2338.field_11176)) {
            player.method_7353((class_2561)CreateLang.translateDirect("display_link.invalid", new Object[0]), true);
            return;
        }
        ScreenOpener.open(new DisplayLinkScreen(be));
    }

    @Override
    public void openThresholdSwitchScreen(ThresholdSwitchBlockEntity be, class_1657 player) {
        if (player instanceof class_746) {
            ScreenOpener.open(new ThresholdSwitchScreen(be));
        }
    }

    @Override
    public void openElevatorContactScreen(ElevatorContactBlockEntity be, class_1657 player) {
        if (player instanceof class_746) {
            ScreenOpener.open(new ElevatorContactScreen(be.method_11016(), be.shortName, be.longName, be.doorControls.mode));
        }
    }

    @Override
    public void openStationScreen(class_1937 world, class_2338 pos, class_1657 player) {
        if (!(player instanceof class_746)) {
            return;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof StationBlockEntity) {
            StationBlockEntity be = (StationBlockEntity)class_25862;
            GlobalStation station = be.getStation();
            class_2680 blockState = be.method_11010();
            if (station == null || blockState == null) {
                return;
            }
            boolean assembling = blockState.method_26204() == AllBlocks.TRACK_STATION && (Boolean)blockState.method_11654((class_2769)StationBlock.ASSEMBLING) != false;
            ScreenOpener.open(assembling ? new AssemblyScreen(be, station) : new StationScreen(be, station));
        }
    }

    @Override
    public void openFactoryPanelScreen(ServerFactoryPanelBehaviour behaviour, class_1657 player) {
        if (player instanceof class_746) {
            ScreenOpener.open(new FactoryPanelScreen(behaviour));
        }
    }

    @Override
    public void openSymmetryWandScreen(class_1799 stack, class_1268 hand) {
        ScreenOpener.open(new SymmetryWandScreen(stack, hand));
    }

    @Override
    public void openSchematicEditScreen() {
        ScreenOpener.open(new SchematicEditScreen());
    }

    @Override
    public void openWorldshaperScreen(class_1799 item, class_1268 hand) {
        ScreenOpener.open(new WorldshaperScreen(item, hand));
    }
}

