/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client;

import com.zurrtum.create.AllSchedules;
import com.zurrtum.create.client.content.trains.schedule.IScheduleInput;
import com.zurrtum.create.client.content.trains.schedule.condition.FluidThresholdConditionRender;
import com.zurrtum.create.client.content.trains.schedule.condition.IdleCargoConditionRender;
import com.zurrtum.create.client.content.trains.schedule.condition.ItemThresholdConditionRender;
import com.zurrtum.create.client.content.trains.schedule.condition.PlayerPassengerConditionRender;
import com.zurrtum.create.client.content.trains.schedule.condition.RedstoneLinkConditionRender;
import com.zurrtum.create.client.content.trains.schedule.condition.ScheduledDelayRender;
import com.zurrtum.create.client.content.trains.schedule.condition.StationPoweredConditionRender;
import com.zurrtum.create.client.content.trains.schedule.condition.StationUnloadedConditionRender;
import com.zurrtum.create.client.content.trains.schedule.condition.TimeOfDayConditionRender;
import com.zurrtum.create.client.content.trains.schedule.destination.ChangeThrottleInstructionRender;
import com.zurrtum.create.client.content.trains.schedule.destination.ChangeTitleInstructionRender;
import com.zurrtum.create.client.content.trains.schedule.destination.DeliverPackagesInstructionRender;
import com.zurrtum.create.client.content.trains.schedule.destination.DestinationInstructionRender;
import com.zurrtum.create.client.content.trains.schedule.destination.FetchPackagesInstructionRender;
import com.zurrtum.create.content.trains.schedule.ScheduleDataEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class AllScheduleRenders {
    public static final Map<class_2960, IScheduleInput<?>> ALL = new HashMap();

    public static <T extends ScheduleDataEntry> IScheduleInput<T> get(T entry) {
        return ALL.get(entry.getId());
    }

    private static void register(class_2960 schedule, Supplier<IScheduleInput<?>> render) {
        ALL.put(schedule, render.get());
    }

    public static void register() {
        AllScheduleRenders.register(AllSchedules.DESTINATION, DestinationInstructionRender::new);
        AllScheduleRenders.register(AllSchedules.PACKAGE_DELIVERY, DeliverPackagesInstructionRender::new);
        AllScheduleRenders.register(AllSchedules.PACKAGE_RETRIEVAL, FetchPackagesInstructionRender::new);
        AllScheduleRenders.register(AllSchedules.RENAME, ChangeTitleInstructionRender::new);
        AllScheduleRenders.register(AllSchedules.THROTTLE, ChangeThrottleInstructionRender::new);
        AllScheduleRenders.register(AllSchedules.DELAY, ScheduledDelayRender::new);
        AllScheduleRenders.register(AllSchedules.TIME_OF_DAY, TimeOfDayConditionRender::new);
        AllScheduleRenders.register(AllSchedules.FLUID_THRESHOLD, FluidThresholdConditionRender::new);
        AllScheduleRenders.register(AllSchedules.ITEM_THRESHOLD, ItemThresholdConditionRender::new);
        AllScheduleRenders.register(AllSchedules.REDSTONE_LINK, RedstoneLinkConditionRender::new);
        AllScheduleRenders.register(AllSchedules.PLAYER_COUNT, PlayerPassengerConditionRender::new);
        AllScheduleRenders.register(AllSchedules.IDLE, IdleCargoConditionRender::new);
        AllScheduleRenders.register(AllSchedules.UNLOADED, StationUnloadedConditionRender::new);
        AllScheduleRenders.register(AllSchedules.POWERED, StationPoweredConditionRender::new);
    }
}

