/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.ghostblock;

import com.zurrtum.create.client.catnip.client.render.model.BakedModelBufferer;
import com.zurrtum.create.client.catnip.ghostblock.GhostBlockParams;
import com.zurrtum.create.client.catnip.impl.client.render.ColoringVertexConsumer;
import com.zurrtum.create.client.catnip.placement.PlacementClient;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.EmptyVirtualBlockGetter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public abstract class GhostBlockRenderer {
    private static final GhostBlockRenderer STANDARD = new DefaultGhostBlockRenderer();
    private static final GhostBlockRenderer TRANSPARENT = new TransparentGhostBlockRenderer();

    public static GhostBlockRenderer standard() {
        return STANDARD;
    }

    public static GhostBlockRenderer transparent() {
        return TRANSPARENT;
    }

    public abstract void render(class_310 var1, class_4587 var2, SuperRenderTypeBuffer var3, class_243 var4, GhostBlockParams var5);

    @Environment(value=EnvType.CLIENT)
    private static class DefaultGhostBlockRenderer
    extends GhostBlockRenderer {
        private DefaultGhostBlockRenderer() {
        }

        @Override
        public void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, GhostBlockParams params) {
            class_2680 state = params.state;
            class_1087 model = mc.method_1541().method_3349(state);
            class_2338 pos = params.pos;
            ms.method_22904((double)pos.method_10263() - camera.field_1352, (double)pos.method_10264() - camera.field_1351, (double)pos.method_10260() - camera.field_1350);
            ms.method_22903();
            BakedModelBufferer.bufferModel(model, pos, (class_1920)EmptyVirtualBlockGetter.FULL_BRIGHT, state, ms, (layer, shade) -> buffer.getEarlyBuffer(layer));
            ms.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class TransparentGhostBlockRenderer
    extends GhostBlockRenderer {
        private TransparentGhostBlockRenderer() {
        }

        @Override
        public void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, GhostBlockParams params) {
            class_2680 state = params.state;
            class_1087 model = mc.method_1541().method_3349(state);
            class_2338 pos = params.pos;
            float alpha = params.alphaSupplier.get().floatValue() * 0.75f * PlacementClient.getCurrentAlpha();
            ColoringVertexConsumer vb = new ColoringVertexConsumer(buffer.getEarlyBuffer(class_11515.field_60926), 1.0f, 1.0f, 1.0f, alpha);
            ms.method_22903();
            ms.method_22904((double)pos.method_10263() - camera.field_1352, (double)pos.method_10264() - camera.field_1351, (double)pos.method_10260() - camera.field_1350);
            ms.method_22904(0.5, 0.5, 0.5);
            ms.method_22905(0.85f, 0.85f, 0.85f);
            ms.method_22904(-0.5, -0.5, -0.5);
            BakedModelBufferer.bufferModel(model, pos, (class_1920)EmptyVirtualBlockGetter.FULL_BRIGHT, state, ms, (layer, shade) -> vb);
            ms.method_22909();
        }
    }
}

