/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.computercraft;

import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.compat.Mods;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ComputerScreen
extends AbstractSimiScreen {
    private final AllGuiTextures background = AllGuiTextures.COMPUTER;
    private final Supplier<class_2561> displayTitle;
    private final AdditionalRenderer additionalRenderer;
    private final class_437 previousScreen;
    private final Supplier<Boolean> hasAttachedComputer;
    private ElementWidget computerWidget;
    private IconButton confirmButton;

    public ComputerScreen(class_2561 title, @Nullable AdditionalRenderer additionalRenderer, class_437 previousScreen, Supplier<Boolean> hasAttachedComputer) {
        this(title, () -> title, additionalRenderer, previousScreen, hasAttachedComputer);
    }

    public ComputerScreen(class_2561 title, Supplier<class_2561> displayTitle, @Nullable AdditionalRenderer additionalRenderer, class_437 previousScreen, Supplier<Boolean> hasAttachedComputer) {
        super(title);
        this.displayTitle = displayTitle;
        this.additionalRenderer = additionalRenderer;
        this.previousScreen = previousScreen;
        this.hasAttachedComputer = hasAttachedComputer;
    }

    @Override
    public void method_25393() {
        if (!this.hasAttachedComputer.get().booleanValue()) {
            this.field_22787.method_1507(this.previousScreen);
        }
        super.method_25393();
    }

    @Override
    protected void method_25426() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        super.method_25426();
        int x = this.guiLeft;
        int y = this.guiTop;
        if (Mods.COMPUTERCRAFT.isLoaded()) {
            this.computerWidget = new ElementWidget(x + 33, y + 38).showingElement(GuiGameElement.of(Mods.COMPUTERCRAFT.getItem("computer_advanced")));
            this.computerWidget.getToolTip().add((class_2561)CreateLang.translate("gui.attached_computer.hint", new Object[0]).component());
            this.method_37063(this.computerWidget);
        }
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::method_25419);
        this.method_37063(this.confirmButton);
        if (this.additionalRenderer != null) {
            this.additionalRenderer.addAdditional(this, x, y, this.background);
        }
    }

    public void method_25419() {
        super.method_25419();
        this.previousScreen.method_25419();
        if (this.computerWidget != null) {
            this.computerWidget.getRenderElement().clear();
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        graphics.method_51439(this.field_22793, this.displayTitle.get(), Math.round((float)x + (float)this.background.getWidth() / 2.0f - (float)this.field_22793.method_27525((class_5348)this.displayTitle.get()) / 2.0f), y + 4, -12312576, false);
        graphics.method_51440(this.field_22793, (class_5348)CreateLang.translate("gui.attached_computer.controlled", new Object[0]).component(), x + 55, y + 32, 111, -8750470, false);
        if (this.additionalRenderer != null) {
            this.additionalRenderer.updateAdditional(partialTicks);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface AdditionalRenderer {
        public void addAdditional(class_437 var1, int var2, int var3, AllGuiTextures var4);

        default public void updateAdditional(float partialTicks) {
        }
    }
}

