/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv.view;

import com.zurrtum.create.client.compat.eiv.CreateView;
import com.zurrtum.create.client.compat.eiv.EivClientPlugin;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.PressBasinRenderState;
import com.zurrtum.create.compat.eiv.display.CompactingDisplay;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class CompactingView
extends CreateView {
    private final SlotContent result;
    private final List<SlotContent> ingredients;

    public CompactingView(CompactingDisplay display) {
        this.result = SlotContent.of((class_1799)display.result);
        boolean hasFluid = display.fluidIngredient != null;
        int size = display.ingredients.size();
        if (hasFluid) {
            ++size;
        }
        this.ingredients = new ArrayList<SlotContent>(size);
        for (List<class_1799> ingredient : display.ingredients) {
            this.ingredients.add(SlotContent.of(ingredient));
        }
        if (hasFluid) {
            this.ingredients.add(SlotContent.of(CompactingView.getItemStacks(display.fluidIngredient)));
        }
    }

    public IEivRecipeViewType getViewType() {
        return EivClientPlugin.PACKING;
    }

    public List<SlotContent> getIngredients() {
        return this.ingredients;
    }

    public List<SlotContent> getResults() {
        return List.of(this.result);
    }

    @Override
    public int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        int i;
        int xOffset;
        int size = this.ingredients.size();
        int n = xOffset = size < 3 ? 12 + (3 - size) * 19 / 2 : 12;
        for (i = 0; i < size; ++i) {
            slotDefinition.addItemSlot(i, xOffset + i % 3 * 19, 49 - i / 3 * 19);
        }
        slotDefinition.addItemSlot(i++, 142, 49);
        return i;
    }

    @Override
    public int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        int i;
        int size = this.ingredients.size();
        for (i = 0; i < size; ++i) {
            slotFillContext.bindOptionalSlot(i, this.ingredients.get(i), SLOT);
        }
        slotFillContext.bindOptionalSlot(i++, this.result, SLOT);
        return i;
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition position, class_332 context, int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.JEI_DOWN_ARROW.render(context, 136, 30);
        AllGuiTextures.JEI_SHADOW.render(context, 81, 66);
        context.field_59826.method_70922((class_11256)new PressBasinRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), 91, -7));
    }
}

