/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv.view;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.compat.eiv.CreateView;
import com.zurrtum.create.client.compat.eiv.EivClientPlugin;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.BasinBlazeBurnerRenderState;
import com.zurrtum.create.client.foundation.gui.render.MixingBasinRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.compat.eiv.display.MixingDisplay;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class MixingView
extends CreateView {
    private final SlotContent result;
    private final List<SlotContent> ingredients;
    private final HeatCondition heat;
    private final SlotContent burner;
    private final SlotContent cake;

    public MixingView(MixingDisplay display) {
        this.result = SlotContent.of((class_1799)(display.result.method_7960() ? MixingView.getItemStack(display.fluidResult) : display.result));
        this.ingredients = new ArrayList<SlotContent>(display.ingredients.size() + display.fluidIngredients.size());
        for (List<class_1799> list : display.ingredients) {
            this.ingredients.add(SlotContent.of(list));
        }
        for (FluidIngredient fluidIngredient : display.fluidIngredients) {
            this.ingredients.add(SlotContent.of(MixingView.getItemStacks(fluidIngredient)));
        }
        this.heat = display.heat;
        this.burner = this.heat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE) ? null : SlotContent.of((class_1792)AllItems.BLAZE_BURNER);
        this.cake = this.heat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED) ? null : SlotContent.of((class_1792)AllItems.BLAZE_CAKE);
    }

    public IEivRecipeViewType getViewType() {
        return EivClientPlugin.MIXING;
    }

    public List<SlotContent> getIngredients() {
        return this.ingredients;
    }

    public List<SlotContent> getResults() {
        return List.of(this.result);
    }

    @Override
    protected int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        int i;
        int xOffset;
        int size = this.ingredients.size();
        int n = xOffset = size < 3 ? 12 + (3 - size) * 19 / 2 : 12;
        for (i = 0; i < size; ++i) {
            slotDefinition.addItemSlot(i, xOffset + i % 3 * 19, 51 - i / 3 * 19);
        }
        slotDefinition.addItemSlot(i++, 142, 51);
        if (this.burner != null) {
            slotDefinition.addItemSlot(i++, 134, 81);
        }
        if (this.cake != null) {
            slotDefinition.addItemSlot(i++, 153, 81);
        }
        return i;
    }

    @Override
    protected int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        int i;
        int size = this.ingredients.size();
        for (i = 0; i < size; ++i) {
            slotFillContext.bindOptionalSlot(i, this.ingredients.get(i), SLOT);
        }
        slotFillContext.bindOptionalSlot(i++, this.result, SLOT);
        if (this.burner != null) {
            slotFillContext.bindSlot(i++, this.burner);
        }
        if (this.cake != null) {
            slotFillContext.bindSlot(i++, this.cake);
        }
        return i;
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition position, class_332 context, int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.JEI_DOWN_ARROW.render(context, 136, 32);
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)context.method_51448());
        if (this.heat == HeatCondition.NONE) {
            AllGuiTextures.JEI_NO_HEAT_BAR.render(context, 0, 80);
            AllGuiTextures.JEI_SHADOW.render(context, 77, 68);
        } else {
            AllGuiTextures.JEI_HEAT_BAR.render(context, 0, 80);
            AllGuiTextures.JEI_LIGHT.render(context, 77, 88);
            context.field_59826.method_70922((class_11256)new BasinBlazeBurnerRenderState(pose, 87, 69, this.heat.visualizeAsBlazeBurner()));
        }
        context.field_59826.method_70922((class_11256)new MixingBasinRenderState(pose, 87, -5));
        context.method_51439(class_310.method_1551().field_1772, (class_2561)CreateLang.translateDirect(this.heat.getTranslationKey(), new Object[0]), 5, 86, this.heat.getColor(), false);
    }
}

