/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.decoration.slidingDoor;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControl;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlockEntity;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7923;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SlidingDoorRenderer
implements class_827<SlidingDoorBlockEntity, DoorRenderState> {
    public SlidingDoorRenderer(class_5614.class_5615 context) {
    }

    public DoorRenderState createRenderState() {
        return new DoorRenderState();
    }

    public void updateRenderState(SlidingDoorBlockEntity be, DoorRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        state.field_62674 = be.method_11010();
        if (!be.shouldRenderSpecial(state.field_62674)) {
            return;
        }
        state.field_62673 = be.method_11016();
        state.field_62675 = be.method_11017();
        class_1937 world = be.method_10997();
        state.field_62676 = world != null ? class_761.method_23794((class_1920)world, (class_2338)state.field_62673) : 0xF000F0;
        state.layer = class_1921.method_23579();
        class_2350 facing = (class_2350)state.field_62674.method_11654((class_2769)class_2323.field_10938);
        class_2350 movementDirection = facing.method_10170();
        boolean isLeft = state.field_62674.method_11654((class_2769)class_2323.field_10941) == class_2750.field_12588;
        float value = be.animation.getValue(tickProgress);
        class_243 offset = class_243.method_24954((class_2382)facing.method_62675()).method_1021((double)(class_3532.method_15363((float)(value * 10.0f), (float)0.0f, (float)1.0f) * 1.0f / 32.0f));
        SlidingDoorBlock block = (SlidingDoorBlock)state.field_62674.method_26204();
        if (block.isFoldingDoor()) {
            FoldingDoorRenderState renderState = new FoldingDoorRenderState();
            renderState.offsetY = -0.001953125f;
            renderState.offset = offset;
            renderState.angle = (float)Math.PI / 180 * AngleHelper.horizontalAngle(movementDirection);
            float f = isLeft ? 1.0f : -1.0f;
            float v = f * value * value;
            renderState.yRot = 1.5882496f * v;
            renderState.flip = !isLeft;
            Couple<PartialModel> partials = AllPartialModels.FOLDING_DOORS.get(class_7923.field_41175.method_10221((Object)block));
            renderState.left = CachedBuffers.partial(partials.get(isLeft), state.field_62674);
            renderState.right = CachedBuffers.partial(partials.get(renderState.flip), state.field_62674);
            renderState.rightOffset = f / 2.0f;
            renderState.rightYRot = -3.159046f * v;
            renderState.light = state.field_62676;
            state.renderer = renderState;
        } else {
            if (isLeft) {
                movementDirection = movementDirection.method_10153();
            }
            SlidingDoorRenderState renderState = new SlidingDoorRenderState();
            class_2680 blockState = (class_2680)state.field_62674.method_11657((class_2769)class_2323.field_10945, (Comparable)Boolean.valueOf(false));
            renderState.upper = CachedBuffers.block((class_2680)blockState.method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609));
            renderState.lower = CachedBuffers.block((class_2680)blockState.method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12607));
            renderState.upperOffset = 0.9980469f;
            renderState.offset = class_243.method_24954((class_2382)movementDirection.method_62675()).method_1021((double)(value * value * 13.0f / 16.0f)).method_1019(offset);
            renderState.light = state.field_62676;
            state.renderer = renderState;
        }
    }

    public void render(DoorRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.renderer != null) {
            queue.method_73483(matrices, state.layer, state.renderer);
        }
    }

    public static Pair<ScrollInput, Label> createWidget(class_310 mc, int x, int y, Consumer<DoorControl> callback, DoorControl initial) {
        DoorControl doorControl;
        class_1297 entity = mc.method_1560();
        if (entity != null) {
            switch (entity.method_5735()) {
                case field_11034: {
                    doorControl = DoorControl.EAST;
                    break;
                }
                case field_11039: {
                    doorControl = DoorControl.WEST;
                    break;
                }
                case field_11043: {
                    doorControl = DoorControl.NORTH;
                    break;
                }
                case field_11035: {
                    doorControl = DoorControl.SOUTH;
                    break;
                }
                default: {
                    doorControl = DoorControl.NONE;
                    break;
                }
            }
        } else {
            doorControl = DoorControl.NONE;
        }
        DoorControl playerFacing = doorControl;
        Label label = new Label(x + 4, y + 6, (class_2561)class_2561.method_43473()).withShadow();
        ScrollInput input = new SelectionScrollInput(x, y, 53, 16).forOptions(CreateLang.translatedOptions("contraption.door_control", SlidingDoorRenderer.valuesAsString())).titled(CreateLang.translateDirect("contraption.door_control", new Object[0])).calling(s -> {
            DoorControl mode = DoorControl.values()[s];
            label.text = CreateLang.translateDirect("contraption.door_control." + Lang.asId(mode.name()) + ".short", new Object[0]);
            callback.accept(mode);
        }).addHint(CreateLang.translateDirect("contraption.door_control.player_facing", CreateLang.translateDirect("contraption.door_control." + Lang.asId(playerFacing.name()) + ".short", new Object[0]))).setState(initial.ordinal());
        input.onChanged();
        return Pair.of(input, label);
    }

    public static String[] valuesAsString() {
        DoorControl[] values = DoorControl.values();
        return Arrays.stream(values).map(dc -> dc.name().toLowerCase(Locale.ROOT)).toList().toArray(new String[values.length]);
    }

    @Environment(value=EnvType.CLIENT)
    public static class DoorRenderState
    extends class_11954 {
        public class_11659.class_11660 renderer;
        public class_1921 layer;
    }

    @Environment(value=EnvType.CLIENT)
    public static class FoldingDoorRenderState
    implements class_11659.class_11660 {
        public float offsetY;
        public class_243 offset;
        public float angle;
        public float yRot;
        public boolean flip;
        public SuperByteBuffer left;
        public SuperByteBuffer right;
        public float rightOffset;
        public float rightYRot;
        public int light;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)this.left.translate(0.0f, this.offsetY, 0.0f)).translate(this.offset)).rotateCentered(this.angle, class_2350.field_11036);
            if (this.flip) {
                this.left.translate(0.0f, 0.0f, 1.0f);
            }
            this.left.rotateY(this.yRot);
            if (this.flip) {
                this.left.translate(0.0f, 0.0f, -0.5f);
            }
            this.left.light(this.light).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)this.right.translate(0.0f, this.offsetY, 0.0f)).translate(this.offset)).rotateCentered(this.angle, class_2350.field_11036);
            if (this.flip) {
                this.right.translate(0.0f, 0.0f, 1.0f);
            }
            ((SuperByteBuffer)((SuperByteBuffer)this.right.rotateY(this.yRot)).translate(0.0f, 0.0f, this.rightOffset)).rotateY(this.rightYRot);
            if (this.flip) {
                this.right.translate(0.0f, 0.0f, -0.5f);
            }
            this.right.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class SlidingDoorRenderState
    implements class_11659.class_11660 {
        public SuperByteBuffer upper;
        public SuperByteBuffer lower;
        public float upperOffset;
        public class_243 offset;
        public int light;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)this.upper.translate(0.0f, this.upperOffset, 0.0f)).translate(this.offset)).light(this.light).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)this.lower.translate(this.offset)).light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

