/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.base;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.kinetics.KineticDebugger;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class KineticBlockEntityRenderer<T extends KineticBlockEntity, S extends KineticRenderState>
implements class_827<T, S> {
    public static final SuperByteBufferCache.Compartment<class_2680> KINETIC_BLOCK = new SuperByteBufferCache.Compartment();
    public static boolean rainbowMode = false;

    public KineticBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public S createRenderState() {
        return (S)((Object)new KineticRenderState());
    }

    public void updateRenderState(T be, S state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_1937 world = be.method_10997();
        ((KineticRenderState)((Object)state)).support = VisualizationManager.supportsVisualization((class_1936)world);
        if (((KineticRenderState)((Object)state)).support) {
            return;
        }
        this.updateBaseRenderState(be, state, world, crumblingOverlay);
        ((KineticRenderState)((Object)state)).model = this.getRotatedModel(be, state);
        ((KineticRenderState)((Object)state)).angle = KineticBlockEntityRenderer.getAngleForBe(be, ((KineticRenderState)((Object)state)).field_62673, ((KineticRenderState)((Object)state)).axis);
    }

    public void updateBaseRenderState(T be, S state, class_1937 world, @Nullable class_11683.class_11792 crumblingOverlay) {
        ((KineticRenderState)((Object)state)).field_62673 = be.method_11016();
        ((KineticRenderState)((Object)state)).field_62674 = this.getRenderedBlockState(be);
        ((KineticRenderState)((Object)state)).field_62675 = be.method_11017();
        ((KineticRenderState)((Object)state)).field_62676 = world != null ? class_761.method_23794((class_1920)world, (class_2338)((KineticRenderState)((Object)state)).field_62673) : 0xF000F0;
        ((KineticRenderState)((Object)state)).field_62677 = crumblingOverlay;
        ((KineticRenderState)((Object)state)).layer = this.getRenderType(be, ((KineticRenderState)((Object)state)).field_62674);
        ((KineticRenderState)((Object)state)).axis = ((IRotate)((KineticRenderState)((Object)state)).field_62674.method_26204()).getRotationAxis(((KineticRenderState)((Object)state)).field_62674);
        ((KineticRenderState)((Object)state)).direction = class_2350.method_10169((class_2350.class_2351)((KineticRenderState)((Object)state)).axis, (class_2350.class_2352)class_2350.class_2352.field_11056);
        ((KineticRenderState)((Object)state)).color = KineticBlockEntityRenderer.getColor(be);
    }

    public void render(S state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (((KineticRenderState)((Object)state)).support) {
            return;
        }
        queue.method_73483(matrices, ((KineticRenderState)((Object)state)).layer, state);
    }

    protected class_2680 getRenderedBlockState(T be) {
        return be.method_11010();
    }

    protected class_1921 getRenderType(T be, class_2680 state) {
        return class_4696.method_29359((class_2680)state);
    }

    protected SuperByteBuffer getRotatedModel(T be, S state) {
        return CachedBuffers.block(KINETIC_BLOCK, ((KineticRenderState)((Object)state)).field_62674);
    }

    public static float getAngleForBe(KineticBlockEntity be, class_2338 pos, class_2350.class_2351 axis) {
        float time = AnimationTickHolder.getRenderTime((class_1936)be.method_10997());
        float offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, axis);
        return (time * be.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
    }

    public static Color getColor(KineticBlockEntity be) {
        if (KineticDebugger.isActive()) {
            rainbowMode = true;
            return be.network != null ? Color.generateFromLong(be.network) : Color.WHITE;
        }
        float overStressedEffect = be.effects.overStressedEffect;
        if (overStressedEffect != 0.0f) {
            boolean overstressed = overStressedEffect > 0.0f;
            Color color = overstressed ? Color.RED : Color.SPRING_GREEN;
            float weight = overstressed ? overStressedEffect : -overStressedEffect;
            return Color.WHITE.mixWith(color, weight);
        }
        return Color.WHITE;
    }

    public static float getRotationOffsetForPosition(KineticBlockEntity be, class_2338 pos, class_2350.class_2351 axis) {
        return KineticBlockEntityVisual.rotationOffset(be.method_11010(), axis, (class_2382)pos) + (float)be.getRotationAngleOffset(axis);
    }

    public static class_2680 shaft(class_2350.class_2351 axis) {
        return (class_2680)AllBlocks.SHAFT.method_9564().method_11657((class_2769)class_2741.field_12496, (Comparable)axis);
    }

    public static class_2350.class_2351 getRotationAxisOf(KineticBlockEntity be) {
        return ((IRotate)be.method_11010().method_26204()).getRotationAxis(be.method_11010());
    }

    @Environment(value=EnvType.CLIENT)
    public static class KineticRenderState
    extends class_11954
    implements class_11659.class_11660 {
        public boolean support;
        public class_1921 layer;
        public SuperByteBuffer model;
        public float angle;
        public class_2350.class_2351 axis;
        public class_2350 direction;
        public Color color;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.model.light(this.field_62676);
            this.model.rotateCentered(this.angle, this.direction);
            this.model.color(this.color);
            this.model.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

