/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.mechanicalArm;

import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlock;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class ArmRenderer
extends KineticBlockEntityRenderer<ArmBlockEntity, ArmRenderState> {
    protected static class_10442 itemModelManager;

    public ArmRenderer(class_5614.class_5615 context) {
        super(context);
        itemModelManager = context.comp_4536();
    }

    @Override
    public ArmRenderState createRenderState() {
        return new ArmRenderState();
    }

    @Override
    public void updateRenderState(ArmBlockEntity be, ArmRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        boolean rave;
        boolean isBlockItem;
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        class_1799 item = be.heldItem;
        boolean empty = item.method_7960();
        if (state.support) {
            if (empty) {
                return;
            }
            class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        }
        class_1937 world = be.method_10997();
        if (empty) {
            isBlockItem = false;
        } else {
            ArmItemData data = state.item = new ArmItemData();
            class_10444 renderState = new class_10444();
            renderState.field_55337 = class_811.field_4319;
            itemModelManager.method_65596(renderState, item, renderState.field_55337, world, null, 0);
            isBlockItem = item.method_7909() instanceof class_1747 && renderState.method_65608();
            data.state = renderState;
            data.xRot = 1.5707964f;
            if (isBlockItem) {
                data.offset = -0.5625f;
                data.scale = 0.5f;
            } else {
                data.offset = -0.625f;
                data.scale = 0.625f;
            }
        }
        boolean inverted = (Boolean)state.field_62674.method_11654((class_2769)ArmBlock.CEILING);
        if (inverted) {
            state.rotate = (float)Math.PI;
        }
        boolean bl = rave = be.phase == ArmBlockEntity.Phase.DANCING && be.getSpeed() != 0.0f;
        if (rave) {
            float renderTick = AnimationTickHolder.getRenderTime((class_1936)world) + (float)(be.hashCode() % 64);
            state.baseAngle = (float)Math.PI / 180 * (renderTick * 10.0f % 360.0f);
            state.lowerArmAngle = (float)Math.PI / 180 * (float)(class_3532.method_48781((float)((class_3532.method_15374((float)(renderTick / 4.0f)) + 1.0f) / 2.0f), (int)-45, (int)15) - 135);
            state.upperArmAngle = (float)Math.PI / 180 * (float)(class_3532.method_48781((float)((class_3532.method_15374((float)(renderTick / 8.0f)) + 1.0f) / 4.0f), (int)-45, (int)95) - 90);
            state.headAngle = (float)Math.PI / 180 * (-state.lowerArmAngle - 45.0f);
        } else {
            state.baseAngle = (float)Math.PI / 180 * be.baseAngle.getValue(tickProgress);
            state.lowerArmAngle = (float)Math.PI / 180 * be.lowerArmAngle.getValue(tickProgress);
            state.upperArmAngle = (float)Math.PI / 180 * (be.upperArmAngle.getValue(tickProgress) - 180.0f);
            state.headAngle = (float)Math.PI / 180 * (be.headAngle.getValue(tickProgress) - 45.0f);
        }
        if (!state.support) {
            ArmRenderData data = state.arm = new ArmRenderData();
            boolean goggles = be.goggles;
            data.base = CachedBuffers.partial(AllPartialModels.ARM_BASE, state.field_62674);
            data.lower = CachedBuffers.partial(AllPartialModels.ARM_LOWER_BODY, state.field_62674);
            data.upper = CachedBuffers.partial(AllPartialModels.ARM_UPPER_BODY, state.field_62674);
            data.claw = CachedBuffers.partial(goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE, state.field_62674);
            data.clawUpper = CachedBuffers.partial(AllPartialModels.ARM_CLAW_GRIP_UPPER, state.field_62674);
            data.clawLower = CachedBuffers.partial(AllPartialModels.ARM_CLAW_GRIP_LOWER, state.field_62674);
            data.light = state.field_62676;
            data.color = rave ? Color.rainbowColor(AnimationTickHolder.getTicks() * 100).getRGB() : 0xFFFFFF;
            boolean bl2 = data.inverted = inverted && goggles;
            data.clawOffset = empty ? 0.0625f : (isBlockItem ? 0.1875f : 0.078125f);
        }
    }

    @Override
    public void render(ArmRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.render(state, matrices, queue, cameraState);
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        if (state.rotate != 0.0f) {
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(state.rotate));
        }
        matrices.method_46416(0.0f, 0.25f, 0.0f);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(state.baseAngle));
        if (state.support) {
            matrices.method_46416(0.0f, 0.125f, 0.0f);
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(state.lowerArmAngle));
            matrices.method_46416(0.0f, 0.0f, -0.875f);
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(state.upperArmAngle));
            matrices.method_46416(0.0f, 0.0f, -0.9375f);
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(state.headAngle));
            state.item.render(matrices, queue, state.field_62676);
        } else {
            queue.method_73483(matrices, state.layer, state.arm::renderBase);
            matrices.method_46416(0.0f, 0.125f, 0.0f);
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(state.lowerArmAngle));
            queue.method_73483(matrices, state.layer, state.arm::renderLower);
            matrices.method_46416(0.0f, 0.0f, -0.875f);
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(state.upperArmAngle));
            queue.method_73483(matrices, state.layer, state.arm::renderUpper);
            matrices.method_46416(0.0f, 0.0f, -0.9375f);
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(state.headAngle));
            if (state.arm.inverted) {
                matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(state.rotate));
                queue.method_73483(matrices, state.layer, state.arm::renderClaw);
                matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(state.rotate));
            } else {
                queue.method_73483(matrices, state.layer, state.arm::renderClaw);
            }
            matrices.method_22903();
            matrices.method_46416(0.0f, -state.arm.clawOffset, -0.375f);
            queue.method_73483(matrices, state.layer, state.arm::renderClawLower);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_46416(0.0f, state.arm.clawOffset, -0.375f);
            queue.method_73483(matrices, state.layer, state.arm::renderClawUpper);
            matrices.method_22909();
            if (state.item != null) {
                state.item.render(matrices, queue, state.field_62676);
            }
        }
    }

    @Override
    protected class_1921 getRenderType(ArmBlockEntity be, class_2680 state) {
        return be.goggles ? class_1921.method_23581() : class_1921.method_23577();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(ArmBlockEntity be, ArmRenderState state) {
        return CachedBuffers.partial(AllPartialModels.ARM_COG, state.field_62674);
    }

    public static void transformClawHalf(TransformStack<?> msr, boolean hasItem, boolean isBlockItem, int flip) {
        msr.translate(0.0, (double)((float)(-flip) * (hasItem ? (isBlockItem ? 0.1875f : 0.078125f) : 0.0625f)), -0.375);
    }

    public static void transformHead(TransformStack<?> msr, float headAngle) {
        msr.translate(0.0, 0.0, -0.9375);
        msr.rotateXDegrees(headAngle - 45.0f);
    }

    public static void transformUpperArm(TransformStack<?> msr, float upperArmAngle) {
        msr.translate(0.0, 0.0, -0.875);
        msr.rotateXDegrees(upperArmAngle - 90.0f);
    }

    public static void transformLowerArm(TransformStack<?> msr, float lowerArmAngle) {
        msr.translate(0.0, 0.125, 0.0);
        msr.rotateXDegrees(lowerArmAngle + 135.0f);
    }

    public static void transformBase(TransformStack<?> msr, float baseAngle) {
        msr.translate(0.0, 0.25, 0.0);
        msr.rotateYDegrees(baseAngle);
    }

    public boolean method_3563() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class ArmRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public float rotate;
        public float baseAngle;
        public float lowerArmAngle;
        public float upperArmAngle;
        public float headAngle;
        public ArmRenderData arm;
        public ArmItemData item;
    }

    @Environment(value=EnvType.CLIENT)
    public static class ArmItemData {
        public class_10444 state;
        public float xRot;
        public float offset;
        public float scale;

        public void render(class_4587 matrices, class_11659 queue, int light) {
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(this.xRot));
            matrices.method_46416(0.0f, this.offset, 0.0f);
            matrices.method_22905(this.scale, this.scale, this.scale);
            this.state.method_65604(matrices, queue, light, class_4608.field_21444, 0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ArmRenderData {
        public SuperByteBuffer base;
        public SuperByteBuffer lower;
        public SuperByteBuffer upper;
        public SuperByteBuffer claw;
        public SuperByteBuffer clawUpper;
        public SuperByteBuffer clawLower;
        public int light;
        public int color;
        public boolean inverted;
        public float clawOffset;

        public void renderBase(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.base.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderClaw(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.claw.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderClawLower(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.clawLower.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderClawUpper(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.clawUpper.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderLower(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.lower.light(this.light).color(this.color).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderUpper(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.upper.light(this.light).color(this.color).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

