/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.factoryBoard;

import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelSlotPositioning;
import com.zurrtum.create.client.content.logistics.packagerLink.LogisticallyLinkedClientHandler;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsBoard;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsFormatter;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.PanelSlot;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class FactoryPanelBehaviour
extends FilteringBehaviour<ServerFactoryPanelBehaviour> {
    public static final BehaviourType<FactoryPanelBehaviour> TOP_LEFT = new BehaviourType();
    public static final BehaviourType<FactoryPanelBehaviour> TOP_RIGHT = new BehaviourType();
    public static final BehaviourType<FactoryPanelBehaviour> BOTTOM_LEFT = new BehaviourType();
    public static final BehaviourType<FactoryPanelBehaviour> BOTTOM_RIGHT = new BehaviourType();

    public FactoryPanelBehaviour(FactoryPanelBlockEntity be, PanelSlot slot) {
        super(be, new FactoryPanelSlotPositioning(slot));
        this.behaviour = be.panels.get((Object)slot);
    }

    public static Function<FactoryPanelBlockEntity, BlockEntityBehaviour<?>>[] allSlot() {
        PanelSlot[] slots = PanelSlot.values();
        Function[] all = new Function[slots.length];
        for (PanelSlot slot : slots) {
            all[i] = be -> new FactoryPanelBehaviour((FactoryPanelBlockEntity)be, slot);
        }
        return all;
    }

    public static List<FilteringBehaviour<?>> allBehaviours(FactoryPanelBlockEntity be) {
        int size = PanelSlot.values().length;
        ArrayList list = new ArrayList(size);
        int count = 0;
        for (BlockEntityBehaviour<?> behaviour : be.getAllBehaviours()) {
            if (!(behaviour instanceof FactoryPanelBehaviour)) continue;
            FactoryPanelBehaviour factoryPanelBehaviour = (FactoryPanelBehaviour)behaviour;
            list.add(factoryPanelBehaviour);
            if (++count != size) continue;
            break;
        }
        return list;
    }

    @Nullable
    public static FactoryPanelBehaviour at(class_1920 world, FactoryPanelPosition pos) {
        class_1937 l;
        if (world instanceof class_1937 && !(l = (class_1937)world).method_8477(pos.pos())) {
            return null;
        }
        class_2586 class_25862 = world.method_8321(pos.pos());
        if (!(class_25862 instanceof FactoryPanelBlockEntity)) {
            return null;
        }
        FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)class_25862;
        FactoryPanelBehaviour factoryPanel = fpbe.getBehaviour(FactoryPanelBehaviour.getTypeForSlot(pos.slot()));
        if (((ServerFactoryPanelBehaviour)factoryPanel.behaviour).isActive()) {
            return factoryPanel;
        }
        return null;
    }

    @Override
    public BehaviourType<? extends BlockEntityBehaviour<?>> getType() {
        return FactoryPanelBehaviour.getTypeForSlot(((ServerFactoryPanelBehaviour)this.behaviour).slot);
    }

    public static BehaviourType<FactoryPanelBehaviour> getTypeForSlot(PanelSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case PanelSlot.BOTTOM_LEFT -> BOTTOM_LEFT;
            case PanelSlot.TOP_LEFT -> TOP_LEFT;
            case PanelSlot.TOP_RIGHT -> TOP_RIGHT;
            case PanelSlot.BOTTOM_RIGHT -> BOTTOM_RIGHT;
        };
    }

    @Override
    public void tick() {
        if (this.getWorld().method_8608() && ((ServerFactoryPanelBehaviour)this.behaviour).active) {
            LogisticallyLinkedClientHandler.tickPanel(this);
        }
    }

    public UUID getNetwork() {
        return ((ServerFactoryPanelBehaviour)this.behaviour).network;
    }

    public FactoryPanelPosition getPanelPosition() {
        return ((ServerFactoryPanelBehaviour)this.behaviour).getPanelPosition();
    }

    @Override
    public class_5250 formatValue(ValueSettings value) {
        if (value.value() == 0) {
            return CreateLang.translateDirect("gui.factory_panel.inactive", new Object[0]);
        }
        return class_2561.method_43470((String)(Math.max(0, value.value()) + (value.row() == 0 ? "" : "\u25a4")));
    }

    @Override
    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        int maxAmount = 100;
        return new ValueSettingsBoard((class_2561)CreateLang.translate("factory_panel.target_amount", new Object[0]).component(), maxAmount, 10, List.of(CreateLang.translate("schedule.condition.threshold.items", new Object[0]).component(), CreateLang.translate("schedule.condition.threshold.stacks", new Object[0]).component()), new ValueSettingsFormatter(this::formatValue));
    }

    @Override
    public class_5250 getLabel() {
        Object key = "";
        if (!((ServerFactoryPanelBehaviour)this.behaviour).targetedBy.isEmpty() && ((ServerFactoryPanelBehaviour)this.behaviour).count == 0) {
            return CreateLang.translate("gui.factory_panel.no_target_amount_set", new Object[0]).style(class_124.field_1061).component();
        }
        if (((ServerFactoryPanelBehaviour)this.behaviour).isMissingAddress()) {
            return CreateLang.translate("gui.factory_panel.address_missing", new Object[0]).style(class_124.field_1061).component();
        }
        if (this.getFilter().method_7960()) {
            key = "factory_panel.new_factory_task";
        } else if (((ServerFactoryPanelBehaviour)this.behaviour).waitingForNetwork) {
            key = "factory_panel.some_links_unloaded";
        } else {
            if (((ServerFactoryPanelBehaviour)this.behaviour).getAmount() == 0 || ((ServerFactoryPanelBehaviour)this.behaviour).targetedBy.isEmpty()) {
                return ((ServerFactoryPanelBehaviour)this.behaviour).getFilter().method_7964().method_27662();
            }
            key = ((ServerFactoryPanelBehaviour)this.behaviour).getFilter().method_7964().getString();
            if (((ServerFactoryPanelBehaviour)this.behaviour).redstonePowered) {
                key = (String)key + " " + CreateLang.translate("factory_panel.redstone_paused", new Object[0]).string();
            } else if (!((ServerFactoryPanelBehaviour)this.behaviour).satisfied) {
                key = (String)key + " " + CreateLang.translate("factory_panel.in_progress", new Object[0]).string();
            }
            return CreateLang.text((String)key).component();
        }
        return CreateLang.translate((String)key, new Object[0]).component();
    }

    @Override
    public class_5250 getTip() {
        return CreateLang.translateDirect(this.getFilter().method_7960() ? "logistics.filter.click_to_set" : "factory_panel.click_to_configure", new Object[0]);
    }

    @Override
    public class_5250 getAmountTip() {
        return CreateLang.translateDirect("factory_panel.hold_to_set_amount", new Object[0]);
    }

    @Override
    public class_5250 getCountLabelForValueBox() {
        String stacks;
        if (this.getFilter().method_7960()) {
            return class_2561.method_43473();
        }
        if (((ServerFactoryPanelBehaviour)this.behaviour).waitingForNetwork) {
            return class_2561.method_43470((String)"?");
        }
        int levelInStorage = ((ServerFactoryPanelBehaviour)this.behaviour).getLevelInStorage();
        boolean inf = levelInStorage >= 1000000000;
        int inStorage = levelInStorage / (((ServerFactoryPanelBehaviour)this.behaviour).upTo ? 1 : this.getFilter().method_7914());
        int promised = ((ServerFactoryPanelBehaviour)this.behaviour).getPromised();
        String string = stacks = ((ServerFactoryPanelBehaviour)this.behaviour).upTo ? "" : "\u25a4";
        if (((ServerFactoryPanelBehaviour)this.behaviour).count == 0) {
            return CreateLang.text((String)(inf ? "  \u221e" : inStorage + stacks)).color(15855592).component();
        }
        return CreateLang.text((String)(inf ? "  \u221e" : "   " + inStorage + stacks)).color(((ServerFactoryPanelBehaviour)this.behaviour).satisfied ? 14155688 : (((ServerFactoryPanelBehaviour)this.behaviour).promisedSatisfied ? 16764277 : 16760744)).add(CreateLang.text(promised == 0 ? "" : "\u23f6")).add(CreateLang.text("/").style(class_124.field_1068)).add(CreateLang.text(((ServerFactoryPanelBehaviour)this.behaviour).count + stacks + "  ").color(15855592)).component();
    }

    @Override
    public float getRenderDistance() {
        return 64.0f;
    }
}

