/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.displayLink;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.util.ShadersModHelper;
import com.zurrtum.create.client.foundation.render.RenderTypes;
import com.zurrtum.create.content.redstone.displayLink.LinkWithBulbBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class LinkBulbRenderer
implements class_827<LinkWithBulbBlockEntity, LinkBulbRenderState> {
    private static final boolean IRIS = FabricLoader.getInstance().isModLoaded("iris");

    public LinkBulbRenderer(class_5614.class_5615 context) {
    }

    public LinkBulbRenderState createRenderState() {
        return new LinkBulbRenderState();
    }

    public void updateRenderState(LinkWithBulbBlockEntity be, LinkBulbRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        class_2350 face = be.getBulbFacing(state.field_62674);
        state.yRot = (float)Math.PI / 180 * (AngleHelper.horizontalAngle(face) + 180.0f);
        state.xRot = (float)Math.PI / 180 * (-AngleHelper.verticalAngle(face) - 90.0f);
        state.offset = be.getBulbOffset(state.field_62674);
        state.tube = CachedBuffers.partial(AllPartialModels.DISPLAY_LINK_TUBE, state.field_62674);
        float glow = be.getGlow(tickProgress);
        if (glow < 0.125f) {
            state.translucent = ShadersModHelper.isShaderPackInUse() ? class_1921.method_29380() : PonderRenderTypes.translucent();
            return;
        }
        state.translucent = ShadersModHelper.isShaderPackInUse() ? class_1921.method_29380() : RenderTypes.translucent();
        state.additive = RenderTypes.additive();
        state.glow = CachedBuffers.partial(AllPartialModels.DISPLAY_LINK_GLOW, state.field_62674);
        glow = (float)(1.0 - 2.0 * Math.pow(glow - 0.75f, 2.0));
        glow = class_3532.method_15363((float)glow, (float)-1.0f, (float)1.0f);
        state.color = (int)(200.0f * glow);
    }

    public void render(LinkBulbRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(state.yRot));
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(state.xRot));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        queue.method_73483(matrices, state.translucent, state::renderTube);
        if (state.glow != null) {
            (IRIS ? queue.method_73529(1) : queue).method_73483(matrices, state.additive, state::renderGlow);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class LinkBulbRenderState
    extends class_11954 {
        public class_1921 translucent;
        public class_1921 additive;
        public SuperByteBuffer tube;
        public SuperByteBuffer glow;
        public float yRot;
        public float xRot;
        public class_243 offset;
        public int color;

        public void renderTube(class_4587.class_4665 entry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)this.tube.translate(this.offset)).light(0xF000F0).renderInto(entry, vertexConsumer);
        }

        public void renderGlow(class_4587.class_4665 entry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)this.glow.translate(this.offset)).light(0xF000F0).color(this.color, this.color, this.color, 255).disableDiffuse().renderInto(entry, vertexConsumer);
        }
    }
}

