/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.cannon;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.schematics.cannon.LaunchedItem;
import com.zurrtum.create.content.schematics.cannon.SchematicannonBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class SchematicannonRenderer
implements class_827<SchematicannonBlockEntity, SchematicannonRenderState> {
    protected final class_10442 itemModelManager;

    public SchematicannonRenderer(class_5614.class_5615 context) {
        this.itemModelManager = context.comp_4536();
    }

    public SchematicannonRenderState createRenderState() {
        return new SchematicannonRenderState();
    }

    public void updateRenderState(SchematicannonBlockEntity be, SchematicannonRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_1937 world = be.method_10997();
        boolean support = VisualizationManager.supportsVisualization((class_1936)world);
        boolean empty = be.flyingBlocks.isEmpty();
        if (support && empty) {
            return;
        }
        class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        if (!empty) {
            state.blocks = this.getFlyBlocksRenderState(be, world, state.field_62673, tickProgress);
        }
        if (support) {
            return;
        }
        SchematicannonRenderData data = state.data = new SchematicannonRenderData();
        data.layer = class_1921.method_23577();
        double[] cannonAngles = SchematicannonRenderer.getCannonAngles(be, state.field_62673, tickProgress);
        double recoil = SchematicannonRenderer.getRecoil(be, tickProgress);
        data.connector = CachedBuffers.partial(AllPartialModels.SCHEMATICANNON_CONNECTOR, state.field_62674);
        data.yaw = (float)(0.01745329238474369 * (cannonAngles[0] + 90.0));
        data.pipe = CachedBuffers.partial(AllPartialModels.SCHEMATICANNON_PIPE, state.field_62674);
        data.pitch = (float)(0.01745329238474369 * cannonAngles[1]);
        data.offset = (float)(-recoil / 100.0);
        data.light = state.field_62676;
    }

    public void render(SchematicannonRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.blocks != null) {
            for (LaunchedRenderState block : state.blocks) {
                block.render(matrices, queue, state.field_62676);
            }
        }
        if (state.data != null) {
            queue.method_73483(matrices, state.data.layer, (class_11659.class_11660)state.data);
        }
    }

    @Nullable
    public List<LaunchedRenderState> getFlyBlocksRenderState(SchematicannonBlockEntity be, class_1937 world, class_2338 pos, float partialTicks) {
        ArrayList<LaunchedRenderState> blocks = new ArrayList<LaunchedRenderState>();
        class_243 position = class_243.method_24953((class_2382)pos.method_10084());
        for (LaunchedItem launched : be.flyingBlocks) {
            if (launched.ticksRemaining == 0) continue;
            class_243 target = class_243.method_24953((class_2382)launched.target);
            class_243 distance = target.method_1020(position);
            double yDifference = target.field_1351 - position.field_1351;
            double throwHeight = Math.sqrt(distance.method_1027()) * (double)0.6f + yDifference;
            class_243 cannonOffset = distance.method_1031(0.0, throwHeight, 0.0).method_1029().method_1021(2.0);
            class_243 start = position.method_1019(cannonOffset);
            yDifference = target.field_1351 - start.field_1351;
            float t = ((float)launched.totalTicks - ((float)(launched.ticksRemaining + 1) - partialTicks)) / (float)launched.totalTicks;
            class_243 blockLocationXZ = target.method_1020(start).method_1021((double)t).method_18805(1.0, 0.0, 1.0);
            double yOffset = (double)(2.0f * (1.0f - t) * t) * throwHeight + (double)(t * t) * yDifference;
            class_243 blockLocation = blockLocationXZ.method_1031(0.5, yOffset + 1.5, 0.5).method_1019(cannonOffset);
            float angle = (float)Math.PI * 2 * t;
            if (launched instanceof LaunchedItem.ForBlockState) {
                LaunchedItem.ForBlockState forBlockState = (LaunchedItem.ForBlockState)launched;
                class_2680 state = launched instanceof LaunchedItem.ForBelt ? AllBlocks.SHAFT.method_9564() : forBlockState.state;
                blocks.add(new LaunchedBlockRenderState(blockLocation, angle, 0.3f, state));
            } else if (launched instanceof LaunchedItem.ForEntity) {
                class_10444 item = new class_10444();
                item.field_55337 = class_811.field_4318;
                this.itemModelManager.method_65596(item, launched.stack, item.field_55337, world, null, 0);
                blocks.add(new LaunchedEntityRenderState(blockLocation, angle, 1.2f, item));
            }
            if (launched.ticksRemaining != launched.totalTicks || !be.firstRenderTick) continue;
            start = start.method_1023(0.5, 0.5, 0.5);
            be.firstRenderTick = false;
            class_5819 r = world.method_8409();
            for (int i = 0; i < 10; ++i) {
                double sX = cannonOffset.field_1352 * (double)0.01f;
                double sY = (cannonOffset.field_1351 + 1.0) * (double)0.01f;
                double sZ = cannonOffset.field_1350 * (double)0.01f;
                double rX = (double)r.method_43057() - sX * 40.0;
                double rY = (double)r.method_43057() - sY * 40.0;
                double rZ = (double)r.method_43057() - sZ * 40.0;
                world.method_8406((class_2394)class_2398.field_11204, start.field_1352 + rX, start.field_1351 + rY, start.field_1350 + rZ, sX, sY, sZ);
            }
        }
        if (blocks.isEmpty()) {
            return null;
        }
        return blocks;
    }

    public static double[] getCannonAngles(SchematicannonBlockEntity blockEntity, class_2338 pos, float partialTicks) {
        double pitch;
        double yaw;
        class_2338 target = blockEntity.printer.getCurrentTarget();
        if (target != null) {
            class_243 diff = class_243.method_24954((class_2382)target.method_10059((class_2382)pos));
            if (blockEntity.previousTarget != null) {
                diff = class_243.method_24954((class_2382)blockEntity.previousTarget).method_1019(class_243.method_24954((class_2382)target.method_10059((class_2382)blockEntity.previousTarget)).method_1021((double)partialTicks)).method_1020(class_243.method_24954((class_2382)pos));
            }
            double diffX = diff.method_10216();
            double diffZ = diff.method_10215();
            yaw = class_3532.method_15349((double)diffX, (double)diffZ);
            yaw = yaw / Math.PI * 180.0;
            float distance = class_3532.method_15355((float)((float)(diffX * diffX + diffZ * diffZ)));
            double yOffset = 0.0f + distance * 2.0f;
            pitch = class_3532.method_15349((double)distance, (double)(diff.method_10214() * 3.0 + yOffset));
            pitch = pitch / Math.PI * 180.0 + 10.0;
        } else {
            yaw = blockEntity.defaultYaw;
            pitch = 40.0;
        }
        return new double[]{yaw, pitch};
    }

    public static double getRecoil(SchematicannonBlockEntity blockEntity, float partialTicks) {
        double recoil = 0.0;
        for (LaunchedItem launched : blockEntity.flyingBlocks) {
            if (launched.ticksRemaining == 0 || !((float)(launched.ticksRemaining + 1) - partialTicks > (float)(launched.totalTicks - 10))) continue;
            recoil = Math.max(recoil, (double)((float)(launched.ticksRemaining + 1) - partialTicks - (float)launched.totalTicks + 10.0f));
        }
        return recoil;
    }

    public boolean method_3563() {
        return true;
    }

    public int method_33893() {
        return 128;
    }

    @Environment(value=EnvType.CLIENT)
    public static class SchematicannonRenderState
    extends class_11954 {
        public List<LaunchedRenderState> blocks;
        public SchematicannonRenderData data;
    }

    @Environment(value=EnvType.CLIENT)
    public static class SchematicannonRenderData
    implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer connector;
        public float yaw;
        public SuperByteBuffer pipe;
        public float pitch;
        public float offset;
        public int light;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.connector.translate(0.5f, 0.0f, 0.5f)).rotate(this.yaw, class_2350.field_11036)).translate(-0.5f, 0.0f, -0.5f)).light(this.light).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.pipe.translate(0.5f, 0.9375f, 0.5f)).rotate(this.yaw, class_2350.field_11036)).rotate(this.pitch, class_2350.field_11035)).translate(-0.5f, -0.9375f, -0.5f)).translate(0.0f, this.offset, 0.0f)).light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class LaunchedRenderState {
        public class_243 offset;
        public float angle;
        public float scale;

        public LaunchedRenderState(class_243 offset, float angle, float scale) {
            this.offset = offset;
            this.angle = angle;
            this.scale = scale;
        }

        public void render(class_4587 matrices, class_11659 queue, int light) {
            matrices.method_22903();
            matrices.method_61958(this.offset);
            matrices.method_46416(0.125f, 0.125f, 0.125f);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.angle));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(this.angle));
            matrices.method_46416(-0.125f, -0.125f, -0.125f);
            matrices.method_22905(this.scale, this.scale, this.scale);
            this.submit(queue, matrices, light);
            matrices.method_22909();
        }

        public abstract void submit(class_11659 var1, class_4587 var2, int var3);
    }

    @Environment(value=EnvType.CLIENT)
    public static class LaunchedBlockRenderState
    extends LaunchedRenderState {
        public class_2680 state;

        public LaunchedBlockRenderState(class_243 offset, float angle, float scale, class_2680 state) {
            super(offset, angle, scale);
            this.state = state;
        }

        @Override
        public void submit(class_11659 queue, class_4587 matrices, int light) {
            queue.method_73481(matrices, this.state, light, class_4608.field_21444, 0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class LaunchedEntityRenderState
    extends LaunchedRenderState {
        public class_10444 item;

        public LaunchedEntityRenderState(class_243 offset, float angle, float scale, class_10444 item) {
            super(offset, angle, scale);
            this.item = item;
        }

        @Override
        public void submit(class_11659 queue, class_4587 matrices, int light) {
            this.item.method_65604(matrices, queue, light, class_4608.field_21444, 0);
        }
    }
}

