/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.AABBOutline;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.content.schematics.client.SchematicHotbarSlotOverlay;
import com.zurrtum.create.client.content.schematics.client.SchematicRenderer;
import com.zurrtum.create.client.content.schematics.client.SchematicTransformation;
import com.zurrtum.create.client.content.schematics.client.ToolSelectionScreen;
import com.zurrtum.create.client.content.schematics.client.tools.ToolType;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.schematics.SchematicInstances;
import com.zurrtum.create.content.schematics.SchematicItem;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.infrastructure.packet.c2s.SchematicPlacePacket;
import com.zurrtum.create.infrastructure.packet.c2s.SchematicSyncPacket;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5425;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class SchematicHandler {
    private String displayedSchematic;
    private SchematicTransformation transformation;
    private class_238 bounds;
    private boolean deployed;
    private boolean active;
    private ToolType currentTool;
    private static final int SYNC_DELAY = 10;
    private int syncCooldown;
    private int activeHotbarSlot;
    private class_1799 activeSchematicItem;
    private AABBOutline outline;
    private final SchematicRenderer[] renderers = new SchematicRenderer[3];
    private final SchematicHotbarSlotOverlay overlay = new SchematicHotbarSlotOverlay();
    private ToolSelectionScreen selectionScreen;

    public SchematicHandler() {
        this.currentTool = ToolType.DEPLOY;
        this.selectionScreen = new ToolSelectionScreen(class_310.method_1551(), (List<ToolType>)ImmutableList.of((Object)((Object)ToolType.DEPLOY)), this::equip);
        this.transformation = new SchematicTransformation();
    }

    public void tick(class_310 mc) {
        class_746 player;
        class_1799 stack;
        if (mc.field_1761.method_2920() == class_1934.field_9219) {
            if (this.active) {
                this.active = false;
                this.syncCooldown = 0;
                this.activeHotbarSlot = 0;
                this.activeSchematicItem = null;
            }
            return;
        }
        if (this.activeSchematicItem != null && this.transformation != null) {
            this.transformation.tick();
        }
        if ((stack = this.findBlueprintInHand((class_1657)(player = mc.field_1724))) == null) {
            this.active = false;
            this.syncCooldown = 0;
            if (this.activeSchematicItem != null && this.itemLost((class_1657)player)) {
                this.activeHotbarSlot = 0;
                this.activeSchematicItem = null;
            }
            return;
        }
        if (!this.active || !((String)stack.method_58694(AllDataComponents.SCHEMATIC_FILE)).equals(this.displayedSchematic)) {
            this.init(mc, stack);
        }
        if (!this.active) {
            return;
        }
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
        }
        if (this.syncCooldown == 1) {
            this.sync(player);
        }
        this.selectionScreen.update();
        this.currentTool.getTool().updateSelection(mc);
    }

    private void init(class_310 mc, class_1799 stack) {
        class_746 player = mc.field_1724;
        this.loadSettings(stack);
        this.displayedSchematic = (String)stack.method_58694(AllDataComponents.SCHEMATIC_FILE);
        this.active = true;
        if (this.deployed) {
            this.setupRenderer(mc);
            ToolType toolBefore = this.currentTool;
            this.selectionScreen = new ToolSelectionScreen(mc, ToolType.getTools(player.method_68878()), this::equip);
            if (toolBefore != null) {
                this.selectionScreen.setSelectedElement(toolBefore);
                this.equip(toolBefore);
            }
        } else {
            this.selectionScreen = new ToolSelectionScreen(mc, (List<ToolType>)ImmutableList.of((Object)((Object)ToolType.DEPLOY)), this::equip);
        }
    }

    private void setupRenderer(class_310 mc) {
        class_638 clientWorld = mc.field_1687;
        class_3499 schematic = SchematicItem.loadSchematic((class_1937)clientWorld, this.activeSchematicItem);
        class_2382 size = schematic.method_15160();
        if (size.equals((Object)class_2382.field_11176)) {
            return;
        }
        SchematicLevel w = new SchematicLevel((class_1937)clientWorld);
        SchematicLevel wMirroredFB = new SchematicLevel((class_1937)clientWorld);
        SchematicLevel wMirroredLR = new SchematicLevel((class_1937)clientWorld);
        class_3492 placementSettings = new class_3492();
        class_2338 pos = class_2338.field_10980;
        try {
            schematic.method_15172((class_5425)w, pos, pos, placementSettings, w.method_8409(), 2);
            for (class_2586 blockEntity : w.getBlockEntities()) {
                blockEntity.method_31662((class_1937)w);
            }
            this.fixControllerBlockEntities(w);
        }
        catch (Exception e) {
            mc.field_1724.method_7353((class_2561)CreateLang.translate("schematic.error", new Object[0]).component(), false);
            Create.LOGGER.error("Failed to load Schematic for Previewing", (Throwable)e);
            return;
        }
        placementSettings.method_15125(class_2415.field_11301);
        pos = class_2338.field_10980.method_10089(size.method_10263() - 1);
        schematic.method_15172((class_5425)wMirroredFB, pos, pos, placementSettings, wMirroredFB.method_8409(), 2);
        StructureTransform transform = new StructureTransform(placementSettings.method_15134(), class_2350.class_2351.field_11052, class_2470.field_11467, placementSettings.method_15114());
        for (class_2586 be : wMirroredFB.getRenderedBlockEntities()) {
            transform.apply(be);
        }
        this.fixControllerBlockEntities(wMirroredFB);
        placementSettings.method_15125(class_2415.field_11300);
        pos = class_2338.field_10980.method_10077(size.method_10260() - 1);
        schematic.method_15172((class_5425)wMirroredLR, pos, pos, placementSettings, wMirroredFB.method_8409(), 2);
        transform = new StructureTransform(placementSettings.method_15134(), class_2350.class_2351.field_11052, class_2470.field_11467, placementSettings.method_15114());
        for (class_2586 be : wMirroredLR.getRenderedBlockEntities()) {
            transform.apply(be);
        }
        this.fixControllerBlockEntities(wMirroredLR);
        this.renderers[0] = new SchematicRenderer(w);
        this.renderers[1] = new SchematicRenderer(wMirroredFB);
        this.renderers[2] = new SchematicRenderer(wMirroredLR);
    }

    private void fixControllerBlockEntities(SchematicLevel level) {
        for (class_2586 blockEntity : level.getBlockEntities()) {
            if (!(blockEntity instanceof IMultiBlockEntityContainer)) continue;
            IMultiBlockEntityContainer multiBlockEntity = (IMultiBlockEntityContainer)blockEntity;
            class_2338 lastKnown = multiBlockEntity.getLastKnownPos();
            class_2338 current = blockEntity.method_11016();
            if (lastKnown == null || current == null || multiBlockEntity.isController() || lastKnown.equals((Object)current)) continue;
            class_2338 newControllerPos = multiBlockEntity.getController().method_10081((class_2382)current.method_10059((class_2382)lastKnown));
            if (multiBlockEntity instanceof SmartBlockEntity) {
                SmartBlockEntity sbe = (SmartBlockEntity)((Object)multiBlockEntity);
                sbe.markVirtual();
            }
            multiBlockEntity.setController(newControllerPos);
        }
    }

    public void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera) {
        boolean present;
        if (!this.active) {
            return;
        }
        boolean bl = present = this.activeSchematicItem != null;
        if (!present) {
            return;
        }
        ms.method_22903();
        this.currentTool.getTool().renderTool(mc, ms, buffer, camera);
        ms.method_22909();
        ms.method_22903();
        this.transformation.applyTransformations(ms, camera);
        if (this.deployed) {
            boolean fb;
            float pt = AnimationTickHolder.getPartialTicks();
            boolean lr = this.transformation.getScaleLR().getValue(pt) < 0.0f;
            boolean bl2 = fb = this.transformation.getScaleFB().getValue(pt) < 0.0f;
            if (lr && !fb && this.renderers[2] != null) {
                this.renderers[2].render(mc, ms, buffer, this.transformation, camera);
            } else if (fb && !lr && this.renderers[1] != null) {
                this.renderers[1].render(mc, ms, buffer, this.transformation, camera);
            } else if (this.renderers[0] != null) {
                this.renderers[0].render(mc, ms, buffer, this.transformation, camera);
            }
        }
        this.currentTool.getTool().renderOnSchematic(mc, ms, buffer);
        ms.method_22909();
    }

    public void updateRenderers() {
        for (SchematicRenderer renderer : this.renderers) {
            if (renderer == null) continue;
            renderer.update();
        }
    }

    public void render(class_310 mc, class_332 guiGraphics, class_9779 deltaTracker) {
        if (!this.active) {
            return;
        }
        float tickProgress = deltaTracker.method_60637(false);
        if (this.activeSchematicItem != null) {
            this.overlay.renderOn(mc, guiGraphics, this.activeHotbarSlot, tickProgress);
        }
        this.currentTool.getTool().renderOverlay(mc.field_1705, guiGraphics, tickProgress, guiGraphics.method_51421(), guiGraphics.method_51443());
        this.selectionScreen.renderPassive(guiGraphics, tickProgress);
    }

    public boolean onMouseInput(class_310 mc, int button) {
        if (!this.active) {
            return false;
        }
        if (button != 1) {
            return false;
        }
        if (mc.field_1724.method_5715()) {
            return false;
        }
        class_239 class_2393 = mc.field_1765;
        if (class_2393 instanceof class_3965) {
            class_3965 blockRayTraceResult = (class_3965)class_2393;
            class_2680 clickedBlock = mc.field_1687.method_8320(blockRayTraceResult.method_17777());
            if (clickedBlock.method_27852((class_2248)AllBlocks.SCHEMATICANNON)) {
                return false;
            }
            if (clickedBlock.method_27852((class_2248)AllBlocks.DEPLOYER)) {
                return false;
            }
        }
        return this.currentTool.getTool().handleRightClick(mc);
    }

    public boolean onKeyInput(class_11908 input, boolean pressed) {
        if (!this.active || !AllKeys.TOOL_MENU.method_1417(input)) {
            return false;
        }
        if (pressed && !this.selectionScreen.focused) {
            this.selectionScreen.focused = true;
        }
        if (!pressed && this.selectionScreen.focused) {
            this.selectionScreen.focused = false;
            this.selectionScreen.method_25419();
        }
        return true;
    }

    public boolean mouseScrolled(double delta) {
        if (!this.active) {
            return false;
        }
        if (this.selectionScreen.focused) {
            this.selectionScreen.cycle((int)Math.signum(delta));
            return true;
        }
        if (AllKeys.hasControlDown()) {
            return this.currentTool.getTool().handleMouseWheel(delta);
        }
        return false;
    }

    private class_1799 findBlueprintInHand(class_1657 player) {
        class_1799 stack = player.method_6047();
        if (!stack.method_31574((class_1792)AllItems.SCHEMATIC)) {
            return null;
        }
        if (!stack.method_57826(AllDataComponents.SCHEMATIC_FILE)) {
            return null;
        }
        this.activeSchematicItem = stack;
        this.activeHotbarSlot = player.method_31548().method_67532();
        return stack;
    }

    private boolean itemLost(class_1657 player) {
        class_1661 inventory = player.method_31548();
        int size = class_1661.method_7368();
        for (int i = 0; i < size; ++i) {
            if (inventory.method_5438(i).method_31574(this.activeSchematicItem.method_7909()) || !class_1799.method_7973((class_1799)inventory.method_5438(i), (class_1799)this.activeSchematicItem)) continue;
            return false;
        }
        return true;
    }

    public void markDirty() {
        this.syncCooldown = 10;
    }

    public void sync(class_746 player) {
        if (this.activeSchematicItem == null) {
            return;
        }
        player.field_3944.method_52787((class_2596)new SchematicSyncPacket(this.activeHotbarSlot, this.transformation.toSettings(), this.transformation.getAnchor(), this.deployed));
    }

    public void equip(ToolType tool) {
        this.currentTool = tool;
        this.currentTool.getTool().init();
    }

    public void loadSettings(class_1799 blueprint) {
        class_2338 anchor = class_2338.field_10980;
        class_3492 settings = SchematicItem.getSettings(blueprint);
        this.transformation = new SchematicTransformation();
        this.deployed = (Boolean)blueprint.method_58695(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)false);
        anchor = (class_2338)blueprint.method_58695(AllDataComponents.SCHEMATIC_ANCHOR, (Object)class_2338.field_10980);
        class_2382 size = (class_2382)blueprint.method_58694(AllDataComponents.SCHEMATIC_BOUNDS);
        if (size == null) {
            return;
        }
        this.bounds = new class_238(0.0, 0.0, 0.0, (double)size.method_10263(), (double)size.method_10264(), (double)size.method_10260());
        this.outline = new AABBOutline(this.bounds);
        this.outline.getParams().colored(6850245).lineWidth(0.0625f);
        this.transformation.init(anchor, settings, this.bounds);
    }

    public void deploy(class_310 mc) {
        if (!this.deployed) {
            List<ToolType> tools = ToolType.getTools(mc.field_1724.method_68878());
            this.selectionScreen = new ToolSelectionScreen(mc, tools, this::equip);
        }
        this.deployed = true;
        this.setupRenderer(mc);
    }

    public String getCurrentSchematicName() {
        return this.displayedSchematic != null ? this.displayedSchematic : "-";
    }

    public void printInstantly(class_310 mc) {
        mc.field_1724.field_3944.method_52787((class_2596)new SchematicPlacePacket(this.activeSchematicItem.method_7972()));
        this.activeSchematicItem.method_57379(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)false);
        SchematicInstances.clearHash(this.activeSchematicItem);
        this.active = false;
        this.markDirty();
    }

    public boolean isActive() {
        return this.active;
    }

    public class_238 getBounds() {
        return this.bounds;
    }

    public SchematicTransformation getTransformation() {
        return this.transformation;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public class_1799 getActiveSchematicItem() {
        return this.activeSchematicItem;
    }

    public AABBOutline getOutline() {
        return this.outline;
    }
}

