/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_3492;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class SchematicTransformation {
    private class_243 chasingPos = class_243.field_1353;
    private class_243 prevChasingPos = class_243.field_1353;
    private class_2338 target = class_2338.field_10980;
    private LerpedFloat scaleFrontBack = LerpedFloat.linear();
    private LerpedFloat scaleLeftRight = LerpedFloat.linear();
    private LerpedFloat rotation = LerpedFloat.angular();
    private double xOrigin;
    private double zOrigin;

    public void init(class_2338 anchor, class_3492 settings, class_238 bounds) {
        int leftRight = settings.method_15114() == class_2415.field_11300 ? -1 : 1;
        int frontBack = settings.method_15114() == class_2415.field_11301 ? -1 : 1;
        this.getScaleFB().chase(0.0, 0.45f, LerpedFloat.Chaser.EXP).startWithValue(frontBack);
        this.getScaleLR().chase(0.0, 0.45f, LerpedFloat.Chaser.EXP).startWithValue(leftRight);
        this.xOrigin = bounds.method_17939() / 2.0;
        this.zOrigin = bounds.method_17941() / 2.0;
        int r = -(settings.method_15113().ordinal() * 90);
        this.rotation.chase(0.0, 0.45f, LerpedFloat.Chaser.EXP).startWithValue(r);
        this.target = this.fromAnchor(anchor);
        this.prevChasingPos = this.chasingPos = class_243.method_24954((class_2382)this.target);
    }

    public void applyTransformations(class_4587 ms, class_243 camera) {
        float pt = AnimationTickHolder.getPartialTicks();
        TransformStack.of(ms).translate(VecHelper.lerp(pt, this.prevChasingPos, this.chasingPos).method_1020(camera));
        class_243 rotationOffset = this.getRotationOffset(true);
        float fb = this.getScaleFB().getValue(pt);
        float lr = this.getScaleLR().getValue(pt);
        float rot = this.rotation.getValue(pt) + (float)(fb < 0.0f && lr < 0.0f ? 180 : 0);
        ms.method_22904(this.xOrigin, 0.0, this.zOrigin);
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).translate(rotationOffset)).rotateYDegrees(rot)).translateBack(rotationOffset);
        ms.method_22905(Math.abs(fb), 1.0f, Math.abs(lr));
        ms.method_22904(-this.xOrigin, 0.0, -this.zOrigin);
    }

    public boolean isFlipped() {
        return this.getMirrorModifier(class_2350.class_2351.field_11048) < 0 != this.getMirrorModifier(class_2350.class_2351.field_11051) < 0;
    }

    public class_243 getRotationOffset(boolean ignoreMirrors) {
        class_243 rotationOffset = class_243.field_1353;
        if ((int)(this.zOrigin * 2.0) % 2 != (int)(this.xOrigin * 2.0) % 2) {
            float zIn;
            boolean xGreaterZ = this.xOrigin > this.zOrigin;
            float xIn = xGreaterZ ? 0.0f : 0.5f;
            float f = zIn = !xGreaterZ ? 0.0f : 0.5f;
            if (!ignoreMirrors) {
                xIn *= (float)this.getMirrorModifier(class_2350.class_2351.field_11048);
                zIn *= (float)this.getMirrorModifier(class_2350.class_2351.field_11051);
            }
            rotationOffset = new class_243((double)xIn, 0.0, (double)zIn);
        }
        return rotationOffset;
    }

    public class_243 toLocalSpace(class_243 vec) {
        float pt = AnimationTickHolder.getPartialTicks();
        class_243 rotationOffset = this.getRotationOffset(true);
        vec = vec.method_1020(VecHelper.lerp(pt, this.prevChasingPos, this.chasingPos));
        vec = vec.method_1023(this.xOrigin + rotationOffset.field_1352, 0.0, this.zOrigin + rotationOffset.field_1350);
        vec = VecHelper.rotate(vec, -this.rotation.getValue(pt), class_2350.class_2351.field_11052);
        vec = vec.method_1031(rotationOffset.field_1352, 0.0, rotationOffset.field_1350);
        vec = vec.method_18805((double)this.getScaleFB().getValue(pt), 1.0, (double)this.getScaleLR().getValue(pt));
        vec = vec.method_1031(this.xOrigin, 0.0, this.zOrigin);
        return vec;
    }

    public class_3492 toSettings() {
        boolean mirrorfb;
        class_3492 settings = new class_3492();
        int i = (int)this.rotation.getChaseTarget();
        boolean mirrorlr = this.getScaleLR().getChaseTarget() < 0.0f;
        boolean bl = mirrorfb = this.getScaleFB().getChaseTarget() < 0.0f;
        if (mirrorlr && mirrorfb) {
            mirrorfb = false;
            mirrorlr = false;
            i += 180;
        }
        if ((i %= 360) < 0) {
            i += 360;
        }
        class_2470 rotation = class_2470.field_11467;
        switch (i) {
            case 90: {
                rotation = class_2470.field_11465;
                break;
            }
            case 180: {
                rotation = class_2470.field_11464;
                break;
            }
            case 270: {
                rotation = class_2470.field_11463;
                break;
            }
        }
        settings.method_15123(rotation);
        if (mirrorfb) {
            settings.method_15125(class_2415.field_11301);
        }
        if (mirrorlr) {
            settings.method_15125(class_2415.field_11300);
        }
        return settings;
    }

    public class_2338 getAnchor() {
        class_243 vec = class_243.field_1353.method_1031(0.5, 0.0, 0.5);
        class_243 rotationOffset = this.getRotationOffset(false);
        vec = vec.method_1023(this.xOrigin, 0.0, this.zOrigin);
        vec = vec.method_1023(rotationOffset.field_1352, 0.0, rotationOffset.field_1350);
        vec = vec.method_18805((double)this.getScaleFB().getChaseTarget(), 1.0, (double)this.getScaleLR().getChaseTarget());
        vec = VecHelper.rotate(vec, this.rotation.getChaseTarget(), class_2350.class_2351.field_11052);
        vec = vec.method_1031(this.xOrigin, 0.0, this.zOrigin);
        vec = vec.method_1031((double)this.target.method_10263(), (double)this.target.method_10264(), (double)this.target.method_10260());
        return class_2338.method_49637((double)vec.field_1352, (double)vec.field_1351, (double)vec.field_1350);
    }

    public class_2338 fromAnchor(class_2338 pos) {
        class_243 vec = class_243.field_1353.method_1031(0.5, 0.0, 0.5);
        class_243 rotationOffset = this.getRotationOffset(false);
        vec = vec.method_1023(this.xOrigin, 0.0, this.zOrigin);
        vec = vec.method_1023(rotationOffset.field_1352, 0.0, rotationOffset.field_1350);
        vec = vec.method_18805((double)this.getScaleFB().getChaseTarget(), 1.0, (double)this.getScaleLR().getChaseTarget());
        vec = VecHelper.rotate(vec, this.rotation.getChaseTarget(), class_2350.class_2351.field_11052);
        vec = vec.method_1031(this.xOrigin, 0.0, this.zOrigin);
        return pos.method_10059((class_2382)class_2338.method_49637((double)vec.field_1352, (double)vec.field_1351, (double)vec.field_1350));
    }

    public int getRotationTarget() {
        return (int)this.rotation.getChaseTarget();
    }

    public int getMirrorModifier(class_2350.class_2351 axis) {
        if (axis == class_2350.class_2351.field_11051) {
            return (int)this.getScaleLR().getChaseTarget();
        }
        return (int)this.getScaleFB().getChaseTarget();
    }

    public float getCurrentRotation() {
        float pt = AnimationTickHolder.getPartialTicks();
        return this.rotation.getValue(pt);
    }

    public void tick() {
        this.prevChasingPos = this.chasingPos;
        this.chasingPos = VecHelper.lerp(0.45f, this.chasingPos, class_243.method_24954((class_2382)this.target));
        this.getScaleLR().tickChaser();
        this.getScaleFB().tickChaser();
        this.rotation.tickChaser();
    }

    public void flip(class_2350.class_2351 axis) {
        if (axis == class_2350.class_2351.field_11048) {
            this.getScaleLR().updateChaseTarget(this.getScaleLR().getChaseTarget() * -1.0f);
        }
        if (axis == class_2350.class_2351.field_11051) {
            this.getScaleFB().updateChaseTarget(this.getScaleFB().getChaseTarget() * -1.0f);
        }
    }

    public void rotate90(boolean clockwise) {
        this.rotation.updateChaseTarget(this.rotation.getChaseTarget() + (float)(clockwise ? -90 : 90));
    }

    public void move(int xIn, int yIn, int zIn) {
        this.moveTo(this.target.method_10069(xIn, yIn, zIn));
    }

    public void startAt(class_2338 pos) {
        this.prevChasingPos = this.chasingPos = class_243.method_24954((class_2382)pos);
        this.moveTo(pos);
    }

    public void moveTo(class_2338 pos) {
        this.target = pos;
    }

    public void moveTo(int xIn, int yIn, int zIn) {
        this.moveTo(new class_2338(xIn, yIn, zIn));
    }

    public LerpedFloat getScaleFB() {
        return this.scaleFrontBack;
    }

    public LerpedFloat getScaleLR() {
        return this.scaleLeftRight;
    }
}

