/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.station;

import com.zurrtum.create.client.AllTrainIcons;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.compat.computercraft.ComputerScreen;
import com.zurrtum.create.client.content.trains.entity.TrainIcon;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import java.lang.ref.WeakReference;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractStationScreen
extends AbstractSimiScreen
implements ComputerScreen.AdditionalRenderer {
    protected AllGuiTextures background;
    protected StationBlockEntity blockEntity;
    protected GlobalStation station;
    private GuiGameElement.GuiBlockStateRenderBuilder renderedItem;
    private GuiGameElement.GuiPartialRenderBuilder renderedFlag;
    protected WeakReference<Train> displayedTrain;
    private IconButton confirmButton;

    public AbstractStationScreen(StationBlockEntity be, GlobalStation station) {
        super((class_2561)be.method_11010().method_26204().method_9518());
        this.blockEntity = be;
        this.station = station;
        this.displayedTrain = new WeakReference<Object>(null);
    }

    @Override
    protected void method_25426() {
        this.renderedFlag = GuiGameElement.partial().scale(2.5f).transform(this::transform).padding(13);
        this.renderedItem = GuiGameElement.of((class_2680)this.blockEntity.method_11010().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false))).rotate(-22.0f, 63.0f, 0.0f).scale(2.5f).padding(17);
        AbstractComputerBehaviour computer = this.blockEntity.getBehaviour(AbstractComputerBehaviour.TYPE);
        if (computer != null && computer.hasAttachedComputer()) {
            this.field_22787.method_1507((class_437)new ComputerScreen(this.field_22785, () -> class_2561.method_43470((String)this.station.name), this, this, computer::hasAttachedComputer));
        }
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        super.method_25426();
        this.method_37067();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::method_25419);
        this.method_37063(this.confirmButton);
        this.addAdditional(this, x, y, this.background);
    }

    @Override
    public void addAdditional(class_437 screen, int x, int y, AllGuiTextures background) {
        screen.method_37063(new ElementWidget(x + background.getWidth() + 25, y + background.getHeight() - 62).showingElement(this.renderedFlag));
        screen.method_37063(new ElementWidget(x + background.getWidth() + 3, y + background.getHeight() - 46).showingElement(this.renderedItem));
    }

    @Override
    public void updateAdditional(float partialTicks) {
        if (this.blockEntity.resolveFlagAngle()) {
            this.renderedFlag.partial(this.getFlag(partialTicks)).tick(this.blockEntity.flag.settled() ? 1.0f : partialTicks);
        } else {
            this.renderedFlag.partial(null);
        }
    }

    public void method_25419() {
        super.method_25419();
        this.renderedFlag.clear();
        this.renderedItem.clear();
    }

    public int getTrainIconWidth(Train train) {
        TrainIcon icon = AllTrainIcons.byType(train.icon);
        List<Carriage> carriages = train.carriages;
        int w = icon.getIconWidth(-1);
        if (carriages.size() == 1) {
            return w;
        }
        for (int i = 1; i < carriages.size(); ++i) {
            if (i == carriages.size() - 1 && train.doubleEnded) {
                w += icon.getIconWidth(-2) + 1;
                break;
            }
            Carriage carriage = carriages.get(i);
            w += icon.getIconWidth(carriage.bogeySpacing) + 1;
        }
        return w;
    }

    @Override
    public void method_25393() {
        super.method_25393();
        AbstractComputerBehaviour computer = this.blockEntity.getBehaviour(AbstractComputerBehaviour.TYPE);
        if (computer != null && computer.hasAttachedComputer()) {
            this.field_22787.method_1507((class_437)new ComputerScreen(this.field_22785, () -> class_2561.method_43470((String)this.station.name), this, this, computer::hasAttachedComputer));
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        this.updateAdditional(partialTicks);
    }

    private void transform(class_4587 ms, float partialTicks) {
        ms.method_22905(1.0f, -1.0f, 1.0f);
        float value = this.blockEntity.flag.getValue(partialTicks);
        float progress = (float)Math.pow(Math.min(value * 5.0f, 1.0f), 2.0);
        if (this.blockEntity.flag.getChaseTarget() > 0.0f && !this.blockEntity.flag.settled() && progress == 1.0f) {
            float wiggleProgress = (value - 0.2f) / 0.8f;
            progress = (float)((double)progress + Math.sin(wiggleProgress * ((float)Math.PI * 2) * 4.0f) / 8.0 / (double)Math.max(1.0f, 8.0f * wiggleProgress));
        }
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).rotateXDegrees(24.0f)).rotateYDegrees(-210.0f)).translate(-0.12f, -0.81f, 0.0f).rotateYDegrees(90.0f)).rotateXDegrees(progress * 90.0f + 270.0f);
    }

    protected abstract PartialModel getFlag(float var1);

    protected Train getImminent() {
        return this.blockEntity.imminentTrain == null ? null : Create.RAILWAYS.trains.get(this.blockEntity.imminentTrain);
    }

    protected boolean trainPresent() {
        return this.blockEntity.trainPresent;
    }
}

