/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.track;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackTargetingBlockItem;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import com.zurrtum.create.infrastructure.packet.c2s.CurvedTrackDestroyPacket;
import com.zurrtum.create.infrastructure.packet.c2s.CurvedTrackSelectionPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class CurvedTrackInteraction {
    static int breakTicks;
    static int breakTimeout;
    static float breakProgress;
    static class_2338 breakPos;

    public static void clientTick(class_310 mc) {
        TrackBlockOutline.BezierPointSelection result = TrackBlockOutline.result;
        class_746 player = mc.field_1724;
        class_638 level = mc.field_1687;
        if (!player.method_31549().field_7476) {
            return;
        }
        if (mc.field_1690.field_1886.method_1434() && result != null) {
            breakPos = result.blockEntity().method_11016();
            class_2680 blockState = level.method_8320(breakPos);
            if (blockState.method_26215()) {
                CurvedTrackInteraction.resetBreakProgress(level, player);
                return;
            }
            if ((float)breakTicks % 4.0f == 0.0f) {
                class_2498 soundtype = blockState.method_26231();
                mc.method_1483().method_4873((class_1113)new class_1109(soundtype.method_10596(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 8.0f, soundtype.method_10599() * 0.5f, level.field_9229, class_2338.method_49638((class_2374)result.vec())));
            }
            boolean creative = player.method_31549().field_7477;
            ++breakTicks;
            breakTimeout = 2;
            float f = creative ? 0.125f : blockState.method_26165((class_1657)player, (class_1922)level, breakPos) / 8.0f;
            class_243 vec = VecHelper.offsetRandomly(result.vec(), level.field_9229, 0.25f);
            level.method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), vec.field_1352, vec.field_1351, vec.field_1350, 0.0, 0.0, 0.0);
            int progress = (int)((breakProgress += f) * 10.0f) - 1;
            level.method_8517(player.method_5628(), breakPos, progress);
            player.method_6104(class_1268.field_5808);
            if (breakProgress >= 1.0f) {
                player.field_3944.method_52787((class_2596)new CurvedTrackDestroyPacket(breakPos, result.loc().curveTarget(), class_2338.method_49638((class_2374)result.vec()), false));
                CurvedTrackInteraction.resetBreakProgress(level, player);
            }
            return;
        }
        if (breakTimeout == 0) {
            return;
        }
        if (--breakTimeout > 0) {
            return;
        }
        CurvedTrackInteraction.resetBreakProgress(level, player);
    }

    private static void resetBreakProgress(class_638 level, class_746 player) {
        if (breakPos != null && level != null) {
            level.method_8517(player.method_5628(), breakPos, -1);
        }
        breakProgress = 0.0f;
        breakTicks = 0;
        breakPos = null;
    }

    public static boolean onClickInput(class_310 mc, boolean attack) {
        TrackBlockOutline.BezierPointSelection result = TrackBlockOutline.result;
        if (result == null) {
            return false;
        }
        class_746 player = mc.field_1724;
        if (player == null) {
            return false;
        }
        class_638 level = mc.field_1687;
        if (level == null) {
            return false;
        }
        if (attack) {
            return true;
        }
        class_1799 heldItem = player.method_6047();
        class_1792 item = heldItem.method_7909();
        if (heldItem.method_31573(AllItemTags.TRACKS)) {
            player.method_7353((class_2561)CreateLang.translateDirect("track.turn_start", new Object[0]).method_27692(class_124.field_1061), true);
            return true;
        }
        if (item instanceof TrackTargetingBlockItem) {
            CurvedTrackInteraction.useOnCurve(player, result);
            return true;
        }
        if (heldItem.method_31574((class_1792)AllItems.WRENCH) && player.method_5715()) {
            player.field_3944.method_52787((class_2596)new CurvedTrackDestroyPacket(result.blockEntity().method_11016(), result.loc().curveTarget(), class_2338.method_49638((class_2374)result.vec()), true));
            CurvedTrackInteraction.resetBreakProgress(level, player);
            return true;
        }
        return false;
    }

    public static void useOnCurve(class_746 player, TrackBlockOutline.BezierPointSelection selection) {
        TrackBlockEntity be = selection.blockEntity();
        BezierTrackPointLocation loc = selection.loc();
        boolean front = player.method_5720().method_1026(selection.direction()) < 0.0;
        player.field_3944.method_52787((class_2596)new CurvedTrackSelectionPacket(be.method_11016(), loc.curveTarget(), front, loc.segment(), player.method_31548().method_67532()));
    }
}

