/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.compile;

import com.zurrtum.create.client.flywheel.backend.Samplers;
import com.zurrtum.create.client.flywheel.backend.compile.core.Compilation;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlProgram;
import java.util.Locale;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public enum ContextShader {
    DEFAULT(null, $ -> {}),
    CRUMBLING("_FLW_CRUMBLING", program -> program.setSamplerBinding("_flw_crumblingTex", Samplers.CRUMBLING)),
    EMBEDDED("FLW_EMBEDDED", $ -> {});

    @Nullable
    private final String define;
    private final Consumer<GlProgram> onLink;

    private ContextShader(String define, Consumer<GlProgram> onLink) {
        this.define = define;
        this.onLink = onLink;
    }

    public void onLink(GlProgram program) {
        this.onLink.accept(program);
    }

    public void onCompile(Compilation comp) {
        if (this.define != null) {
            comp.define(this.define);
        }
    }

    public String nameLowerCase() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

