/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.uniform;

import com.zurrtum.create.client.flywheel.api.backend.RenderContext;
import com.zurrtum.create.client.flywheel.backend.FlwBackendXplat;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.UniformBuffer;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.UniformWriter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_268;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class PlayerUniforms
extends UniformWriter {
    private static final int SIZE = 76;
    static final UniformBuffer BUFFER = new UniformBuffer(3, 76);

    private PlayerUniforms() {
    }

    public static void update(RenderContext context) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            BUFFER.clear();
            return;
        }
        long ptr = BUFFER.ptr();
        class_640 info = player.method_3123();
        class_243 eyePos = player.method_5836(context.partialTick());
        ptr = PlayerUniforms.writeVec3(ptr, (float)eyePos.field_1352, (float)eyePos.field_1351, (float)eyePos.field_1350);
        ptr = PlayerUniforms.writeTeamColor(ptr, info == null ? null : info.method_2955());
        ptr = PlayerUniforms.writeEyeBrightness(ptr, player);
        ptr = PlayerUniforms.writeHeldLight(ptr, player);
        ptr = PlayerUniforms.writeEyeIn(ptr, player);
        ptr = PlayerUniforms.writeInt(ptr, player.method_18276() ? 1 : 0);
        ptr = PlayerUniforms.writeInt(ptr, player.method_6113() ? 1 : 0);
        ptr = PlayerUniforms.writeInt(ptr, player.method_5681() ? 1 : 0);
        ptr = PlayerUniforms.writeInt(ptr, player.method_6128() ? 1 : 0);
        ptr = PlayerUniforms.writeInt(ptr, player.method_5715() ? 1 : 0);
        ptr = PlayerUniforms.writeInt(ptr, info == null ? 0 : info.method_2958().method_8379());
        BUFFER.markDirty();
    }

    private static long writeTeamColor(long ptr, @Nullable class_268 team) {
        if (team != null) {
            Integer color = team.method_1202().method_532();
            if (color != null) {
                int red = class_9848.method_61327((int)color);
                int green = class_9848.method_61329((int)color);
                int blue = class_9848.method_61331((int)color);
                return PlayerUniforms.writeVec4(ptr, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f);
            }
            return PlayerUniforms.writeVec4(ptr, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        return PlayerUniforms.writeVec4(ptr, 1.0f, 1.0f, 1.0f, 0.0f);
    }

    private static long writeEyeBrightness(long ptr, class_746 player) {
        class_1937 level = player.method_73183();
        int blockBrightness = level.method_8314(class_1944.field_9282, player.method_24515());
        int skyBrightness = level.method_8314(class_1944.field_9284, player.method_24515());
        int maxBrightness = 15;
        return PlayerUniforms.writeVec2(ptr, (float)blockBrightness / (float)maxBrightness, (float)skyBrightness / (float)maxBrightness);
    }

    private static long writeHeldLight(long ptr, class_746 player) {
        int heldLight = 0;
        for (class_1268 hand : class_1268.values()) {
            class_1747 blockItem;
            class_2248 block;
            int blockLight;
            class_1792 handItem = player.method_5998(hand).method_7909();
            if (!(handItem instanceof class_1747) || heldLight >= (blockLight = FlwBackendXplat.INSTANCE.getLightEmission((block = (blockItem = (class_1747)handItem).method_7711()).method_9564(), (class_1922)player.method_73183(), player.method_24515()))) continue;
            heldLight = blockLight;
        }
        return PlayerUniforms.writeFloat(ptr, (float)heldLight / 15.0f);
    }

    private static long writeEyeIn(long ptr, class_746 player) {
        class_1937 level = player.method_73183();
        class_243 eyePos = player.method_33571();
        class_2338 blockPos = class_2338.method_49638((class_2374)eyePos);
        return PlayerUniforms.writeInFluidAndBlock(ptr, level, blockPos, eyePos);
    }
}

