/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.memory;

import com.zurrtum.create.client.flywheel.lib.internal.FlwLibLink;
import com.zurrtum.create.client.flywheel.lib.memory.AbstractMemoryBlockImpl;
import com.zurrtum.create.client.flywheel.lib.memory.FlwMemoryTracker;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import com.zurrtum.create.client.flywheel.lib.util.StringUtil;
import java.lang.ref.Cleaner;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
class DebugMemoryBlockImpl
extends AbstractMemoryBlockImpl {
    final Cleaner cleaner;
    final CleaningAction cleaningAction;
    final Cleaner.Cleanable cleanable;

    DebugMemoryBlockImpl(long ptr, long size, Cleaner cleaner, int skipFrames) {
        super(ptr, size);
        this.cleaner = cleaner;
        this.cleaningAction = new CleaningAction(ptr, size, DebugMemoryBlockImpl.getStackTrace(skipFrames + 1));
        this.cleanable = cleaner.register(this, this.cleaningAction);
    }

    @Override
    public boolean isTracked() {
        return false;
    }

    @Override
    void freeInner() {
        super.freeInner();
        this.cleaningAction.freed = true;
        this.cleanable.clean();
    }

    @Override
    public MemoryBlock realloc(long size) {
        this.assertAllocated();
        DebugMemoryBlockImpl block = new DebugMemoryBlockImpl(FlwMemoryTracker.realloc(this.ptr, size), size, this.cleaner, 1);
        FlwMemoryTracker._allocCpuMemory(block.size());
        this.freeInner();
        return block;
    }

    static StackWalker.StackFrame[] getStackTrace(int skipFrames) {
        return StackWalker.getInstance().walk(s -> (StackWalker.StackFrame[])s.skip(skipFrames + 1).toArray(StackWalker.StackFrame[]::new));
    }

    static MemoryBlock malloc(long size) {
        DebugMemoryBlockImpl block = new DebugMemoryBlockImpl(FlwMemoryTracker.malloc(size), size, CLEANER, 2);
        FlwMemoryTracker._allocCpuMemory(block.size());
        return block;
    }

    static MemoryBlock calloc(long num, long size) {
        DebugMemoryBlockImpl block = new DebugMemoryBlockImpl(FlwMemoryTracker.calloc(num, size), num * size, CLEANER, 2);
        FlwMemoryTracker._allocCpuMemory(block.size());
        return block;
    }

    @Environment(value=EnvType.CLIENT)
    static class CleaningAction
    implements Runnable {
        final long ptr;
        final long size;
        final StackWalker.StackFrame[] allocationSite;
        boolean freed;

        CleaningAction(long ptr, long size, StackWalker.StackFrame[] allocationSite) {
            this.ptr = ptr;
            this.size = size;
            this.allocationSite = allocationSite;
        }

        @Override
        public void run() {
            if (!this.freed) {
                StringBuilder builder = new StringBuilder();
                builder.append("Reclaimed ").append(this.size).append(" bytes at address ").append(StringUtil.formatAddress(this.ptr)).append(" that were leaked from allocation site:");
                for (StackWalker.StackFrame frame : this.allocationSite) {
                    builder.append("\n\t");
                    builder.append(frame);
                }
                FlwLibLink.INSTANCE.getLogger().warn(builder.toString());
                FlwMemoryTracker.free(this.ptr);
                FlwMemoryTracker._freeCpuMemory(this.size);
            }
        }
    }
}

