/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model;

import com.zurrtum.create.client.flywheel.api.material.CardinalLightingMode;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.model.Mesh;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.vertex.VertexList;
import com.zurrtum.create.client.flywheel.lib.material.Materials;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import com.zurrtum.create.client.flywheel.lib.vertex.PosVertexView;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11515;
import net.minecraft.class_1921;
import net.minecraft.class_4722;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public final class ModelUtil {
    private static final float BOUNDING_SPHERE_EPSILON = 1.0E-4f;
    private static final Material[] CHUNK_MATERIALS = new Material[20];
    private static final Map<class_1921, Material> ITEM_CHUNK_MATERIALS = new IdentityHashMap<class_1921, Material>();

    private ModelUtil() {
    }

    public static Material getMaterial(class_11515 chunkRenderType, boolean shaded, boolean ambientOcclusion) {
        int materialIdx = chunkRenderType.ordinal() * 4;
        if (ambientOcclusion) {
            ++materialIdx;
        }
        if (shaded) {
            materialIdx += 2;
        }
        return CHUNK_MATERIALS[materialIdx];
    }

    @Nullable
    public static Material getItemMaterial(class_1921 renderType) {
        return ITEM_CHUNK_MATERIALS.get(renderType);
    }

    public static int computeTotalVertexCount(Iterable<Mesh> meshes) {
        int vertexCount = 0;
        for (Mesh mesh : meshes) {
            vertexCount += mesh.vertexCount();
        }
        return vertexCount;
    }

    public static Vector4f computeBoundingSphere(Collection<Model.ConfiguredMesh> meshes) {
        return ModelUtil.computeBoundingSphere(meshes.stream().map(Model.ConfiguredMesh::mesh).toList());
    }

    public static Vector4f computeBoundingSphere(Iterable<Mesh> meshes) {
        int vertexCount = ModelUtil.computeTotalVertexCount(meshes);
        MemoryBlock block = MemoryBlock.malloc((long)vertexCount * 12L);
        PosVertexView vertexList = new PosVertexView();
        int baseVertex = 0;
        for (Mesh mesh : meshes) {
            vertexList.ptr(block.ptr() + (long)baseVertex * 12L);
            vertexList.vertexCount(mesh.vertexCount());
            mesh.write(vertexList);
            baseVertex += mesh.vertexCount();
        }
        vertexList.ptr(block.ptr());
        vertexList.vertexCount(vertexCount);
        Vector4f sphere = ModelUtil.computeBoundingSphere(vertexList);
        block.free();
        return sphere;
    }

    public static Vector4f computeBoundingSphere(VertexList vertexList) {
        Vector3f center = ModelUtil.computeCenterOfAABBContaining(vertexList);
        float radius = ModelUtil.computeMaxDistanceTo(vertexList, center) + 1.0E-4f;
        return new Vector4f((Vector3fc)center, radius);
    }

    private static float computeMaxDistanceTo(VertexList vertexList, Vector3f pos) {
        float farthestDistanceSquared = -1.0f;
        for (int i = 0; i < vertexList.vertexCount(); ++i) {
            float distanceSquared = pos.distanceSquared(vertexList.x(i), vertexList.y(i), vertexList.z(i));
            if (!(distanceSquared > farthestDistanceSquared)) continue;
            farthestDistanceSquared = distanceSquared;
        }
        return (float)Math.sqrt(farthestDistanceSquared);
    }

    private static Vector3f computeCenterOfAABBContaining(VertexList vertexList) {
        Vector3f min = new Vector3f(Float.MAX_VALUE);
        Vector3f max = new Vector3f(Float.MIN_VALUE);
        for (int i = 0; i < vertexList.vertexCount(); ++i) {
            float x = vertexList.x(i);
            float y = vertexList.y(i);
            float z = vertexList.z(i);
            min.x = Math.min(min.x, x);
            min.y = Math.min(min.y, y);
            min.z = Math.min(min.z, z);
            max.x = Math.max(max.x, x);
            max.y = Math.max(max.y, y);
            max.z = Math.max(max.z, z);
        }
        return min.add((Vector3fc)max).mul(0.5f);
    }

    static {
        Material[] baseChunkMaterials = new Material[]{Materials.SOLID_BLOCK, Materials.CUTOUT_MIPPED_BLOCK, Materials.CUTOUT_BLOCK, Materials.TRANSLUCENT_BLOCK, Materials.TRIPWIRE_BLOCK};
        int size = baseChunkMaterials.length;
        for (int chunkLayerIdx = 0; chunkLayerIdx < size; ++chunkLayerIdx) {
            int baseMaterialIdx = chunkLayerIdx * 4;
            Material baseChunkMaterial = baseChunkMaterials[chunkLayerIdx];
            ModelUtil.CHUNK_MATERIALS[baseMaterialIdx] = SimpleMaterial.builderOf(baseChunkMaterial).cardinalLightingMode(CardinalLightingMode.OFF).ambientOcclusion(false).build();
            ModelUtil.CHUNK_MATERIALS[baseMaterialIdx + 1] = SimpleMaterial.builderOf(baseChunkMaterial).cardinalLightingMode(CardinalLightingMode.OFF).build();
            ModelUtil.CHUNK_MATERIALS[baseMaterialIdx + 2] = SimpleMaterial.builderOf(baseChunkMaterial).ambientOcclusion(false).build();
            ModelUtil.CHUNK_MATERIALS[baseMaterialIdx + 3] = baseChunkMaterial;
        }
        ITEM_CHUNK_MATERIALS.put(class_1921.method_23577(), CHUNK_MATERIALS[2]);
        ITEM_CHUNK_MATERIALS.put(class_1921.method_23579(), CHUNK_MATERIALS[6]);
        ITEM_CHUNK_MATERIALS.put(class_1921.method_23581(), CHUNK_MATERIALS[10]);
        ITEM_CHUNK_MATERIALS.put(class_1921.method_29380(), CHUNK_MATERIALS[14]);
        ITEM_CHUNK_MATERIALS.put(class_1921.method_29997(), CHUNK_MATERIALS[18]);
        ITEM_CHUNK_MATERIALS.put(class_4722.method_24074(), CHUNK_MATERIALS[7]);
        ITEM_CHUNK_MATERIALS.put(class_4722.method_24073(), CHUNK_MATERIALS[3]);
        ITEM_CHUNK_MATERIALS.put(class_4722.method_29382(), Materials.TRANSLUCENT_ENTITY);
        ITEM_CHUNK_MATERIALS.put(class_1921.method_23590(), Materials.GLINT);
        ITEM_CHUNK_MATERIALS.put(class_1921.method_30676(), Materials.TRANSLUCENT_GLINT);
        ITEM_CHUNK_MATERIALS.put(class_1921.method_23591(), Materials.GLINT_ENTITY);
    }
}

