/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.lib.model.SimpleQuadMesh;
import com.zurrtum.create.client.flywheel.lib.model.baked.ByteBufferBuilderStack;
import com.zurrtum.create.client.flywheel.lib.model.baked.MeshEmitterManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.MeshHelper;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11515;
import net.minecraft.class_287;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.UnknownNullability;

@Environment(value=EnvType.CLIENT)
class MeshEmitter {
    private static final int INITIAL_CAPACITY = 1;
    private final MeshEmitterManager<?> manager;
    private final ByteBufferBuilderStack byteBufferBuilderStack;
    private final class_11515 renderType;
    private Material @UnknownNullability [] materials = new Material[1];
    private class_287 @UnknownNullability [] bufferBuilders = new class_287[1];
    private int numBufferBuildersPopulated = 0;
    private int currentIndex = 0;

    MeshEmitter(MeshEmitterManager<?> manager, ByteBufferBuilderStack byteBufferBuilderStack, class_11515 renderType) {
        this.manager = manager;
        this.byteBufferBuilderStack = byteBufferBuilderStack;
        this.renderType = renderType;
    }

    public void prepareForBlock() {
        this.currentIndex = 0;
    }

    public void end(ImmutableList.Builder<Model.ConfiguredMesh> out) {
        for (int index = 0; index < this.numBufferBuildersPopulated; ++index) {
            class_9801 renderedBuffer = this.bufferBuilders[index].method_60794();
            if (renderedBuffer == null) continue;
            Material material = this.materials[index];
            SimpleQuadMesh mesh = MeshHelper.blockVerticesToMesh(renderedBuffer, "source=ModelBuilder,material=" + String.valueOf(material));
            out.add((Object)new Model.ConfiguredMesh(material, mesh));
            renderedBuffer.close();
        }
        Arrays.fill(this.bufferBuilders, 0, this.numBufferBuildersPopulated, null);
        Arrays.fill(this.materials, 0, this.numBufferBuildersPopulated, null);
        this.currentIndex = 0;
        this.numBufferBuildersPopulated = 0;
    }

    public class_287 getBuffer(boolean shade, boolean ao) {
        Material material = this.manager.getMaterial(this.renderType, shade, ao);
        return material != null ? this.getBuffer(material) : null;
    }

    public class_287 getBuffer(Material material) {
        while (this.currentIndex < this.numBufferBuildersPopulated) {
            if (material.equals(this.materials[this.currentIndex])) {
                return this.bufferBuilders[this.currentIndex];
            }
            ++this.currentIndex;
        }
        if (this.currentIndex >= this.materials.length) {
            this.resize(this.materials.length * 2);
        }
        class_9799 byteBufferBuilder = this.byteBufferBuilderStack.nextOrCreate();
        RenderPipeline pipeline = this.renderType.method_72020();
        class_287 bufferBuilder = new class_287(byteBufferBuilder, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
        this.materials[this.currentIndex] = material;
        this.bufferBuilders[this.currentIndex] = bufferBuilder;
        ++this.numBufferBuildersPopulated;
        return bufferBuilder;
    }

    private void resize(int capacity) {
        class_287[] newBufferBuilders = new class_287[capacity];
        Material[] newMaterials = new Material[capacity];
        System.arraycopy(this.bufferBuilders, 0, newBufferBuilders, 0, this.numBufferBuildersPopulated);
        System.arraycopy(this.materials, 0, newMaterials, 0, this.numBufferBuildersPopulated);
        this.bufferBuilders = newBufferBuilders;
        this.materials = newMaterials;
    }
}

