/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.task;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.flywheel.api.task.Plan;
import com.zurrtum.create.client.flywheel.api.task.TaskExecutor;
import com.zurrtum.create.client.flywheel.lib.task.SimplyComposedPlan;
import com.zurrtum.create.client.flywheel.lib.task.Synchronizer;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public record NestedPlan<C>(List<Plan<C>> parallelPlans) implements SimplyComposedPlan<C>
{
    @SafeVarargs
    public static <C> NestedPlan<C> of(Plan<C> ... plans) {
        return new NestedPlan<C>(ImmutableList.copyOf((Object[])plans));
    }

    @Override
    public void execute(TaskExecutor taskExecutor, C context, Runnable onCompletion) {
        if (this.parallelPlans.isEmpty()) {
            onCompletion.run();
            return;
        }
        int size = this.parallelPlans.size();
        if (size == 1) {
            this.parallelPlans.get(0).execute(taskExecutor, context, onCompletion);
            return;
        }
        Synchronizer wait = new Synchronizer(size, onCompletion);
        for (Plan<C> plan : this.parallelPlans) {
            plan.execute(taskExecutor, context, wait);
        }
    }

    @Override
    public Plan<C> and(Plan<C> plan) {
        return new NestedPlan<C>(ImmutableList.builder().addAll(this.parallelPlans).add(plan).build());
    }
}

