/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.transform;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_7833;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public interface Rotate<Self extends Rotate<Self>> {
    public Self rotate(Quaternionfc var1);

    default public Self rotate(AxisAngle4f axisAngle) {
        return this.rotate((Quaternionfc)new Quaternionf(axisAngle));
    }

    default public Self rotate(float radians, float axisX, float axisY, float axisZ) {
        if (radians == 0.0f) {
            return this.self();
        }
        return this.rotate((Quaternionfc)new Quaternionf().setAngleAxis(radians, axisX, axisY, axisZ));
    }

    default public Self rotate(float radians, class_7833 axis) {
        if (radians == 0.0f) {
            return this.self();
        }
        return this.rotate((Quaternionfc)axis.rotation(radians));
    }

    default public Self rotate(float radians, Vector3fc axis) {
        return this.rotate(radians, axis.x(), axis.y(), axis.z());
    }

    default public Self rotate(float radians, class_2350 axis) {
        return this.rotate(radians, axis.method_10148(), axis.method_10164(), axis.method_10165());
    }

    default public Self rotate(float radians, class_2350.class_2351 axis) {
        return this.rotate(radians, class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056));
    }

    default public Self rotateDegrees(float degrees, float axisX, float axisY, float axisZ) {
        return this.rotate((float)Math.PI / 180 * degrees, axisX, axisY, axisZ);
    }

    default public Self rotateDegrees(float degrees, class_7833 axis) {
        return this.rotate((float)Math.PI / 180 * degrees, axis);
    }

    default public Self rotateDegrees(float degrees, Vector3fc axis) {
        return this.rotate((float)Math.PI / 180 * degrees, axis);
    }

    default public Self rotateDegrees(float degrees, class_2350 axis) {
        return this.rotate((float)Math.PI / 180 * degrees, axis);
    }

    default public Self rotateDegrees(float degrees, class_2350.class_2351 axis) {
        return this.rotate((float)Math.PI / 180 * degrees, axis);
    }

    default public Self rotateX(float radians) {
        return this.rotate(radians, class_7833.field_40714);
    }

    default public Self rotateY(float radians) {
        return this.rotate(radians, class_7833.field_40716);
    }

    default public Self rotateZ(float radians) {
        return this.rotate(radians, class_7833.field_40718);
    }

    default public Self rotateXDegrees(float degrees) {
        return this.rotateX((float)Math.PI / 180 * degrees);
    }

    default public Self rotateYDegrees(float degrees) {
        return this.rotateY((float)Math.PI / 180 * degrees);
    }

    default public Self rotateZDegrees(float degrees) {
        return this.rotateZ((float)Math.PI / 180 * degrees);
    }

    default public Self rotateToFace(class_2350 facing) {
        return (Self)(switch (facing) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> (Rotate)this.rotateXDegrees(-90.0f);
            case class_2350.field_11036 -> (Rotate)this.rotateXDegrees(90.0f);
            case class_2350.field_11043 -> (Rotate)this.self();
            case class_2350.field_11035 -> (Rotate)this.rotateYDegrees(180.0f);
            case class_2350.field_11039 -> (Rotate)this.rotateYDegrees(90.0f);
            case class_2350.field_11034 -> (Rotate)this.rotateYDegrees(270.0f);
        });
    }

    default public Self rotateTo(float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        return this.rotate((Quaternionfc)new Quaternionf().rotationTo(fromX, fromY, fromZ, toX, toY, toZ));
    }

    default public Self rotateTo(Vector3fc from, Vector3fc to) {
        return this.rotateTo(from.x(), from.y(), from.z(), to.x(), to.y(), to.z());
    }

    default public Self rotateTo(class_2350 from, class_2350 to) {
        return this.rotateTo(from.method_10148(), from.method_10164(), from.method_10165(), to.method_10148(), to.method_10164(), to.method_10165());
    }

    default public Self self() {
        return (Self)this;
    }
}

