/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxRenderer;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class FilteringRenderer {
    public static void tick(class_310 mc) {
        List<FilteringBehaviour<?>> behaviours;
        class_239 target = mc.field_1765;
        if (!(target instanceof class_3965)) {
            return;
        }
        class_3965 result = (class_3965)target;
        class_638 world = mc.field_1687;
        class_2338 pos = result.method_17777();
        class_2680 state = world.method_8320(pos);
        if (mc.field_1724.method_5715()) {
            return;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity sbe = (SmartBlockEntity)class_25862;
        class_1799 mainhandItem = mc.field_1724.method_5998(class_1268.field_5808);
        if (sbe instanceof FactoryPanelBlockEntity) {
            FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)sbe;
            behaviours = FactoryPanelBehaviour.allBehaviours(fpbe);
        } else {
            FilteringBehaviour<Object> behaviour = sbe.getBehaviour(FilteringBehaviour.TYPE);
            if (behaviour instanceof SidedFilteringBehaviour) {
                SidedFilteringBehaviour sidedBehaviour = (SidedFilteringBehaviour)behaviour;
                behaviour = sidedBehaviour.get(result.method_17780());
            }
            if (behaviour == null) {
                return;
            }
            behaviours = List.of(behaviour);
        }
        for (FilteringBehaviour<Object> behaviour : behaviours) {
            if (!behaviour.isActive()) continue;
            if (behaviour.slotPositioning instanceof ValueBoxTransform.Sided) {
                ((ValueBoxTransform.Sided)behaviour.slotPositioning).fromSide(result.method_17780());
            }
            if (!behaviour.slotPositioning.shouldRender(state) || !behaviour.mayInteract((class_1657)mc.field_1724)) continue;
            class_1799 filter = behaviour.getFilter();
            boolean isFilterSlotted = filter.method_7909() instanceof FilterItem;
            boolean showCount = behaviour.isCountVisible();
            class_5250 label = behaviour.getLabel();
            boolean hit = behaviour.slotPositioning.testHit((class_1936)world, pos, state, target.method_17784().method_1020(class_243.method_24954((class_2382)pos)));
            class_238 emptyBB = new class_238(class_243.field_1353, class_243.field_1353);
            class_238 bb = isFilterSlotted ? emptyBB.method_1009((double)0.45f, (double)0.31f, (double)0.2f) : emptyBB.method_1014(0.25);
            ValueBox.ItemValueBox box = new ValueBox.ItemValueBox((class_2561)label, bb, pos, filter, behaviour.getCountLabelForValueBox());
            box.passive(!hit || behaviour.bypassesInput(mainhandItem));
            Outliner.getInstance().showOutline(Pair.of("filter" + behaviour.netId(), pos), box.transform(behaviour.slotPositioning)).lineWidth(0.015625f).withFaceTexture(hit ? AllSpecialTextures.THIN_CHECKERED : null).highlightFace(result.method_17780());
            if (!hit) continue;
            ArrayList<class_5250> tip = new ArrayList<class_5250>();
            tip.add(label.method_27661());
            tip.add(behaviour.getTip());
            if (showCount) {
                tip.add(behaviour.getAmountTip());
            }
            Create.VALUE_SETTINGS_HANDLER.showHoverTip(mc, tip);
        }
    }

    @Nullable
    public static FilterRenderState getFilterRenderState(SmartBlockEntity be, class_2680 blockState, class_10442 itemModelManager, double distance) {
        if (be instanceof FactoryPanelBlockEntity) {
            ArrayList<SingleFilterRenderState> list = null;
            int count = 0;
            boolean check = distance != -1.0;
            for (BlockEntityBehaviour<?> behaviour : be.getAllBehaviours()) {
                if (!(behaviour instanceof FactoryPanelBehaviour)) continue;
                FactoryPanelBehaviour factoryPanelBehaviour = (FactoryPanelBehaviour)behaviour;
                if (factoryPanelBehaviour.behaviour != null && factoryPanelBehaviour.isActive()) {
                    if (check) {
                        if (FilteringRenderer.isOutOfRange(factoryPanelBehaviour, distance)) {
                            return null;
                        }
                        check = false;
                    }
                    class_1799 filter = factoryPanelBehaviour.getFilter();
                    ValueBoxTransform slotPositioning = factoryPanelBehaviour.getSlotPositioning();
                    if (!filter.method_7960() && slotPositioning.shouldRender(blockState)) {
                        if (list == null) {
                            list = new ArrayList<SingleFilterRenderState>(4);
                        }
                        list.add(SingleFilterRenderState.create(slotPositioning, itemModelManager, filter, be.method_10997()));
                    }
                }
                if (++count != 4) continue;
                break;
            }
            return list == null ? null : new FactoryPanelRenderState(list);
        }
        FilteringBehaviour<?> behaviour = be.getBehaviour(FilteringBehaviour.TYPE);
        if (behaviour == null) {
            return null;
        }
        if (!(be.isVirtual() || behaviour.behaviour != null && behaviour.isActive() && !FilteringRenderer.isOutOfRange(behaviour, distance))) {
            return null;
        }
        if (behaviour instanceof SidedFilteringBehaviour) {
            SidedFilteringBehaviour sidedFilteringBehaviour = (SidedFilteringBehaviour)behaviour;
            return SidedFilterRenderState.create(sidedFilteringBehaviour, blockState, itemModelManager, be.method_10997());
        }
        class_1799 filter = behaviour.getFilter();
        if (filter.method_7960()) {
            return null;
        }
        ValueBoxTransform slotPositioning = behaviour.getSlotPositioning();
        if (slotPositioning instanceof ValueBoxTransform.Sided) {
            ValueBoxTransform.Sided sided = (ValueBoxTransform.Sided)slotPositioning;
            return SidedSingleFilterRenderState.create(sided, blockState, itemModelManager, filter, be.method_10997());
        }
        return SingleFilterRenderState.create(slotPositioning, itemModelManager, filter, be.method_10997());
    }

    private static boolean isOutOfRange(FilteringBehaviour<?> behaviour, double distance) {
        if (distance == -1.0) {
            return false;
        }
        float max = behaviour.getRenderDistance();
        return (double)(max * max) < distance;
    }

    @Environment(value=EnvType.CLIENT)
    public record SingleFilterRenderState(ValueBoxTransform slotPositioning, class_10444 state, float offset) implements FilterRenderState
    {
        public static SingleFilterRenderState create(ValueBoxTransform slotPositioning, class_10442 itemModelManager, class_1799 stack, class_1937 world) {
            class_10444 renderState = new class_10444();
            renderState.field_55337 = class_811.field_4319;
            itemModelManager.method_65596(renderState, stack, class_811.field_4319, world, null, 0);
            return new SingleFilterRenderState(slotPositioning, renderState, ValueBoxRenderer.customZOffset(stack.method_7909()));
        }

        @Override
        public void render(class_2680 blockState, class_11659 queue, class_4587 ms, int light) {
            ms.method_22903();
            this.slotPositioning.transform(blockState, ms);
            ValueBoxRenderer.renderItemIntoValueBox(this.state, queue, ms, light, this.offset);
            ms.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record FactoryPanelRenderState(List<SingleFilterRenderState> states) implements FilterRenderState
    {
        @Override
        public void render(class_2680 blockState, class_11659 queue, class_4587 ms, int light) {
            for (SingleFilterRenderState state : this.states) {
                state.render(blockState, queue, ms, light);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record SidedFilterRenderState(ValueBoxTransform.Sided slotPositioning, class_2350 side, List<BoxRenderState> boxes) implements FilterRenderState
    {
        @Nullable
        public static FilterRenderState create(SidedFilteringBehaviour behaviour, class_2680 blockState, class_10442 itemModelManager, class_1937 world) {
            boolean flat = blockState.method_27852((class_2248)AllBlocks.CONTRAPTION_CONTROLS);
            ValueBoxTransform.Sided sided = behaviour.getSlotPositioning();
            ArrayList<BoxRenderState> boxes = new ArrayList<BoxRenderState>();
            class_2350 side = sided.getSide();
            for (class_2350 direction : Iterate.directions) {
                class_1799 filter = behaviour.getFilter(direction);
                if (filter.method_7960()) continue;
                sided.fromSide(direction);
                if (!sided.shouldRender(blockState)) continue;
                class_10444 renderState = new class_10444();
                if (flat) {
                    renderState.field_55337 = class_811.field_4317;
                    itemModelManager.method_65596(renderState, filter, renderState.field_55337, world, null, 0);
                    boxes.add(new FlatBoxState(direction, renderState));
                    continue;
                }
                renderState.field_55337 = class_811.field_4319;
                itemModelManager.method_65596(renderState, filter, renderState.field_55337, world, null, 0);
                boxes.add(new BoxState(direction, renderState, ValueBoxRenderer.customZOffset(filter.method_7909())));
            }
            sided.fromSide(side);
            return boxes.isEmpty() ? null : new SidedFilterRenderState(sided, side, boxes);
        }

        @Override
        public void render(class_2680 blockState, class_11659 queue, class_4587 ms, int light) {
            for (BoxRenderState box : this.boxes) {
                ms.method_22903();
                this.slotPositioning.fromSide(box.side());
                this.slotPositioning.transform(blockState, ms);
                box.render(queue, ms, light);
                ms.method_22909();
            }
            this.slotPositioning.fromSide(this.side);
        }

        @Environment(value=EnvType.CLIENT)
        record FlatBoxState(class_2350 side, class_10444 state) implements BoxRenderState
        {
            @Override
            public void render(class_11659 queue, class_4587 ms, int light) {
                ValueBoxRenderer.renderFlatItemIntoValueBox(this.state, queue, ms, light);
            }
        }

        @Environment(value=EnvType.CLIENT)
        record BoxState(class_2350 side, class_10444 state, float offset) implements BoxRenderState
        {
            @Override
            public void render(class_11659 queue, class_4587 ms, int light) {
                ValueBoxRenderer.renderItemIntoValueBox(this.state, queue, ms, light, this.offset);
            }
        }

        @Environment(value=EnvType.CLIENT)
        public static interface BoxRenderState {
            public class_2350 side();

            public void render(class_11659 var1, class_4587 var2, int var3);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface FilterRenderState {
        public void render(class_2680 var1, class_11659 var2, class_4587 var3, int var4);
    }

    @Environment(value=EnvType.CLIENT)
    public record SidedSingleFilterRenderState(ValueBoxTransform.Sided sided, class_2350 side, class_10444 state, Float offset, List<class_2350> sides) implements FilterRenderState
    {
        public static SidedSingleFilterRenderState create(ValueBoxTransform.Sided sided, class_2680 blockState, class_10442 itemModelManager, class_1799 filter, class_1937 world) {
            Float offset;
            class_10444 renderState = new class_10444();
            if (blockState.method_27852((class_2248)AllBlocks.CONTRAPTION_CONTROLS)) {
                renderState.field_55337 = class_811.field_4317;
                offset = null;
            } else {
                renderState.field_55337 = class_811.field_4319;
                offset = Float.valueOf(ValueBoxRenderer.customZOffset(filter.method_7909()));
            }
            itemModelManager.method_65596(renderState, filter, renderState.field_55337, world, null, 0);
            class_2350 side = sided.getSide();
            ArrayList<class_2350> sides = new ArrayList<class_2350>();
            for (class_2350 direction : Iterate.directions) {
                sided.fromSide(direction);
                if (!sided.shouldRender(blockState)) continue;
                sides.add(direction);
            }
            sided.fromSide(side);
            return new SidedSingleFilterRenderState(sided, side, renderState, offset, sides);
        }

        @Override
        public void render(class_2680 blockState, class_11659 queue, class_4587 ms, int light) {
            boolean flat = this.offset == null;
            for (class_2350 side : this.sides) {
                ms.method_22903();
                this.sided.fromSide(side);
                this.sided.transform(blockState, ms);
                if (flat) {
                    ValueBoxRenderer.renderFlatItemIntoValueBox(this.state, queue, ms, light);
                } else {
                    ValueBoxRenderer.renderItemIntoValueBox(this.state, queue, ms, light, this.offset.floatValue());
                }
                ms.method_22909();
            }
            this.sided.fromSide(this.side);
        }
    }
}

