/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.equipment.extendoGrip.ExtendoGripRenderHandler;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10515;
import net.minecraft.class_10526;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_11566;
import net.minecraft.class_11659;
import net.minecraft.class_11890;
import net.minecraft.class_1306;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ExtendoGripModel
implements class_10439,
class_10515<RenderData> {
    public static final class_2960 ID = class_2960.method_60655((String)"create", (String)"model/extendo_grip");
    public static final class_2960 ITEM_ID = class_2960.method_60655((String)"create", (String)"item/extendo_grip/item");
    public static final class_2960 COG_ID = class_2960.method_60655((String)"create", (String)"item/extendo_grip/cog");
    public static final class_2960 THIN_SHORT_ID = class_2960.method_60655((String)"create", (String)"item/extendo_grip/thin_short");
    public static final class_2960 WIDE_SHORT_ID = class_2960.method_60655((String)"create", (String)"item/extendo_grip/wide_short");
    public static final class_2960 THIN_LONG_ID = class_2960.method_60655((String)"create", (String)"item/extendo_grip/thin_long");
    public static final class_2960 WIDE_LONG_ID = class_2960.method_60655((String)"create", (String)"item/extendo_grip/wide_long");
    public static final class_2960 DEPLOYER_HAND_POINTING = class_2960.method_60655((String)"create", (String)"block/deployer/hand_pointing");
    public static final class_2960 DEPLOYER_HAND_PUNCHING = class_2960.method_60655((String)"create", (String)"block/deployer/hand_punching");
    public static final class_2960 DEPLOYER_HAND_HOLDING = class_2960.method_60655((String)"create", (String)"block/deployer/hand_holding");
    private final class_1921 layer = class_4722.method_29382();
    private final int[] tints = new int[0];
    private final class_10809 settings;
    private final Supplier<Vector3f[]> vector;
    private final List<class_777> item;
    private final List<class_777> cog;
    private final List<class_777> thinShort;
    private final List<class_777> wideShort;
    private final List<class_777> thinLong;
    private final List<class_777> wideLong;
    private final List<class_777> pointing;
    private final List<class_777> punching;
    private final List<class_777> holding;

    public ExtendoGripModel(class_10809 settings, List<class_777> item, List<class_777> cog, List<class_777> thinShort, List<class_777> wideShort, List<class_777> thinLong, List<class_777> wideLong, List<class_777> pointing, List<class_777> punching, List<class_777> holding) {
        this.settings = settings;
        this.item = item;
        this.vector = Suppliers.memoize(() -> class_10430.method_67990((List)item));
        this.cog = cog;
        this.thinShort = thinShort;
        this.wideShort = wideShort;
        this.thinLong = thinLong;
        this.wideLong = wideLong;
        this.pointing = pointing;
        this.punching = punching;
        this.holding = holding;
    }

    public void method_65584(class_10444 state, class_1799 stack, class_10442 resolver, class_811 displayContext, @Nullable class_638 world, @Nullable class_11566 ctx, int seed) {
        boolean rightHand;
        state.method_70946((Object)this);
        state.method_70947();
        RenderData data = new RenderData();
        data.animation = 0.25f;
        boolean leftHand = displayContext == class_811.field_4321;
        boolean bl = rightHand = displayContext == class_811.field_4322;
        if (leftHand || rightHand) {
            data.animation = class_3532.method_16439((float)AnimationTickHolder.getPartialTicks(), (float)ExtendoGripRenderHandler.lastMainHandAnimation, (float)ExtendoGripRenderHandler.mainHandAnimation);
        }
        data.animation = data.animation * data.animation * data.animation;
        float extensionAngle = class_3532.method_16439((float)data.animation, (float)24.0f, (float)156.0f);
        data.state = state.method_65601();
        data.state.method_67992(this.layer);
        data.state.method_67995(this.vector);
        this.settings.method_68000(data.state, displayContext);
        data.state.method_67997().addAll(this.item);
        data.halfAngle = extensionAngle / 2.0f;
        data.oppositeAngle = 180.0f - extensionAngle;
        data.hand = leftHand || rightHand ? (ExtendoGripRenderHandler.holding ? this.holding : this.punching) : this.pointing;
        data.angle = AnimationTickHolder.getRenderTime() * -2.0f;
        if (leftHand || rightHand) {
            data.angle += 360.0f * data.animation;
        }
        data.angle %= 360.0f;
        if (stack == null) {
            data.self = true;
        } else if (!stack.method_31574((class_1792)AllItems.EXTENDO_GRIP)) {
            data.item = new class_10444();
            data.item.field_55337 = displayContext;
            resolver.method_65596(data.item, stack, displayContext, (class_1937)world, ctx, seed);
            class_1306 mainArm = class_1306.field_6183;
            if (ctx instanceof class_11890) {
                class_11890 entity = (class_11890)ctx;
                mainArm = entity.method_6068();
            } else {
                class_746 player = class_310.method_1551().field_1724;
                if (player != null) {
                    mainArm = player.method_6068();
                }
            }
            data.flip = rightHand ^ mainArm == class_1306.field_6182 ? 1 : -1;
        }
        data.state.method_65617((class_10515)this, (Object)data);
    }

    public void render(RenderData data, class_811 displayContext, class_4587 matrices, class_11659 queue, int light, int overlay, boolean glint, int i) {
        assert (data != null);
        if (data.self) {
            data.self = false;
            matrices.method_22903();
            matrices.method_46416(0.45f, 0.65f, -0.7f - data.animation * 2.25f);
            this.settings.comp_3768().method_3503(displayContext).method_23075(displayContext.method_67675(), matrices.method_23760());
            this.render(data, displayContext, matrices, queue, light, overlay, glint, i);
            matrices.method_22909();
        } else if (data.item != null) {
            matrices.method_22903();
            matrices.method_46416(0.45f, 0.65f, -0.7f - data.animation * 2.25f);
            if (data.item.method_65608()) {
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)(data.flip * 45)));
                matrices.method_46416((float)data.flip * 0.15f, -0.15f, -0.05f);
                matrices.method_22905(1.25f, 1.25f, 1.25f);
            }
            data.item.method_65604(matrices, queue, light, overlay, i);
            matrices.method_22909();
        }
        class_10444.class_10446 grip = data.state;
        queue.method_73480(matrices, displayContext, light, overlay, 0, grip.field_55349, grip.method_67997(), grip.field_55347, grip.field_55348);
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.5625f, 0.0625f);
        matrices.method_22905(1.0f, 1.0f, 1.0f + data.animation);
        matrices.method_22903();
        matrices.method_22907((Quaternionfc)class_7833.field_40713.rotationDegrees(data.halfAngle));
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.thinShort);
        matrices.method_46416(0.0f, 0.34375f, 0.0f);
        matrices.method_22907((Quaternionfc)class_7833.field_40713.rotationDegrees(data.oppositeAngle));
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.wideLong);
        matrices.method_46416(0.0f, 0.6875f, 0.0f);
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(data.oppositeAngle));
        matrices.method_46416(0.0f, 0.03125f, 0.0f);
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.thinShort);
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-180.0f + data.halfAngle));
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.wideShort);
        matrices.method_46416(0.0f, 0.34375f, 0.0f);
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(data.oppositeAngle));
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.thinLong);
        matrices.method_46416(0.0f, 0.6875f, 0.0f);
        matrices.method_22907((Quaternionfc)class_7833.field_40713.rotationDegrees(data.oppositeAngle));
        matrices.method_46416(0.0f, 0.03125f, 0.0f);
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.wideShort);
        matrices.method_46416(0.0f, 0.34375f, 0.0f);
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(180.0f - data.halfAngle));
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        matrices.method_46416(0.0f, 0.0f, -0.25f);
        matrices.method_22905(1.0f, 1.0f, 1.0f / (1.0f + data.animation));
        matrices.method_46416(-1.0f, -0.5f, -0.5f);
        this.renderQuads(displayContext, matrices, queue, light, overlay, data.hand);
        matrices.method_22909();
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5625f, 0.5f);
        matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(data.angle));
        matrices.method_46416(-0.5f, -0.5625f, -0.5f);
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.cog);
        matrices.method_22909();
    }

    private void renderQuads(class_811 displayContext, class_4587 matrices, class_11659 queue, int light, int overlay, List<class_777> quads) {
        queue.method_73480(matrices, displayContext, light, overlay, 0, this.tints, quads, this.layer, class_10444.class_10445.field_55341);
    }

    public void method_72175(Set<Vector3f> vertices) {
        throw new UnsupportedOperationException();
    }

    public RenderData getData(class_1799 stack) {
        throw new UnsupportedOperationException();
    }

    @Environment(value=EnvType.CLIENT)
    public static class RenderData {
        class_10444 item;
        class_10444.class_10446 state;
        List<class_777> hand;
        float halfAngle;
        float oppositeAngle;
        float animation;
        float angle;
        boolean self;
        int flip;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Unbaked
    implements class_10439.class_10441 {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<Unbaked> method_65585() {
            return CODEC;
        }

        public void method_62326(class_10526.class_10103 resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(COG_ID);
            resolver.markDependency(THIN_SHORT_ID);
            resolver.markDependency(WIDE_SHORT_ID);
            resolver.markDependency(THIN_LONG_ID);
            resolver.markDependency(WIDE_LONG_ID);
            resolver.markDependency(DEPLOYER_HAND_POINTING);
            resolver.markDependency(DEPLOYER_HAND_PUNCHING);
            resolver.markDependency(DEPLOYER_HAND_HOLDING);
        }

        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            class_10819 model = baker.method_45872(ITEM_ID);
            class_10419 textures = model.method_68045();
            List quads = model.method_68034(textures, baker, (class_3665)class_1086.field_5350).method_68048();
            class_10809 settings = class_10809.method_68001((class_7775)baker, (class_10819)model, (class_10419)textures);
            return new ExtendoGripModel(settings, quads, Unbaked.bakeQuads(baker, COG_ID), Unbaked.bakeQuads(baker, THIN_SHORT_ID), Unbaked.bakeQuads(baker, WIDE_SHORT_ID), Unbaked.bakeQuads(baker, THIN_LONG_ID), Unbaked.bakeQuads(baker, WIDE_LONG_ID), Unbaked.bakeQuads(baker, DEPLOYER_HAND_POINTING), Unbaked.bakeQuads(baker, DEPLOYER_HAND_PUNCHING), Unbaked.bakeQuads(baker, DEPLOYER_HAND_HOLDING));
        }

        private static List<class_777> bakeQuads(class_7775 baker, class_2960 id) {
            class_10819 model = baker.method_45872(id);
            return model.method_68034(model.method_68045(), baker, (class_3665)class_1086.field_5350).method_68048();
        }
    }
}

