/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.kinetics.crank.ValveHandleBlock;
import com.zurrtum.create.content.kinetics.crusher.CrushingWheelBlock;
import com.zurrtum.create.content.kinetics.gauge.GaugeBlock;
import com.zurrtum.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.encased.EncasedShaftBlock;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlock;
import com.zurrtum.create.content.kinetics.waterwheel.WaterWheelBlockEntity;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

@Environment(value=EnvType.CLIENT)
public class KineticsScenes {
    public static void shaftAsRelay(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("shaft", "Relaying rotational force using Shafts");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        class_2338 gaugePos = util.grid().at(0, 1, 2);
        Selection gauge = util.select().position(gaugePos);
        scene.world().showSection(gauge, class_2350.field_11036);
        scene.world().setKineticSpeed(gauge, 0.0f);
        scene.idle(5);
        scene.world().showSection(util.select().position(5, 1, 2), class_2350.field_11033);
        scene.idle(10);
        for (int i = 4; i >= 1; --i) {
            if (i == 2) {
                scene.rotateCameraY(70.0f);
            }
            scene.idle(5);
            scene.world().showSection(util.select().position(i, 1, 2), class_2350.field_11033);
        }
        scene.world().setKineticSpeed(gauge, 64.0f);
        scene.effects().indicateSuccess(gaugePos);
        scene.idle(10);
        scene.overlay().showText(1000).placeNearTarget().text("Shafts will relay rotation in a straight line.").pointAt(util.vector().of(3.0, 1.5, 2.5));
        scene.idle(20);
        scene.markAsFinished();
    }

    public static void shaftsCanBeEncased(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("shaft_casing", "Encasing Shafts");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        Selection shaft = util.select().cuboid(new class_2338(0, 1, 2), new class_2382(5, 0, 2));
        Selection andesite = util.select().position(3, 1, 2);
        Selection brass = util.select().position(1, 1, 2);
        scene.world().showSection(shaft, class_2350.field_11033);
        scene.idle(20);
        EncasedShaftBlock andesiteEncased = AllBlocks.ANDESITE_ENCASED_SHAFT;
        class_1799 andesiteCasingItem = AllItems.ANDESITE_CASING.method_7854();
        scene.overlay().showControls(util.vector().topOf(3, 1, 2), Pointing.DOWN, 60).rightClick().withItem(andesiteCasingItem);
        scene.idle(7);
        scene.world().setBlocks(andesite, (class_2680)andesiteEncased.method_9564().method_11657((class_2769)EncasedShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), true);
        scene.world().setKineticSpeed(shaft, 32.0f);
        scene.idle(10);
        EncasedShaftBlock brassEncased = AllBlocks.BRASS_ENCASED_SHAFT;
        class_1799 brassCasingItem = AllItems.BRASS_CASING.method_7854();
        scene.overlay().showControls(util.vector().topOf(1, 0, 2), Pointing.UP, 60).rightClick().withItem(brassCasingItem);
        scene.idle(7);
        scene.world().setBlocks(brass, (class_2680)brassEncased.method_9564().method_11657((class_2769)EncasedShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), true);
        scene.world().setKineticSpeed(shaft, 32.0f);
        scene.idle(10);
        scene.overlay().showText(100).placeNearTarget().text("Brass or Andesite Casing can be used to decorate Shafts").pointAt(util.vector().topOf(1, 1, 2));
        scene.idle(70);
    }

    public static void cogAsRelay(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("cogwheel", "Relaying rotational force using Cogwheels");
        scene.configureBasePlate(0, 0, 5);
        class_2338 gauge = util.grid().at(4, 1, 1);
        Selection gaugeSelect = util.select().position(gauge);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.world().showSection(gaugeSelect, class_2350.field_11036);
        scene.world().setKineticSpeed(gaugeSelect, 0.0f);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 1, 3, 1, 1, 5), class_2350.field_11033);
        scene.idle(10);
        for (int i = 1; i <= 4; ++i) {
            scene.idle(5);
            if (i == 2) {
                scene.world().showSection(util.select().position(0, 1, 2), class_2350.field_11033);
            }
            scene.world().showSection(util.select().position(i, 1, 2), class_2350.field_11033);
        }
        scene.world().setKineticSpeed(gaugeSelect, 64.0f);
        scene.effects().indicateSuccess(gauge);
        scene.idle(10);
        scene.overlay().showText(60).text("Cogwheels will relay rotation to other adjacent cogwheels").pointAt(util.vector().blockSurface(util.grid().at(0, 1, 2), class_2350.field_11034));
        scene.idle(60);
        scene.world().showSection(util.select().fromTo(1, 1, 1, 2, 1, 1), class_2350.field_11035);
        scene.idle(10);
        scene.effects().rotationDirectionIndicator(util.grid().at(1, 1, 1));
        scene.effects().rotationDirectionIndicator(util.grid().at(2, 1, 1));
        scene.idle(20);
        scene.overlay().showText(100).text("Neighbouring shafts connected like this will rotate in opposite directions").placeNearTarget().attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(1, 1, 2), class_2350.field_11043));
        scene.idle(70);
    }

    public static void largeCogAsRelay(SceneBuilder builder, SceneBuildingUtil util) {
        int i;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("large_cogwheel", "Relaying rotational force using Large Cogwheels");
        scene.configureBasePlate(1, 1, 5);
        scene.world().setBlock(util.grid().at(4, 2, 3), (class_2680)AllBlocks.LARGE_COGWHEEL.method_9564().method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), false);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().layer(1), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(3, 2, 4), class_2350.field_11043);
        for (i = 3; i >= 1; --i) {
            scene.idle(5);
            if (i == 3) {
                scene.world().showSection(util.select().position(3, 2, 5), class_2350.field_11033);
            }
            scene.world().showSection(util.select().position(3, 2, i), class_2350.field_11033);
        }
        scene.overlay().showText(70).text("Large cogwheels can connect to each other at right angles").placeNearTarget().pointAt(util.vector().centerOf(3, 1, 4));
        scene.idle(70);
        scene.world().hideSection(util.select().fromTo(3, 2, 1, 3, 2, 5), class_2350.field_11035);
        scene.idle(15);
        scene.world().modifyBlock(util.grid().at(3, 2, 3), s -> (class_2680)s.method_11657((class_2769)ShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), false);
        scene.world().setKineticSpeed(util.select().fromTo(1, 2, 3, 5, 2, 3), 16.0f);
        scene.world().showSection(util.select().position(4, 2, 3), class_2350.field_11039);
        for (i = 3; i >= 1; --i) {
            scene.idle(5);
            if (i == 3) {
                scene.world().showSection(util.select().position(5, 2, 3), class_2350.field_11033);
            }
            scene.world().showSection(util.select().position(i, 2, 3), class_2350.field_11033);
        }
        scene.idle(5);
        scene.overlay().showText(90).text("It will help relaying conveyed speed to other axes of rotation").placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(1, 2, 3), class_2350.field_11039));
        scene.effects().rotationSpeedIndicator(util.grid().at(3, 1, 3));
        scene.effects().rotationSpeedIndicator(util.grid().at(4, 2, 3));
        scene.idle(60);
    }

    public static void cogsSpeedUp(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("cog_speedup", "Gearshifting with Cogs");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(5, 1, 2, 4, 1, 2), class_2350.field_11033);
        scene.idle(10);
        class_2338 lowerCog = util.grid().at(3, 1, 2);
        class_2338 upperCog = util.grid().at(3, 2, 3);
        class_2680 largeCogState = (class_2680)AllBlocks.LARGE_COGWHEEL.method_9564().method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048);
        class_2680 smallCogState = (class_2680)AllBlocks.COGWHEEL.method_9564().method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048);
        scene.world().setBlock(lowerCog, largeCogState, false);
        scene.world().setBlock(upperCog, smallCogState, false);
        class_2338 upperShaftEnd = upperCog.method_10088(3);
        class_2338 lowerShaftEnd = lowerCog.method_10088(3);
        scene.world().setKineticSpeed(util.select().fromTo(upperCog, upperShaftEnd), -64.0f);
        scene.world().showSection(util.select().fromTo(lowerCog, upperCog), class_2350.field_11034);
        scene.overlay().showText(60).text("Large and Small cogs can be connected diagonally").placeNearTarget().pointAt(util.vector().blockSurface(upperCog, class_2350.field_11039));
        scene.idle(80);
        Selection gaugesSelect = util.select().fromTo(0, 1, 2, 2, 2, 3);
        scene.world().showSection(gaugesSelect, class_2350.field_11033);
        scene.overlay().showText(80).text("Shifting from large to small cogs, the conveyed speed will be doubled").colored(PonderPalette.GREEN).attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(1, 2, 3), class_2350.field_11043));
        scene.idle(30);
        scene.effects().rotationSpeedIndicator(upperCog);
        scene.idle(60);
        scene.overlay().showText(30).sharedText("rpm32").colored(PonderPalette.FAST).placeNearTarget().pointAt(util.vector().blockSurface(upperShaftEnd, class_2350.field_11039));
        scene.idle(5);
        scene.overlay().showText(30).sharedText("rpm16").colored(PonderPalette.MEDIUM).placeNearTarget().pointAt(util.vector().blockSurface(lowerShaftEnd, class_2350.field_11039));
        scene.idle(45);
        scene.world().setKineticSpeed(util.select().fromTo(lowerCog, upperShaftEnd), 0.0f);
        ElementLink<WorldSectionElement> cogs = scene.world().makeSectionIndependent(util.select().fromTo(lowerCog, upperCog));
        scene.world().moveSection(cogs, util.vector().of(0.0, 1.0, 0.0), 5);
        scene.idle(5);
        scene.world().rotateSection(cogs, 180.0, 0.0, 0.0, 10);
        scene.idle(10);
        scene.world().setBlock(lowerCog, smallCogState, false);
        scene.world().setBlock(upperCog, largeCogState, false);
        scene.world().rotateSection(cogs, 180.0, 0.0, 0.0, 0);
        scene.world().moveSection(cogs, util.vector().of(0.0, -1.0, 0.0), 5);
        scene.idle(5);
        scene.world().setKineticSpeed(util.select().fromTo(lowerCog, lowerShaftEnd), 32.0f);
        scene.world().setKineticSpeed(util.select().fromTo(upperCog, upperShaftEnd), -16.0f);
        scene.overlay().showText(80).text("Shifting the opposite way, the conveyed speed will be halved").colored(PonderPalette.RED).attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(1, 2, 3), class_2350.field_11043));
        scene.idle(10);
        scene.effects().rotationSpeedIndicator(upperCog);
        scene.idle(80);
        scene.overlay().showText(60).sharedText("rpm8").colored(PonderPalette.SLOW).placeNearTarget().pointAt(util.vector().blockSurface(upperShaftEnd, class_2350.field_11039));
        scene.idle(5);
        scene.overlay().showText(60).sharedText("rpm16").colored(PonderPalette.MEDIUM).placeNearTarget().pointAt(util.vector().blockSurface(lowerShaftEnd, class_2350.field_11039));
        scene.idle(40);
    }

    public static void cogwheelsCanBeEncased(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("cogwheel_casing", "Encasing Cogwheels");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        Selection large1 = util.select().position(4, 1, 3);
        Selection small1 = util.select().fromTo(3, 1, 2, 3, 2, 2);
        Selection small2 = util.select().position(2, 1, 2);
        Selection large2 = util.select().fromTo(1, 1, 3, 1, 1, 4);
        Selection shaft2 = util.select().position(2, 2, 2);
        scene.world().setKineticSpeed(shaft2, 0.0f);
        scene.idle(10);
        scene.world().showSection(large1, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(small1, class_2350.field_11033);
        scene.world().showSection(small2, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(large2, class_2350.field_11034);
        scene.idle(20);
        EncasedCogwheelBlock andesiteEncased = AllBlocks.ANDESITE_ENCASED_COGWHEEL;
        class_1799 andesiteCasingItem = AllItems.ANDESITE_CASING.method_7854();
        scene.overlay().showControls(util.vector().topOf(3, 0, 2), Pointing.UP, 100).rightClick().withItem(andesiteCasingItem);
        scene.idle(7);
        scene.world().setBlocks(util.select().position(3, 1, 2), (class_2680)((class_2680)andesiteEncased.method_9564().method_11657((class_2769)EncasedCogwheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11052)).method_11657((class_2769)EncasedCogwheelBlock.TOP_SHAFT, (Comparable)Boolean.valueOf(true)), true);
        scene.world().setKineticSpeed(util.select().position(3, 1, 2), -32.0f);
        scene.idle(15);
        scene.overlay().showControls(util.vector().topOf(2, 1, 2), Pointing.DOWN, 30).rightClick().withItem(andesiteCasingItem);
        scene.idle(7);
        scene.world().setBlocks(small2, (class_2680)andesiteEncased.method_9564().method_11657((class_2769)EncasedCogwheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11052), true);
        scene.world().setKineticSpeed(small2, 32.0f);
        scene.idle(15);
        EncasedCogwheelBlock brassEncased = AllBlocks.BRASS_ENCASED_LARGE_COGWHEEL;
        class_1799 brassCasingItem = AllItems.BRASS_CASING.method_7854();
        scene.overlay().showControls(util.vector().topOf(1, 0, 3), Pointing.UP, 60).rightClick().withItem(brassCasingItem);
        scene.idle(7);
        scene.world().setBlocks(util.select().position(1, 1, 3), (class_2680)brassEncased.method_9564().method_11657((class_2769)EncasedCogwheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11052), true);
        scene.world().setKineticSpeed(util.select().position(1, 1, 3), -16.0f);
        scene.idle(10);
        scene.overlay().showText(70).placeNearTarget().attachKeyFrame().text("Brass or Andesite Casing can be used to decorate Cogwheels").pointAt(util.vector().topOf(1, 1, 3));
        scene.idle(80);
        ElementLink<WorldSectionElement> shaftLink = scene.world().showIndependentSection(shaft2, class_2350.field_11033);
        scene.idle(15);
        scene.overlay().showText(90).placeNearTarget().colored(PonderPalette.RED).attachKeyFrame().text("Components added after encasing will not connect to the shaft outputs").pointAt(util.vector().centerOf(2, 2, 2));
        scene.idle(90);
        scene.world().moveSection(shaftLink, new class_243(0.0, 0.5, 0.0), 10);
        scene.idle(10);
        scene.addKeyframe();
        class_243 wrenchHere = util.vector().topOf(2, 1, 2).method_1031(0.25, 0.0, -0.25);
        scene.overlay().showControls(wrenchHere, Pointing.RIGHT, 25).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().cycleBlockProperty(util.grid().at(2, 1, 2), (class_2769<?>)EncasedCogwheelBlock.TOP_SHAFT);
        scene.idle(15);
        scene.world().moveSection(shaftLink, new class_243(0.0, -0.5, 0.0), 10);
        scene.idle(10);
        scene.world().setKineticSpeed(shaft2, 32.0f);
        scene.effects().rotationDirectionIndicator(util.grid().at(2, 2, 2));
        scene.idle(20);
        scene.overlay().showText(90).placeNearTarget().colored(PonderPalette.GREEN).text("The Wrench can be used to toggle connections").pointAt(wrenchHere.method_1031(-0.5, 0.0, 0.5));
        scene.idle(40);
        scene.overlay().showControls(wrenchHere, Pointing.RIGHT, 25).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().cycleBlockProperty(util.grid().at(2, 1, 2), (class_2769<?>)EncasedCogwheelBlock.TOP_SHAFT);
        scene.world().setKineticSpeed(shaft2, 0.0f);
    }

    public static void gearbox(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("gearbox", "Relaying rotational force using Gearboxes");
        scene.configureBasePlate(1, 1, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.world().showSection(util.select().fromTo(4, 1, 6, 3, 2, 5), class_2350.field_11036);
        scene.idle(10);
        class_2338 largeCogBack = util.grid().at(3, 2, 4);
        class_2338 largeCogLeft = util.grid().at(4, 2, 3);
        class_2338 largeCogFront = util.grid().at(3, 2, 2);
        class_2338 largeCogRight = util.grid().at(2, 2, 3);
        scene.world().showSection(util.select().position(largeCogBack), class_2350.field_11035);
        scene.idle(5);
        scene.world().showSection(util.select().position(largeCogLeft), class_2350.field_11039);
        scene.world().showSection(util.select().position(largeCogLeft.method_10078()), class_2350.field_11039);
        scene.world().showSection(util.select().position(largeCogRight), class_2350.field_11034);
        scene.world().showSection(util.select().position(largeCogRight.method_10067()), class_2350.field_11034);
        scene.idle(5);
        scene.world().showSection(util.select().position(largeCogFront), class_2350.field_11035);
        scene.world().showSection(util.select().position(largeCogFront.method_10095()), class_2350.field_11035);
        scene.idle(10);
        scene.overlay().showText(80).colored(PonderPalette.RED).pointAt(util.vector().blockSurface(largeCogRight.method_10067(), class_2350.field_11039)).placeNearTarget().text("Jumping between axes of rotation can get bulky quickly");
        scene.idle(80);
        Selection gearbox = util.select().position(3, 2, 3);
        scene.world().hideSection(util.select().fromTo(4, 2, 2, 2, 2, 4).substract(gearbox), class_2350.field_11036);
        scene.idle(20);
        class_2680 defaultState = AllBlocks.SHAFT.method_9564();
        class_2680 cogState = AllBlocks.COGWHEEL.method_9564();
        scene.world().setBlock(largeCogBack, (class_2680)defaultState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11051), false);
        scene.world().setBlock(largeCogFront, (class_2680)defaultState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11051), false);
        scene.world().setBlock(largeCogRight, (class_2680)defaultState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), false);
        scene.world().setBlock(largeCogLeft, (class_2680)defaultState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), false);
        scene.world().showSection(util.select().fromTo(4, 2, 2, 2, 2, 4), class_2350.field_11033);
        scene.idle(20);
        scene.overlay().showText(80).colored(PonderPalette.GREEN).pointAt(util.vector().topOf(3, 2, 3)).placeNearTarget().attachKeyFrame().text("A gearbox is the more compact equivalent of this setup");
        scene.idle(90);
        scene.world().setBlock(largeCogFront.method_10095(), (class_2680)cogState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11051), true);
        scene.world().setBlock(largeCogRight.method_10067(), (class_2680)cogState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), true);
        scene.idle(10);
        scene.effects().rotationDirectionIndicator(largeCogFront.method_10095());
        scene.effects().rotationDirectionIndicator(largeCogRight.method_10067());
        scene.idle(15);
        scene.overlay().showText(60).pointAt(util.vector().of(3.0, 2.5, 3.0)).placeNearTarget().text("Shafts around corners rotate in mirrored directions");
        scene.idle(70);
        scene.world().hideSection(util.select().fromTo(1, 2, 3, 2, 2, 3), class_2350.field_11039);
        scene.world().hideSection(util.select().fromTo(4, 2, 3, 5, 2, 3), class_2350.field_11034);
        scene.world().setBlock(largeCogBack.method_10072(), (class_2680)cogState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11051), true);
        scene.idle(10);
        scene.effects().rotationDirectionIndicator(largeCogFront.method_10095());
        scene.effects().rotationDirectionIndicator(largeCogBack.method_10072());
        scene.idle(15);
        scene.overlay().showText(60).pointAt(util.vector().centerOf(3, 2, 5)).placeNearTarget().text("Straight connections will be reversed");
    }

    public static void clutch(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("clutch", "Controlling rotational force using a Clutch");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        class_2338 leverPos = util.grid().at(3, 1, 0);
        scene.world().showSection(util.select().fromTo(leverPos, leverPos.method_10072()), class_2350.field_11036);
        class_2338 gaugePos = util.grid().at(0, 1, 2);
        Selection gauge = util.select().position(gaugePos);
        scene.world().showSection(gauge, class_2350.field_11036);
        scene.world().setKineticSpeed(gauge, 0.0f);
        scene.idle(5);
        scene.world().showSection(util.select().position(5, 1, 2), class_2350.field_11033);
        scene.idle(10);
        for (int i = 4; i >= 1; --i) {
            scene.idle(5);
            scene.world().showSection(util.select().position(i, 1, 2), class_2350.field_11033);
        }
        class_2338 clutch = util.grid().at(3, 1, 2);
        scene.world().setKineticSpeed(gauge, 32.0f);
        scene.effects().indicateSuccess(gaugePos);
        scene.idle(10);
        scene.overlay().showText(50).text("Clutches will relay rotation in a straight line").placeNearTarget().pointAt(util.vector().topOf(clutch));
        scene.idle(60);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10077(2)));
        scene.effects().indicateRedstone(leverPos);
        scene.world().setKineticSpeed(util.select().fromTo(0, 1, 2, 2, 1, 2), 0.0f);
        scene.idle(10);
        scene.idle(10);
        scene.overlay().showText(50).colored(PonderPalette.RED).text("When powered by Redstone, it breaks the connection").attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(clutch));
        scene.idle(70);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10077(2)));
        scene.effects().indicateRedstone(leverPos);
        scene.world().setKineticSpeed(util.select().fromTo(0, 1, 2, 2, 1, 2), 32.0f);
        scene.effects().indicateSuccess(gaugePos);
    }

    public static void gearshift(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("gearshift", "Controlling rotational force using a Gearshift");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        class_2338 leverPos = util.grid().at(3, 1, 0);
        scene.world().showSection(util.select().fromTo(leverPos, leverPos.method_10072()), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().position(5, 1, 2), class_2350.field_11033);
        scene.idle(10);
        for (int i = 4; i >= 1; --i) {
            scene.idle(5);
            scene.world().showSection(util.select().position(i, 1, 2), class_2350.field_11033);
        }
        class_2338 gearshift = util.grid().at(3, 1, 2);
        scene.idle(10);
        scene.overlay().showText(50).placeNearTarget().text("Gearshifts will relay rotation in a straight line").pointAt(util.vector().topOf(gearshift));
        scene.idle(60);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10077(2)));
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyKineticSpeed(util.select().fromTo(0, 1, 2, 2, 2, 2), f -> Float.valueOf(-f.floatValue()));
        scene.effects().rotationDirectionIndicator(gearshift.method_10089(2));
        scene.effects().rotationDirectionIndicator(gearshift.method_10088(2));
        scene.idle(30);
        scene.overlay().showText(50).colored(PonderPalette.RED).placeNearTarget().text("When powered by Redstone, it reverses the transmission").attachKeyFrame().pointAt(util.vector().topOf(gearshift));
        for (int i = 0; i < 3; ++i) {
            scene.idle(60);
            scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10077(2)));
            scene.effects().indicateRedstone(leverPos);
            scene.world().modifyKineticSpeed(util.select().fromTo(0, 1, 2, 2, 2, 2), f -> Float.valueOf(-f.floatValue()));
            scene.effects().rotationDirectionIndicator(gearshift.method_10089(2));
            scene.effects().rotationDirectionIndicator(gearshift.method_10088(2));
        }
    }

    public static void creativeMotor(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("creative_motor", "Generating Rotational Force using Creative Motors");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        class_2338 motor = util.grid().at(3, 1, 2);
        for (int i = 0; i < 3; ++i) {
            scene.idle(5);
            scene.world().showSection(util.select().position(1 + i, 1, 2), class_2350.field_11033);
        }
        scene.idle(10);
        scene.effects().rotationSpeedIndicator(motor);
        scene.overlay().showText(50).text("Creative motors are a compact and configurable source of Rotational Force").placeNearTarget().pointAt(util.vector().topOf(motor));
        scene.idle(70);
        class_243 blockSurface = util.vector().blockSurface(motor, class_2350.field_11043).method_1031(0.0625, 0.0, 0.1875);
        scene.overlay().showFilterSlotInput(blockSurface, class_2350.field_11043, 80);
        scene.overlay().showControls(blockSurface, Pointing.DOWN, 60).rightClick();
        scene.idle(20);
        scene.overlay().showText(60).text("The generated speed can be configured on its input panels").attachKeyFrame().placeNearTarget().pointAt(blockSurface);
        scene.idle(10);
        scene.idle(50);
        scene.world().modifyKineticSpeed(util.select().fromTo(1, 1, 2, 3, 1, 2), f -> Float.valueOf(4.0f * f.floatValue()));
        scene.idle(10);
        scene.effects().rotationSpeedIndicator(motor);
    }

    public static void waterWheel(SceneBuilder builder, SceneBuildingUtil util) {
        int i;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("water_wheel", "Generating Rotational Force using Water Wheels");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 3, 3, 2, 3), class_2350.field_11033);
        scene.world().setKineticSpeed(util.select().everywhere(), 0.0f);
        class_2338 gaugePos = util.grid().at(1, 2, 2);
        for (i = 0; i < 4; ++i) {
            scene.idle(5);
            scene.world().showSection(util.select().fromTo(gaugePos.method_10089(i).method_10074(), gaugePos.method_10089(i)), class_2350.field_11033);
        }
        scene.idle(10);
        for (i = 0; i < 2; ++i) {
            scene.idle(5);
            scene.world().showSection(util.select().position(3, 3, 3 - i), class_2350.field_11033);
        }
        scene.world().setKineticSpeed(util.select().everywhere(), -8.0f);
        scene.effects().indicateSuccess(gaugePos);
        class_2338 wheel = util.grid().at(3, 2, 2);
        scene.effects().rotationSpeedIndicator(wheel);
        scene.overlay().showText(60).text("Water Wheels draw force from adjacent Water Currents").placeNearTarget().pointAt(util.vector().topOf(wheel));
        scene.idle(10);
        class_238 bb = new class_238(wheel).method_1009(0.0625, 0.0, 0.0);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.MEDIUM, new Object(), bb.method_989(0.0, 1.0, 0.0).method_1002(0.0, 0.75, 0.0), 80);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.MEDIUM, new Object(), bb.method_989(0.0, 0.0, -1.0).method_1002(0.0, 0.0, -0.75), 75);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.MEDIUM, new Object(), bb.method_989(0.0, -1.0, 0.0).method_1002(0.0, -0.75, 0.0), 70);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.MEDIUM, new Object(), bb.method_989(0.0, 0.0, 1.0).method_1002(0.0, 0.0, 0.75), 65);
        scene.idle(75);
        scene.addKeyframe();
        scene.world().showSection(util.select().position(3, 3, 1), class_2350.field_11033);
        for (int i2 = 0; i2 < 2; ++i2) {
            scene.idle(5);
            scene.world().showSection(util.select().position(3, 2 - i2, 1), class_2350.field_11033);
        }
        scene.idle(10);
        scene.overlay().showText(50).text("Covering additional sides will not improve its kinetic output further").colored(PonderPalette.RED).placeNearTarget().pointAt(util.vector().blockSurface(wheel, class_2350.field_11043));
        scene.idle(80);
        scene.addKeyframe();
        ElementLink<WorldSectionElement> water = scene.world().makeSectionIndependent(util.select().fromTo(3, 1, 1, 3, 3, 1).add(util.select().fromTo(3, 3, 2, 3, 3, 3)));
        scene.world().moveSection(water, util.vector().of(1.0, 0.5, -0.5), 15);
        scene.idle(5);
        scene.world().setKineticSpeed(util.select().everywhere(), 0.0f);
        scene.idle(5);
        class_1799 crimsonPlanks = new class_1799((class_1935)class_1802.field_22031);
        scene.overlay().showControls(util.vector().topOf(wheel), Pointing.DOWN, 20).rightClick().withItem(crimsonPlanks);
        scene.idle(7);
        scene.world().modifyBlockEntity(wheel, WaterWheelBlockEntity.class, be -> be.applyMaterialIfValid(crimsonPlanks));
        scene.overlay().showText(50).text("Use wood planks on the wheel to change its appearance").colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector().blockSurface(wheel, class_2350.field_11039));
        scene.idle(40);
        class_1799 birchPlanks = new class_1799((class_1935)class_1802.field_8191);
        scene.overlay().showControls(util.vector().topOf(wheel), Pointing.DOWN, 20).rightClick().withItem(birchPlanks);
        scene.idle(7);
        scene.world().modifyBlockEntity(wheel, WaterWheelBlockEntity.class, be -> be.applyMaterialIfValid(birchPlanks));
        scene.idle(40);
        class_1799 junglePlanks = new class_1799((class_1935)class_1802.field_8842);
        scene.overlay().showControls(util.vector().topOf(wheel), Pointing.DOWN, 20).rightClick().withItem(junglePlanks);
        scene.idle(7);
        scene.world().modifyBlockEntity(wheel, WaterWheelBlockEntity.class, be -> be.applyMaterialIfValid(junglePlanks));
        scene.idle(20);
        scene.world().moveSection(water, util.vector().of(-1.0, -0.5, 0.5), 15);
        scene.idle(10);
        scene.world().setKineticSpeed(util.select().everywhere(), -8.0f);
        scene.effects().indicateSuccess(gaugePos);
    }

    public static void largeWaterWheel(SceneBuilder builder, SceneBuildingUtil util) {
        int i;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("large_water_wheel", "Generating Rotational Force using Large Water Wheels");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0).substract(util.select().position(3, 0, 0)), class_2350.field_11036);
        ElementLink<WorldSectionElement> strip = scene.world().showIndependentSection(util.select().fromTo(1, 0, 0, 1, 0, 4), class_2350.field_11036);
        scene.world().moveSection(strip, util.vector().of(2.0, 0.0, 0.0), 0);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(3, 1, 3, 3, 2, 3), class_2350.field_11033);
        scene.world().setKineticSpeed(util.select().everywhere(), 0.0f);
        class_2338 gaugePos = util.grid().at(1, 1, 2);
        for (i = 0; i < 4; ++i) {
            scene.idle(5);
            if (i == 0) {
                scene.world().hideIndependentSection(strip, class_2350.field_11033);
            }
            scene.world().showSection(util.select().position(gaugePos.method_10089(i)), class_2350.field_11033);
        }
        scene.idle(10);
        for (i = 0; i < 3; ++i) {
            scene.idle(5);
            scene.world().showSection(util.select().position(3, 3, 3 - i), class_2350.field_11033);
        }
        scene.world().setKineticSpeed(util.select().everywhere(), -4.0f);
        scene.effects().indicateSuccess(gaugePos);
        class_2338 wheel = util.grid().at(3, 1, 2);
        scene.effects().rotationSpeedIndicator(wheel);
        scene.overlay().showText(60).text("Large Water Wheels draw force from adjacent Water Currents").placeNearTarget().pointAt(util.vector().topOf(wheel));
        scene.idle(10);
        class_238 bb = new class_238(wheel).method_1009(0.125, 1.0, 1.0);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.MEDIUM, new Object(), bb.method_989(0.0, 3.0, 0.0).method_1002(0.0, 2.75, 0.0), 80);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.MEDIUM, new Object(), bb.method_989(0.0, 0.0, -3.0).method_1002(0.0, 0.0, -2.75), 75);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.MEDIUM, new Object(), bb.method_989(0.0, -3.0, 0.0).method_1002(0.0, -2.75, 0.0), 70);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.MEDIUM, new Object(), bb.method_989(0.0, 0.0, 3.0).method_1002(0.0, 0.0, 2.75), 65);
        scene.idle(75);
        scene.addKeyframe();
        scene.world().showSection(util.select().position(3, 3, 0), class_2350.field_11033);
        for (int i2 = 0; i2 < 3; ++i2) {
            scene.idle(5);
            scene.world().showSection(util.select().position(3, 2 - i2, 0), class_2350.field_11033);
        }
        scene.idle(10);
        scene.overlay().showText(50).text("Covering additional sides will not improve its kinetic output further").colored(PonderPalette.RED).placeNearTarget().pointAt(util.vector().blockSurface(wheel, class_2350.field_11043));
        scene.idle(80);
        scene.idle(10);
        scene.overlay().showText(70).attachKeyFrame().text("These rotate only at half the speed of regular water wheels...").colored(PonderPalette.WHITE).placeNearTarget().pointAt(util.vector().blockSurface(gaugePos, class_2350.field_11043));
        scene.idle(78);
        scene.overlay().showText(60).text("...but provide a substantially higher stress capacity").colored(PonderPalette.WHITE).placeNearTarget().pointAt(util.vector().blockSurface(gaugePos, class_2350.field_11039));
        scene.idle(80);
        scene.addKeyframe();
        ElementLink<WorldSectionElement> water = scene.world().makeSectionIndependent(util.select().fromTo(3, 0, 0, 3, 3, 0).add(util.select().fromTo(3, 3, 1, 3, 3, 3)));
        scene.world().moveSection(water, util.vector().of(1.0, 0.5, -0.5), 15);
        scene.idle(5);
        scene.world().setKineticSpeed(util.select().everywhere(), 0.0f);
        class_2338 target = wheel.method_10072().method_10084();
        scene.idle(5);
        class_1799 crimsonPlanks = new class_1799((class_1935)class_1802.field_22031);
        scene.overlay().showControls(util.vector().topOf(target), Pointing.DOWN, 20).rightClick().withItem(crimsonPlanks);
        scene.idle(7);
        scene.world().modifyBlockEntity(wheel, WaterWheelBlockEntity.class, be -> be.applyMaterialIfValid(crimsonPlanks));
        scene.overlay().showText(50).text("Use wood planks on the wheel to change its appearance").colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector().blockSurface(target, class_2350.field_11039));
        scene.idle(40);
        class_1799 birchPlanks = new class_1799((class_1935)class_1802.field_8191);
        scene.overlay().showControls(util.vector().topOf(target), Pointing.DOWN, 20).rightClick().withItem(birchPlanks);
        scene.idle(7);
        scene.world().modifyBlockEntity(wheel, WaterWheelBlockEntity.class, be -> be.applyMaterialIfValid(birchPlanks));
        scene.idle(40);
        class_1799 junglePlanks = new class_1799((class_1935)class_1802.field_8842);
        scene.overlay().showControls(util.vector().topOf(target), Pointing.DOWN, 20).rightClick().withItem(junglePlanks);
        scene.idle(7);
        scene.world().modifyBlockEntity(wheel, WaterWheelBlockEntity.class, be -> be.applyMaterialIfValid(junglePlanks));
        scene.idle(20);
        scene.world().moveSection(water, util.vector().of(-1.0, -0.5, 0.5), 15);
        scene.idle(10);
        scene.world().setKineticSpeed(util.select().everywhere(), -4.0f);
        scene.effects().indicateSuccess(gaugePos);
    }

    public static void handCrank(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("hand_crank", "Generating Rotational Force using Hand Cranks");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        class_2338 gaugePos = util.grid().at(1, 3, 3);
        class_2338 handlePos = util.grid().at(2, 2, 2);
        Selection handleSelect = util.select().position(handlePos);
        scene.world().showSection(util.select().layersFrom(1).substract(handleSelect), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(handleSelect, class_2350.field_11033);
        scene.idle(20);
        class_243 centerOf = util.vector().centerOf(handlePos);
        class_243 sideOf = centerOf.method_1031(-0.5, 0.0, 0.0);
        scene.overlay().showText(70).text("Hand Cranks can be used by players to apply rotational force manually").placeNearTarget().pointAt(sideOf);
        scene.idle(80);
        scene.overlay().showControls(centerOf, Pointing.DOWN, 40).rightClick();
        scene.idle(7);
        scene.world().setKineticSpeed(util.select().everywhere(), 32.0f);
        scene.world().modifyKineticSpeed(util.select().column(1, 3), f -> Float.valueOf(f.floatValue() * -2.0f));
        scene.effects().rotationDirectionIndicator(handlePos);
        scene.effects().indicateSuccess(gaugePos);
        scene.idle(10);
        scene.overlay().showText(50).text("Hold Right-Click to rotate it Counter-Clockwise").attachKeyFrame().placeNearTarget().pointAt(sideOf);
        scene.idle(35);
        scene.world().setKineticSpeed(util.select().everywhere(), 0.0f);
        scene.idle(15);
        scene.overlay().showControls(centerOf, Pointing.DOWN, 40).rightClick().whileSneaking();
        scene.idle(7);
        scene.world().setKineticSpeed(util.select().everywhere(), -32.0f);
        scene.world().modifyKineticSpeed(util.select().column(1, 3), f -> Float.valueOf(f.floatValue() * -2.0f));
        scene.effects().rotationDirectionIndicator(handlePos);
        scene.effects().indicateSuccess(gaugePos);
        scene.idle(10);
        scene.overlay().showText(90).text("Sneak and Hold Right-Click to rotate it Clockwise").attachKeyFrame().placeNearTarget().pointAt(sideOf);
        scene.idle(35);
        scene.world().setKineticSpeed(util.select().everywhere(), 0.0f);
        scene.idle(45);
    }

    public static void valveHandle(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("valve_handle", "Precise rotation using Valve Handles");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        Selection armS = util.select().fromTo(3, 2, 3, 1, 2, 3);
        class_2338 bearing = util.grid().at(2, 2, 2);
        class_2338 valvePos = util.grid().at(2, 2, 1);
        class_243 centerOf = util.vector().centerOf(valvePos);
        class_243 sideOf = centerOf.method_1031(-0.5, 0.0, 0.0);
        class_243 topOf = centerOf.method_1031(0.0, 0.5, 0.0);
        scene.world().showSection(util.select().fromTo(bearing, bearing.method_10074()), class_2350.field_11033);
        scene.idle(3);
        ElementLink<WorldSectionElement> contraption = scene.world().showIndependentSection(armS, class_2350.field_11043);
        scene.idle(3);
        ElementLink<WorldSectionElement> valve = scene.world().showIndependentSection(util.select().position(valvePos), class_2350.field_11035);
        scene.world().rotateSection(valve, 0.0, 0.0, 45.0, 0);
        scene.idle(20);
        scene.overlay().showText(70).text("Valve handles can be used to rotate components by a precise angle").placeNearTarget().pointAt(sideOf);
        scene.idle(20);
        scene.world().rotateSection(valve, 0.0, 0.0, 45.0, 15);
        scene.world().rotateSection(contraption, 0.0, 0.0, 45.0, 15);
        scene.world().rotateBearing(bearing, 45.0f, 15);
        scene.world().setKineticSpeed(util.select().everywhere(), 16.0f);
        scene.idle(15);
        scene.world().setKineticSpeed(util.select().everywhere(), 0.0f);
        scene.idle(60);
        class_243 blockSurface = util.vector().centerOf(valvePos).method_1031(0.0, 0.0, 0.25);
        class_238 point = new class_238(blockSurface, blockSurface);
        class_238 expanded = point.method_1009(0.125, 0.125, 0.0625);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.WHITE, blockSurface, point, 1);
        scene.idle(1);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.WHITE, blockSurface, expanded, 80);
        scene.overlay().showControls(blockSurface, Pointing.DOWN, 60).rightClick();
        scene.idle(10);
        scene.overlay().showText(60).text("The angle can be configured on the input panel").attachKeyFrame().placeNearTarget().pointAt(blockSurface);
        scene.idle(70);
        scene.overlay().showControls(topOf, Pointing.DOWN, 40).rightClick();
        scene.idle(7);
        scene.world().rotateSection(valve, 0.0, 0.0, 90.0, 30);
        scene.world().rotateSection(contraption, 0.0, 0.0, 90.0, 30);
        scene.world().rotateBearing(bearing, 90.0f, 30);
        scene.world().setKineticSpeed(util.select().everywhere(), 16.0f);
        scene.idle(10);
        scene.overlay().showText(40).text("Right-Click to activate one rotation").attachKeyFrame().placeNearTarget().pointAt(sideOf);
        scene.idle(20);
        scene.world().setKineticSpeed(util.select().everywhere(), 0.0f);
        scene.idle(25);
        scene.overlay().showControls(topOf, Pointing.DOWN, 40).rightClick().whileSneaking();
        scene.idle(7);
        scene.world().rotateSection(valve, 0.0, 0.0, -90.0, 30);
        scene.world().rotateSection(contraption, 0.0, 0.0, -90.0, 30);
        scene.world().rotateBearing(bearing, -90.0f, 30);
        scene.world().setKineticSpeed(util.select().everywhere(), -16.0f);
        scene.idle(10);
        scene.overlay().showText(50).text("Sneak-Right-Click to activate it in the opposite direction").placeNearTarget().pointAt(sideOf);
        scene.idle(15);
        scene.world().setKineticSpeed(util.select().everywhere(), 0.0f);
        scene.idle(40);
        blockSurface = util.vector().topOf(bearing).method_1031(0.0, 0.0, -0.125);
        point = new class_238(blockSurface, blockSurface);
        expanded = point.method_1009(0.125, 0.0, 0.125);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.WHITE, blockSurface, point, 1);
        scene.idle(1);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.WHITE, blockSurface, expanded, 80);
        scene.idle(10);
        scene.overlay().showText(70).text("Mind that Bearings have to be specifically told not to disassemble").placeNearTarget().pointAt(blockSurface);
        scene.idle(90);
        scene.addKeyframe();
        scene.overlay().showControls(topOf, Pointing.DOWN, 40).rightClick().withItem(new class_1799((class_1935)class_1802.field_8345));
        scene.idle(7);
        scene.world().modifyBlock(valvePos, s -> (class_2680)AllBlocks.BLUE_VALVE_HANDLE.method_9564().method_11657((class_2769)ValveHandleBlock.FACING, (Comparable)class_2350.field_11043), true);
        scene.idle(10);
        scene.overlay().showText(70).text("Valve handles can be dyed for aesthetic purposes").placeNearTarget().colored(PonderPalette.BLUE).pointAt(sideOf);
        scene.idle(60);
    }

    public static void sequencedGearshift(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("sequenced_gearshift", "Controlling Rotational Speed using Sequenced Gearshifts");
        scene.configureBasePlate(1, 0, 5);
        scene.showBasePlate();
        Selection redstone = util.select().fromTo(3, 1, 0, 3, 1, 1);
        scene.world().showSection(util.select().position(6, 0, 3).add(redstone), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(6, 1, 2, 4, 1, 2), class_2350.field_11033);
        class_2338 gearshiftPos = util.grid().at(3, 1, 2);
        Selection gearshiftSelection = util.select().position(gearshiftPos);
        class_2338 bearingPos = util.grid().at(1, 1, 2);
        class_2338 buttonPos = util.grid().at(3, 1, 0);
        Selection outputKinetics = util.select().fromTo(3, 1, 2, 1, 1, 2);
        scene.world().setKineticSpeed(gearshiftSelection, 0.0f);
        scene.idle(10);
        scene.world().showSection(gearshiftSelection, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(2, 1, 2, 1, 1, 2), class_2350.field_11034);
        scene.idle(10);
        class_243 top = util.vector().topOf(gearshiftPos);
        scene.overlay().showText(60).text("Seq. Gearshifts relay rotation by following a timed list of instructions").attachKeyFrame().pointAt(top).placeNearTarget();
        scene.idle(80);
        scene.overlay().showControls(top, Pointing.DOWN, 40).rightClick();
        scene.idle(7);
        scene.overlay().showOutlineWithText(gearshiftSelection, 50).colored(PonderPalette.BLUE).text("Right-click it to open the Configuration UI").pointAt(top).placeNearTarget();
        scene.idle(60);
        ElementLink<WorldSectionElement> contraption = scene.world().showIndependentSection(util.select().fromTo(0, 3, 2, 0, 0, 2), class_2350.field_11034);
        scene.world().configureCenterOfRotation(contraption, util.vector().centerOf(bearingPos));
        scene.idle(20);
        scene.world().toggleRedstonePower(redstone);
        scene.effects().indicateRedstone(buttonPos);
        scene.world().cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world().setKineticSpeed(outputKinetics, 16.0f);
        scene.world().rotateBearing(bearingPos, 90.0f, 40);
        scene.world().rotateSection(contraption, 90.0, 0.0, 0.0, 40);
        scene.effects().rotationDirectionIndicator(gearshiftPos.method_10067());
        scene.idle(20);
        scene.world().toggleRedstonePower(redstone);
        scene.idle(20);
        scene.overlay().showText(80).text("Upon receiving a Redstone Signal, it will start running its configured sequence").attachKeyFrame().pointAt(top);
        scene.world().cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world().setKineticSpeed(outputKinetics, -32.0f);
        scene.world().rotateBearing(bearingPos, -180.0f, 40);
        scene.world().rotateSection(contraption, -180.0, 0.0, 0.0, 40);
        scene.effects().rotationDirectionIndicator(gearshiftPos.method_10067());
        scene.idle(40);
        scene.world().cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world().setKineticSpeed(outputKinetics, 0.0f);
        scene.idle(20);
        scene.world().cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world().setKineticSpeed(outputKinetics, 16.0f);
        scene.world().rotateBearing(bearingPos, 90.0f, 40);
        scene.world().rotateSection(contraption, 90.0, 0.0, 0.0, 40);
        scene.effects().rotationDirectionIndicator(gearshiftPos.method_10067());
        scene.idle(40);
        scene.world().cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world().cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world().setKineticSpeed(outputKinetics, 0.0f);
        scene.idle(20);
        scene.overlay().showText(70).text("Once finished, it waits for the next Redstone Signal and starts over").pointAt(util.vector().topOf(util.grid().at(3, 0, 1)));
        scene.idle(80);
        scene.idle(20);
        scene.world().toggleRedstonePower(redstone);
        scene.effects().indicateRedstone(buttonPos);
        scene.world().cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world().setKineticSpeed(outputKinetics, 16.0f);
        scene.world().rotateBearing(bearingPos, 90.0f, 40);
        scene.world().rotateSection(contraption, 90.0, 0.0, 0.0, 40);
        scene.effects().rotationDirectionIndicator(gearshiftPos.method_10067());
        scene.idle(20);
        scene.overlay().showText(60).text("A redstone comparator can be used to read the current progress").attachKeyFrame().pointAt(util.vector().topOf(util.grid().at(3, 0, 1)));
        scene.world().hideSection(redstone, class_2350.field_11043);
        scene.idle(15);
        class_2338 wire = util.grid().at(5, 1, 0);
        Selection nixie = util.select().position(4, 1, 0);
        scene.world().cycleBlockProperty(util.grid().at(4, 1, 0), (class_2769<?>)NixieTubeBlock.field_11177);
        scene.world().cycleBlockProperty(util.grid().at(4, 1, 0), (class_2769<?>)NixieTubeBlock.field_11177);
        ElementLink<WorldSectionElement> comparator = scene.world().showIndependentSection(util.select().fromTo(5, 1, 1, 4, 1, 0), class_2350.field_11035);
        scene.world().moveSection(comparator, util.vector().of(-2.0, 0.0, 0.0), 0);
        scene.world().toggleRedstonePower(util.select().position(5, 1, 1));
        scene.world().cycleBlockProperty(wire, (class_2769<?>)class_2457.field_11432);
        scene.world().modifyBlockEntityNBT(nixie, NixieTubeBlockEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 1));
        scene.idle(5);
        scene.world().cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world().setKineticSpeed(outputKinetics, -32.0f);
        scene.world().rotateBearing(bearingPos, -180.0f, 40);
        scene.world().rotateSection(contraption, -180.0, 0.0, 0.0, 40);
        scene.effects().rotationDirectionIndicator(gearshiftPos.method_10067());
        scene.world().cycleBlockProperty(wire, (class_2769<?>)class_2457.field_11432);
        scene.world().modifyBlockEntityNBT(nixie, NixieTubeBlockEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 2));
        scene.idle(40);
        scene.world().cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world().setKineticSpeed(outputKinetics, 0.0f);
        scene.world().cycleBlockProperty(wire, (class_2769<?>)class_2457.field_11432);
        scene.world().modifyBlockEntityNBT(nixie, NixieTubeBlockEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 3));
        scene.idle(20);
        scene.world().cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world().setKineticSpeed(outputKinetics, 16.0f);
        scene.world().rotateBearing(bearingPos, 90.0f, 40);
        scene.world().rotateSection(contraption, 90.0, 0.0, 0.0, 40);
        scene.effects().rotationDirectionIndicator(gearshiftPos.method_10067());
        scene.world().cycleBlockProperty(wire, (class_2769<?>)class_2457.field_11432);
        scene.world().modifyBlockEntityNBT(nixie, NixieTubeBlockEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 4));
        scene.idle(40);
        scene.world().cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world().cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world().modifyBlock(wire, s -> (class_2680)s.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(0)), false);
        scene.world().toggleRedstonePower(util.select().position(5, 1, 1));
        scene.world().modifyBlockEntityNBT(nixie, NixieTubeBlockEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 0));
        scene.world().setKineticSpeed(outputKinetics, 0.0f);
    }

    public static void speedController(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("rotation_speed_controller", "Using the Rotational Speed Controller");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        class_2338 cogPos = util.grid().at(1, 2, 1);
        Selection gaugeSelect = util.select().position(1, 2, 3);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 0.5f);
        scene.world().setKineticSpeed(gaugeSelect, 0.0f);
        scene.world().showSection(util.select().fromTo(5, 1, 1, 2, 1, 1), class_2350.field_11033);
        scene.world().showSection(util.select().fromTo(1, 1, 3, 1, 2, 3), class_2350.field_11033);
        scene.idle(10);
        ElementLink<WorldSectionElement> rsc = scene.world().showIndependentSection(util.select().position(0, 1, 1), class_2350.field_11033);
        scene.world().moveSection(rsc, util.vector().of(1.0, 0.0, 0.0), 0);
        ElementLink<WorldSectionElement> rsc2 = scene.world().showIndependentSection(util.select().position(1, 1, 1), class_2350.field_11033);
        scene.world().moveSection(rsc2, util.vector().of(0.0, -100.0, 0.0), 0);
        scene.idle(10);
        scene.world().showSection(util.select().position(1, 2, 1), class_2350.field_11033);
        scene.idle(15);
        scene.effects().indicateSuccess(cogPos);
        scene.world().moveSection(rsc2, util.vector().of(0.0, 100.0, 0.0), 0);
        scene.world().moveSection(rsc, util.vector().of(0.0, -100.0, 0.0), 0);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 2, 2), class_2350.field_11033);
        scene.idle(10);
        scene.world().setKineticSpeed(gaugeSelect, 8.0f);
        scene.effects().indicateSuccess(util.grid().at(1, 2, 3));
        scene.overlay().showText(90).placeNearTarget().attachKeyFrame().pointAt(util.vector().blockSurface(cogPos, class_2350.field_11043)).text("Rot. Speed Controllers relay rotation from their axis to a Large Cogwheel above them");
        scene.idle(100);
        class_243 inputVec = util.vector().of(1.5, 1.6875, 1.0);
        scene.overlay().showFilterSlotInput(inputVec, class_2350.field_11043, 60);
        scene.overlay().showText(70).placeNearTarget().attachKeyFrame().pointAt(inputVec).text("Using the value panel on its side, the conveyed speed can be configured");
        scene.idle(80);
        scene.overlay().showControls(inputVec, Pointing.UP, 40).rightClick();
        scene.idle(15);
        scene.world().multiplyKineticSpeed(util.select().fromTo(1, 2, 1, 1, 2, 3), 4.0f);
        scene.effects().rotationSpeedIndicator(cogPos);
        scene.idle(55);
        scene.markAsFinished();
        scene.overlay().showControls(inputVec, Pointing.UP, 30).rightClick();
        scene.idle(15);
        scene.world().multiplyKineticSpeed(util.select().fromTo(1, 2, 1, 1, 2, 3), 4.0f);
        scene.effects().rotationSpeedIndicator(cogPos);
        scene.idle(55);
        scene.overlay().showControls(inputVec, Pointing.UP, 30).rightClick();
        scene.idle(15);
        scene.world().multiplyKineticSpeed(util.select().fromTo(1, 2, 1, 1, 2, 3), -0.05f);
        scene.effects().rotationSpeedIndicator(cogPos);
        scene.idle(35);
    }

    public static void speedometer(SceneBuilder scene, SceneBuildingUtil util) {
        KineticsScenes.gauge(scene, util, true);
    }

    public static void stressometer(SceneBuilder scene, SceneBuildingUtil util) {
        KineticsScenes.gauge(scene, util, false);
    }

    private static void gauge(SceneBuilder builder, SceneBuildingUtil util, boolean speed) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        String component = speed ? "Speedometer" : "Stressometer";
        String title = "Monitoring Kinetic information using the " + component;
        scene.title(speed ? "speedometer" : "stressometer", title);
        scene.configureBasePlate(1, 0, 5);
        class_2338 gaugePos = util.grid().at(2, 1, 3);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        for (int x = 6; x >= 0; --x) {
            scene.idle(2);
            scene.world().showSection(util.select().position(x, 1, 3), class_2350.field_11033);
        }
        scene.idle(10);
        scene.world().setBlock(gaugePos, (class_2680)(speed ? AllBlocks.SPEEDOMETER : AllBlocks.STRESSOMETER).method_9564().method_11657((class_2769)GaugeBlock.FACING, (Comparable)class_2350.field_11036), true);
        scene.world().setKineticSpeed(util.select().position(gaugePos), 32.0f);
        scene.idle(10);
        scene.overlay().showText(80).text("The " + component + " displays the current " + (speed ? "Speed" : "Stress Capacity") + (speed ? " of attached components" : " of the attached kinetic network")).attachKeyFrame().pointAt(util.vector().topOf(gaugePos)).placeNearTarget();
        scene.idle(90);
        if (speed) {
            scene.world().multiplyKineticSpeed(util.select().everywhere(), 4.0f);
            scene.effects().rotationSpeedIndicator(util.grid().at(6, 1, 3));
            scene.idle(5);
            scene.effects().indicateSuccess(gaugePos);
        } else {
            class_2680 state = (class_2680)AllBlocks.CRUSHING_WHEEL.method_9564().method_11657((class_2769)CrushingWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048);
            scene.world().setBlock(util.grid().at(5, 1, 3), state, true);
            scene.world().setKineticSpeed(util.select().position(5, 1, 3), 32.0f);
            scene.world().modifyBlockEntityNBT(util.select().position(gaugePos), StressGaugeBlockEntity.class, nbt -> nbt.method_10548("Value", 0.5f));
            scene.effects().indicateRedstone(gaugePos);
            scene.idle(20);
            scene.world().setBlock(util.grid().at(4, 1, 3), state, true);
            scene.world().setKineticSpeed(util.select().position(4, 1, 3), 32.0f);
            scene.world().modifyBlockEntityNBT(util.select().position(gaugePos), StressGaugeBlockEntity.class, nbt -> nbt.method_10548("Value", 0.9f));
            scene.effects().indicateRedstone(gaugePos);
            scene.idle(10);
        }
        scene.idle(30);
        class_243 blockSurface = util.vector().blockSurface(gaugePos, class_2350.field_11043);
        scene.overlay().showControls(blockSurface, Pointing.RIGHT, 80).withItem(AllItems.GOGGLES.method_7854());
        scene.idle(7);
        scene.overlay().showText(80).text("When wearing Engineers' Goggles, the player can get more detailed information from the Gauge").attachKeyFrame().colored(PonderPalette.MEDIUM).pointAt(blockSurface).placeNearTarget();
        scene.idle(100);
        Selection comparator = util.select().fromTo(2, 1, 1, 2, 1, 2);
        scene.world().showSection(comparator, class_2350.field_11035);
        scene.idle(10);
        scene.world().toggleRedstonePower(comparator);
        scene.effects().indicateRedstone(util.grid().at(2, 1, 2));
        scene.idle(20);
        scene.overlay().showText(120).text("Comparators can emit analog Redstone Signals relative to the " + component + "'s measurements").attachKeyFrame().colored(PonderPalette.RED).pointAt(util.vector().centerOf(2, 1, 2).method_1031(0.0, -0.35, 0.0)).placeNearTarget();
        scene.idle(130);
        scene.markAsFinished();
    }

    public static void creativeMotorMojang(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("creative_motor_mojang", "Mojang's Enigma");
        scene.setNextUpEnabled(false);
        scene.configureBasePlate(0, 0, 15);
        scene.scaleSceneView(0.55f);
        scene.showBasePlate();
        scene.idle(15);
        scene.world().showSection(util.select().fromTo(12, 1, 7, 12, 1, 2), class_2350.field_11039);
        scene.idle(3);
        scene.world().showSection(util.select().fromTo(5, 1, 2, 7, 2, 1), class_2350.field_11034);
        scene.idle(3);
        scene.world().showSection(util.select().fromTo(7, 1, 3, 7, 1, 8), class_2350.field_11043);
        scene.idle(3);
        scene.world().showSection(util.select().position(7, 2, 8), class_2350.field_11033);
        scene.idle(3);
        scene.world().showSection(util.select().position(4, 1, 4), class_2350.field_11033);
        scene.idle(3);
        scene.world().showSection(util.select().position(4, 1, 6), class_2350.field_11033);
        scene.idle(3);
        scene.world().showSection(util.select().position(3, 1, 10), class_2350.field_11035);
        scene.idle(3);
        scene.world().showSection(util.select().position(1, 1, 11), class_2350.field_11034);
        scene.idle(3);
        scene.world().showSection(util.select().position(11, 1, 3), class_2350.field_11033);
        scene.idle(3);
        scene.world().showSection(util.select().fromTo(11, 2, 3, 11, 2, 7), class_2350.field_11043);
        scene.idle(3);
        scene.world().showSection(util.select().fromTo(8, 1, 2, 10, 1, 2), class_2350.field_11033);
        scene.idle(3);
        scene.world().showSection(util.select().position(11, 1, 2), class_2350.field_11035);
        scene.idle(3);
        scene.world().showSection(util.select().fromTo(6, 1, 8, 5, 1, 8), class_2350.field_11034);
        scene.rotateCameraY(-90.0f);
        scene.idle(3);
        scene.world().showSection(util.select().position(12, 1, 10), class_2350.field_11033);
        scene.idle(3);
        scene.world().showSection(util.select().position(11, 1, 12), class_2350.field_11033);
        scene.idle(3);
        scene.world().showSection(util.select().fromTo(8, 1, 8, 11, 1, 8), class_2350.field_11039);
        scene.idle(3);
        scene.world().showSection(util.select().fromTo(5, 2, 8, 5, 3, 8), class_2350.field_11033);
        scene.idle(3);
        scene.world().showSection(util.select().fromTo(8, 1, 5, 8, 2, 7), class_2350.field_11039);
        scene.idle(3);
        scene.world().showSection(util.select().fromTo(7, 3, 9, 8, 3, 8), class_2350.field_11036);
        scene.idle(3);
        scene.world().showSection(util.select().fromTo(6, 3, 7, 9, 3, 7).add(util.select().fromTo(6, 3, 8, 6, 3, 10)).add(util.select().fromTo(7, 3, 10, 9, 3, 10)).add(util.select().fromTo(9, 3, 7, 9, 3, 9)), class_2350.field_11033);
        scene.idle(3);
        scene.world().showSection(util.select().fromTo(10, 4, 7, 6, 4, 10), class_2350.field_11033);
        scene.idle(3);
        scene.world().showSection(util.select().fromTo(8, 1, 13, 8, 2, 11), class_2350.field_11043);
        scene.idle(3);
        scene.idle(20);
    }
}

