/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.elements;

import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.vertex.MutableVertexList;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.material.Materials;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.QuadMesh;
import com.zurrtum.create.client.flywheel.lib.model.SingleMeshModel;
import com.zurrtum.create.client.flywheel.lib.util.RendererReloadCache;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.util.SmartRecycler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1088;
import net.minecraft.class_1297;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4730;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Environment(value=EnvType.CLIENT)
public final class FireElement
extends AbstractVisual
implements SimpleDynamicVisual {
    private static final Material FIRE_MATERIAL = SimpleMaterial.builderOf(Materials.CUTOUT_UNSHADED_BLOCK).backfaceCulling(false).build();
    private static final RendererReloadCache<class_4730, Model> FIRE_MODELS = new RendererReloadCache<class_4730, Model>(texture -> new SingleMeshModel(new FireMesh(class_310.method_1551().method_72703().method_73030(texture)), FIRE_MATERIAL));
    private final class_1297 entity;
    private final class_4587 stack = new class_4587();
    private final SmartRecycler<Model, TransformedInstance> recycler;

    public FireElement(VisualizationContext ctx, class_1297 entity, float partialTick) {
        super(ctx, entity.method_73183(), partialTick);
        this.entity = entity;
        this.recycler = new SmartRecycler<Model, TransformedInstance>(this::createInstance);
    }

    private TransformedInstance createInstance(Model model) {
        TransformedInstance instance = this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, model).createInstance();
        instance.light(240);
        instance.setChanged();
        return instance;
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        this.recycler.resetCount();
        if (this.entity.method_5862()) {
            this.setupInstances(context);
        }
        this.recycler.discardExtra();
    }

    private void setupInstances(DynamicVisual.Context context) {
        double entityX = class_3532.method_16436((double)context.partialTick(), (double)this.entity.field_6038, (double)this.entity.method_23317());
        double entityY = class_3532.method_16436((double)context.partialTick(), (double)this.entity.field_5971, (double)this.entity.method_23318());
        double entityZ = class_3532.method_16436((double)context.partialTick(), (double)this.entity.field_5989, (double)this.entity.method_23321());
        class_2382 renderOrigin = this.visualizationContext.renderOrigin();
        float scale = this.entity.method_17681() * 1.4f;
        float maxHeight = this.entity.method_17682() / scale;
        float width = 1.0f;
        float y = 0.0f;
        float z = 0.0f;
        this.stack.method_34426();
        this.stack.method_22904(entityX - (double)renderOrigin.method_10263(), entityY - (double)renderOrigin.method_10264(), entityZ - (double)renderOrigin.method_10260());
        this.stack.method_22905(scale, scale, scale);
        this.stack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-context.camera().method_19330()));
        this.stack.method_46416(0.0f, 0.0f, -0.3f + (float)((int)maxHeight) * 0.02f);
        int i = 0;
        while (y < maxHeight) {
            TransformedInstance instance = ((TransformedInstance)this.recycler.get(FIRE_MODELS.get(i % 2 == 0 ? class_1088.field_5397 : class_1088.field_5370)).setTransform(this.stack).scaleX(width)).translate(0.0f, y, z);
            if (i / 2 % 2 == 0) {
                instance.scaleX(-1.0f);
            }
            instance.setChanged();
            y += 0.45f;
            width *= 0.9f;
            z += 0.03f;
            ++i;
        }
    }

    @Override
    public void _delete() {
        this.recycler.delete();
    }

    @Environment(value=EnvType.CLIENT)
    private record FireMesh(class_1058 sprite) implements QuadMesh
    {
        private static final Vector4fc BOUNDING_SPHERE = new Vector4f(0.0f, 0.5f, 0.0f, class_3532.field_15724 * 0.5f);

        @Override
        public int vertexCount() {
            return 4;
        }

        @Override
        public void write(MutableVertexList vertexList) {
            float u0 = this.sprite.method_4594();
            float v0 = this.sprite.method_4593();
            float u1 = this.sprite.method_4577();
            float v1 = this.sprite.method_4575();
            FireMesh.writeVertex(vertexList, 0, 0.5f, 0.0f, u1, v1);
            FireMesh.writeVertex(vertexList, 1, -0.5f, 0.0f, u0, v1);
            FireMesh.writeVertex(vertexList, 2, -0.5f, 1.4f, u0, v0);
            FireMesh.writeVertex(vertexList, 3, 0.5f, 1.4f, u1, v0);
        }

        private static void writeVertex(MutableVertexList vertexList, int i, float x, float y, float u, float v) {
            vertexList.x(i, x);
            vertexList.y(i, y);
            vertexList.z(i, 0.0f);
            vertexList.r(i, 1.0f);
            vertexList.g(i, 1.0f);
            vertexList.b(i, 1.0f);
            vertexList.u(i, u);
            vertexList.v(i, v);
            vertexList.light(i, 240);
            vertexList.normalX(i, 0.0f);
            vertexList.normalY(i, 1.0f);
            vertexList.normalZ(i, 0.0f);
        }

        @Override
        public Vector4fc boundingSphere() {
            return BOUNDING_SPHERE;
        }
    }
}

