/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.compat.computercraft.implementation;

import com.zurrtum.create.Create;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.compat.computercraft.events.ComputerEvent;
import com.zurrtum.create.compat.computercraft.events.KineticsChangeEvent;
import com.zurrtum.create.compat.computercraft.events.PackageEvent;
import com.zurrtum.create.compat.computercraft.events.RepackageEvent;
import com.zurrtum.create.compat.computercraft.events.SignalStateChangeEvent;
import com.zurrtum.create.compat.computercraft.events.StationTrainPresenceEvent;
import com.zurrtum.create.compat.computercraft.events.TrainPassEvent;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.observer.TrackObserver;
import com.zurrtum.create.content.trains.observer.TrackObserverBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class ComputerBehaviour
extends AbstractComputerBehaviour {
    public SyncedPeripheral<?> peripheral;
    private boolean hasAttachedComputer = false;

    public ComputerBehaviour(SmartBlockEntity be) {
        super(be);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        this.hasAttachedComputer = view.method_71433("HasAttachedComputer", false);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71472("HasAttachedComputer", this.hasAttachedComputer);
    }

    @Override
    public boolean isActive() {
        return this.peripheral != null;
    }

    @Override
    public void setHasAttachedComputer(boolean hasAttachedComputer) {
        this.hasAttachedComputer = hasAttachedComputer;
    }

    @Override
    public boolean hasAttachedComputer() {
        return this.hasAttachedComputer;
    }

    @Override
    public void queueKineticsChange(float speed, float capacity, float stress, boolean overStressed) {
        this.peripheral.prepareComputerEvent(new KineticsChangeEvent(speed, capacity, stress, overStressed));
    }

    @Override
    public void queuePackageReceived(class_1799 box) {
        this.peripheral.prepareComputerEvent(new PackageEvent(box, "package_received"));
    }

    @Override
    public void queuePackageCreated(class_1799 createdBox) {
        this.peripheral.prepareComputerEvent(new PackageEvent(createdBox, "package_created"));
    }

    @Override
    public void queueRepackage(List<BigItemStack> boxesToExport) {
        for (BigItemStack box : boxesToExport) {
            this.peripheral.prepareComputerEvent(new RepackageEvent(box.stack, box.count));
        }
    }

    @Override
    public void queueTrainPass(TrackObserver observer, boolean shouldBePowered) {
        TrackObserverBlockEntity be = (TrackObserverBlockEntity)this.blockEntity;
        if (shouldBePowered) {
            be.passingTrainUUID = observer.getCurrentTrain();
        }
        if (be.passingTrainUUID != null) {
            this.peripheral.prepareComputerEvent(new TrainPassEvent(Create.RAILWAYS.trains.get(be.passingTrainUUID), shouldBePowered));
            if (!shouldBePowered) {
                be.passingTrainUUID = null;
            }
        }
    }

    @Override
    public void queueSignalState(SignalBlockEntity.SignalState state) {
        this.peripheral.prepareComputerEvent(new SignalStateChangeEvent(state));
    }

    @Override
    public void queueStationTrain(Train imminentTrain, boolean newlyArrived, boolean trainPresent) {
        StationBlockEntity be = (StationBlockEntity)this.blockEntity;
        UUID trainId = be.imminentTrain;
        if (trainId == null && imminentTrain != null) {
            this.peripheral.prepareComputerEvent(new StationTrainPresenceEvent(StationTrainPresenceEvent.Type.IMMINENT, imminentTrain));
        }
        if (newlyArrived) {
            Train train;
            if (trainPresent) {
                this.peripheral.prepareComputerEvent(new StationTrainPresenceEvent(StationTrainPresenceEvent.Type.ARRIVAL, imminentTrain));
            } else if (trainId != null && (train = Create.RAILWAYS.trains.get(trainId)) != null) {
                this.peripheral.prepareComputerEvent(new StationTrainPresenceEvent(StationTrainPresenceEvent.Type.DEPARTURE, train));
            }
        }
    }

    @Override
    public void prepareComputerEvent(@NotNull ComputerEvent event) {
        if (this.peripheral != null) {
            this.peripheral.prepareComputerEvent(event);
        }
    }
}

