/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.AllMountedItemStorageTypeTags;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.contraption.storage.SyncedMountedStorage;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorage;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorageType;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorage;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageType;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageWrapper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import com.zurrtum.create.infrastructure.packet.s2c.MountedStorageSyncPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_3499;
import org.jetbrains.annotations.Nullable;

public class MountedStorageManager {
    private Map<class_2338, MountedItemStorage> itemsBuilder;
    private Map<class_2338, MountedFluidStorage> fluidsBuilder;
    private Map<class_2338, SyncedMountedStorage> syncedItemsBuilder;
    private Map<class_2338, SyncedMountedStorage> syncedFluidsBuilder;
    private ImmutableMap<class_2338, MountedItemStorage> allItemStorages;
    protected MountedItemStorageWrapper items;
    @Nullable
    protected MountedItemStorageWrapper fuelItems;
    protected MountedFluidStorageWrapper fluids;
    private ImmutableMap<class_2338, SyncedMountedStorage> syncedItems;
    private ImmutableMap<class_2338, SyncedMountedStorage> syncedFluids;
    private List<class_1263> externalHandlers;
    protected CombinedInvWrapper allItems;
    private int syncCooldown;
    private Set<class_2338> interactablePositions;

    public MountedStorageManager() {
        this.reset();
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.allItemStorages = ImmutableMap.copyOf(this.itemsBuilder);
        this.items = new MountedItemStorageWrapper(MountedStorageManager.subMap(this.allItemStorages, this::isExposed));
        this.allItems = this.items;
        this.itemsBuilder = null;
        ImmutableMap<class_2338, MountedItemStorage> fuelMap = MountedStorageManager.subMap(this.allItemStorages, this::canUseForFuel);
        this.fuelItems = fuelMap.isEmpty() ? null : new MountedItemStorageWrapper(fuelMap);
        ImmutableMap fluids = ImmutableMap.copyOf(this.fluidsBuilder);
        this.fluids = new MountedFluidStorageWrapper((ImmutableMap<class_2338, MountedFluidStorage>)fluids);
        this.fluidsBuilder = null;
        this.syncedItems = ImmutableMap.copyOf(this.syncedItemsBuilder);
        this.syncedItemsBuilder = null;
        this.syncedFluids = ImmutableMap.copyOf(this.syncedFluidsBuilder);
        this.syncedFluidsBuilder = null;
    }

    private boolean isExposed(MountedItemStorage storage) {
        return !storage.type.is(AllMountedItemStorageTypeTags.INTERNAL);
    }

    private boolean canUseForFuel(MountedItemStorage storage) {
        return this.isExposed(storage) && !storage.type.is(AllMountedItemStorageTypeTags.FUEL_BLACKLIST);
    }

    private boolean isInitialized() {
        return this.itemsBuilder == null;
    }

    private void assertInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("MountedStorageManager is uninitialized");
        }
    }

    protected void reset() {
        this.allItemStorages = null;
        this.items = null;
        this.fuelItems = null;
        this.fluids = null;
        this.externalHandlers = new ArrayList<class_1263>();
        this.allItems = null;
        this.itemsBuilder = new HashMap<class_2338, MountedItemStorage>();
        this.fluidsBuilder = new HashMap<class_2338, MountedFluidStorage>();
        this.syncedItemsBuilder = new HashMap<class_2338, SyncedMountedStorage>();
        this.syncedFluidsBuilder = new HashMap<class_2338, SyncedMountedStorage>();
    }

    public void addBlock(class_1937 level, class_2680 state, class_2338 globalPos, class_2338 localPos, @Nullable class_2586 be) {
        Object storage;
        MountedFluidStorageType<?> fluidType;
        Object storage2;
        MountedItemStorageType<?> itemType = MountedItemStorageType.REGISTRY.get(state.method_26204());
        if (itemType != null && (storage2 = itemType.mount(level, state, globalPos, be)) != null) {
            this.addStorage((MountedItemStorage)storage2, localPos);
        }
        if ((fluidType = MountedFluidStorageType.REGISTRY.get(state.method_26204())) != null && (storage = fluidType.mount(level, state, globalPos, be)) != null) {
            this.addStorage((MountedFluidStorage)storage, localPos);
        }
    }

    public void unmount(class_1937 level, class_3499.class_3501 info, class_2338 globalPos, @Nullable class_2586 be) {
        MountedFluidStorageType<?> expectedType;
        MountedFluidStorage fluidStorage;
        MountedItemStorageType<?> expectedType2;
        class_2338 localPos = info.comp_1341();
        class_2680 state = info.comp_1342();
        MountedItemStorage itemStorage = (MountedItemStorage)this.getAllItemStorages().get((Object)localPos);
        if (itemStorage != null && itemStorage.type == (expectedType2 = MountedItemStorageType.REGISTRY.get(state.method_26204()))) {
            itemStorage.unmount(level, state, globalPos, be);
        }
        if ((fluidStorage = (MountedFluidStorage)this.getFluids().storages.get((Object)localPos)) != null && fluidStorage.type == (expectedType = MountedFluidStorageType.REGISTRY.get(state.method_26204()))) {
            fluidStorage.unmount(level, state, globalPos, be);
        }
    }

    public void tick(AbstractContraptionEntity entity) {
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            return;
        }
        HashMap<class_2338, MountedItemStorage> items = new HashMap<class_2338, MountedItemStorage>();
        HashMap<class_2338, MountedFluidStorage> fluids = new HashMap<class_2338, MountedFluidStorage>();
        this.syncedItems.forEach((pos, storage) -> {
            if (storage.isDirty()) {
                items.put((class_2338)pos, (MountedItemStorage)((Object)storage));
                storage.markClean();
            }
        });
        this.syncedFluids.forEach((pos, storage) -> {
            if (storage.isDirty()) {
                fluids.put((class_2338)pos, (MountedFluidStorage)((Object)storage));
                storage.markClean();
            }
        });
        if (!items.isEmpty() || !fluids.isEmpty()) {
            MountedStorageSyncPacket packet = new MountedStorageSyncPacket(entity.method_5628(), items, fluids);
            ((class_3215)entity.method_73183().method_8398()).method_18754((class_1297)entity, (class_2596)packet);
            this.syncCooldown = 8;
        }
    }

    public void handleSync(MountedStorageSyncPacket packet, AbstractContraptionEntity entity) {
        ImmutableMap<class_2338, MountedItemStorage> items = this.getAllItemStorages();
        MountedFluidStorageWrapper fluids = this.getFluids();
        this.reset();
        IdentityHashMap<SyncedMountedStorage, class_2338> syncedStorages = new IdentityHashMap<SyncedMountedStorage, class_2338>();
        try {
            this.itemsBuilder.putAll((Map<class_2338, MountedItemStorage>)items);
            this.fluidsBuilder.putAll((Map<class_2338, MountedFluidStorage>)fluids.storages);
            packet.items().forEach((pos, storage) -> {
                this.itemsBuilder.put((class_2338)pos, (MountedItemStorage)storage);
                syncedStorages.put((SyncedMountedStorage)((Object)storage), (class_2338)pos);
            });
            packet.fluids().forEach((pos, storage) -> {
                this.fluidsBuilder.put((class_2338)pos, (MountedFluidStorage)storage);
                syncedStorages.put((SyncedMountedStorage)((Object)storage), (class_2338)pos);
            });
        }
        catch (Throwable t) {
            Create.LOGGER.error("An error occurred while syncing a MountedStorageManager", t);
        }
        this.initialize();
        Contraption contraption = entity.getContraption();
        syncedStorages.forEach((storage, pos) -> storage.afterSync(contraption, (class_2338)pos));
    }

    public void read(class_11368 view, boolean clientPacket, @Nullable Contraption contraption) {
        this.reset();
        try {
            view.method_71438("items").forEach(item -> {
                class_2338 pos = (class_2338)item.method_71426("pos", class_2338.field_25064).orElseThrow();
                MountedItemStorage storage = (MountedItemStorage)item.method_71426("storage", MountedItemStorage.CODEC).orElseThrow();
                this.addStorage(storage, pos);
            });
            view.method_71438("fluids").forEach(fluid -> {
                class_2338 pos = (class_2338)fluid.method_71426("pos", class_2338.field_25064).orElseThrow();
                MountedFluidStorage storage = (MountedFluidStorage)fluid.method_71426("storage", MountedFluidStorage.CODEC).orElseThrow();
                this.addStorage(storage, pos);
            });
            view.method_71426("interactable_positions", CreateCodecs.BLOCK_POS_LIST_CODEC).ifPresent(list -> {
                this.interactablePositions = new HashSet<class_2338>((Collection<class_2338>)list);
            });
        }
        catch (Throwable t) {
            Create.LOGGER.error("Error deserializing mounted storage", t);
        }
        this.initialize();
        this.afterSync(clientPacket, contraption);
    }

    public <T> void read(DynamicOps<T> ops, MapLike<T> map, boolean clientPacket, @Nullable Contraption contraption) {
        this.reset();
        try {
            ((Consumer)ops.getList(map.get("items")).getOrThrow()).accept(item -> {
                MapLike data = (MapLike)ops.getMap(item).getOrThrow();
                class_2338 pos = (class_2338)class_2338.field_25064.parse(ops, data.get("pos")).getOrThrow();
                MountedItemStorage storage = (MountedItemStorage)MountedItemStorage.CODEC.parse(ops, data.get("storage")).getOrThrow();
                this.addStorage(storage, pos);
            });
            ((Consumer)ops.getList(map.get("fluids")).getOrThrow()).accept(fluid -> {
                MapLike data = (MapLike)ops.getMap(fluid).getOrThrow();
                class_2338 pos = (class_2338)class_2338.field_25064.parse(ops, data.get("pos")).getOrThrow();
                MountedFluidStorage storage = (MountedFluidStorage)MountedFluidStorage.CODEC.parse(ops, data.get("storage")).getOrThrow();
                this.addStorage(storage, pos);
            });
            CreateCodecs.BLOCK_POS_LIST_CODEC.parse(ops, map.get("interactable_positions")).ifSuccess(list -> {
                this.interactablePositions = new HashSet<class_2338>((Collection<class_2338>)list);
            });
        }
        catch (Throwable t) {
            Create.LOGGER.error("Error deserializing mounted storage", t);
        }
        this.initialize();
        this.afterSync(clientPacket, contraption);
    }

    private void afterSync(boolean clientPacket, @Nullable Contraption contraption) {
        if (!clientPacket || contraption == null) {
            return;
        }
        this.getAllItemStorages().forEach((pos, storage) -> {
            if (storage instanceof SyncedMountedStorage) {
                SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
                synced.afterSync(contraption, (class_2338)pos);
            }
        });
        this.getFluids().storages.forEach((pos, storage) -> {
            if (storage instanceof SyncedMountedStorage) {
                SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
                synced.afterSync(contraption, (class_2338)pos);
            }
        });
    }

    public void write(class_11372 view, boolean clientPacket) {
        class_11372.class_11374 items = view.method_71476("items");
        this.getAllItemStorages().forEach((pos, storage) -> {
            if (!clientPacket || storage instanceof SyncedMountedStorage) {
                class_11372 item = items.method_71480();
                item.method_71468("pos", class_2338.field_25064, pos);
                item.method_71468("storage", MountedItemStorage.CODEC, storage);
            }
        });
        class_11372.class_11374 fluids = view.method_71476("fluids");
        this.getFluids().storages.forEach((pos, storage) -> {
            if (!clientPacket || storage instanceof SyncedMountedStorage) {
                class_11372 fluid = fluids.method_71480();
                fluid.method_71468("pos", class_2338.field_25064, pos);
                fluid.method_71468("storage", MountedFluidStorage.CODEC, storage);
            }
        });
        if (clientPacket) {
            List list = Sets.union((Set)this.getAllItemStorages().keySet(), (Set)this.getFluids().storages.keySet()).stream().toList();
            view.method_71468("interactable_positions", CreateCodecs.BLOCK_POS_LIST_CODEC, list);
        }
    }

    public <T> void write(DynamicOps<T> ops, T empty, RecordBuilder<T> map, boolean clientPacket) {
        ListBuilder items = ops.listBuilder();
        this.getAllItemStorages().forEach((pos, storage) -> {
            if (!clientPacket || storage instanceof SyncedMountedStorage) {
                RecordBuilder item = ops.mapBuilder();
                item.add("pos", pos, (Encoder)class_2338.field_25064);
                item.add("storage", storage, MountedItemStorage.CODEC);
                items.add(item.build(empty));
            }
        });
        map.add("items", items.build(empty));
        ListBuilder fluids = ops.listBuilder();
        this.getFluids().storages.forEach((pos, storage) -> {
            if (!clientPacket || storage instanceof SyncedMountedStorage) {
                RecordBuilder fluid = ops.mapBuilder();
                fluid.add("pos", pos, (Encoder)class_2338.field_25064);
                fluid.add("storage", storage, MountedFluidStorage.CODEC);
                fluids.add(fluid.build(empty));
            }
        });
        map.add("fluids", fluids.build(empty));
        if (clientPacket) {
            List list = Sets.union((Set)this.getAllItemStorages().keySet(), (Set)this.getFluids().storages.keySet()).stream().toList();
            map.add("interactable_positions", list, CreateCodecs.BLOCK_POS_LIST_CODEC);
        }
    }

    public void attachExternal(class_1263 externalStorage) {
        this.externalHandlers.add(externalStorage);
        int size = this.externalHandlers.size();
        class_1263[] all = new class_1263[size + 1];
        all[0] = this.items;
        for (int i = 0; i < size; ++i) {
            all[i + 1] = this.externalHandlers.get(i);
        }
        this.allItems = new CombinedInvWrapper(all);
    }

    public CombinedInvWrapper getAllItems() {
        this.assertInitialized();
        return this.allItems;
    }

    public ImmutableMap<class_2338, MountedItemStorage> getAllItemStorages() {
        this.assertInitialized();
        return this.allItemStorages;
    }

    public MountedItemStorageWrapper getMountedItems() {
        this.assertInitialized();
        return this.items;
    }

    @Nullable
    public MountedItemStorageWrapper getFuelItems() {
        this.assertInitialized();
        return this.fuelItems;
    }

    public MountedFluidStorageWrapper getFluids() {
        this.assertInitialized();
        return this.fluids;
    }

    public boolean handlePlayerStorageInteraction(Contraption contraption, class_1657 player, class_2338 localPos) {
        if (!(player instanceof class_3222)) {
            return this.interactablePositions != null && this.interactablePositions.contains(localPos);
        }
        class_3222 serverPlayer = (class_3222)player;
        class_3499.class_3501 info = contraption.getBlocks().get(localPos);
        if (info == null) {
            return false;
        }
        MountedStorageManager storageManager = contraption.getStorage();
        MountedItemStorage storage = (MountedItemStorage)storageManager.getAllItemStorages().get((Object)localPos);
        if (storage != null) {
            return storage.handleInteraction(serverPlayer, contraption, info);
        }
        return false;
    }

    private void addStorage(MountedItemStorage storage, class_2338 pos) {
        this.itemsBuilder.put(pos, storage);
        if (storage instanceof SyncedMountedStorage) {
            SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
            this.syncedItemsBuilder.put(pos, synced);
        }
    }

    private void addStorage(MountedFluidStorage storage, class_2338 pos) {
        this.fluidsBuilder.put(pos, storage);
        if (storage instanceof SyncedMountedStorage) {
            SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
            this.syncedFluidsBuilder.put(pos, synced);
        }
    }

    private static <K, V> ImmutableMap<K, V> subMap(Map<K, V> map, Predicate<V> predicate) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((key, value) -> {
            if (predicate.test(value)) {
                builder.put(key, value);
            }
        });
        return builder.build();
    }
}

